<?php

namespace SG\SgFaq\Controller;

use SG\SgFaq\Domain\Model\Category;
use SG\SgFaq\Domain\Repository\CategoryRepository;
use SG\SgFaq\Domain\Repository\ItemRepository;
use TYPO3\CMS\Core\Cache\CacheManager;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;
use TYPO3\CMS\Extbase\Mvc\Exception\NoSuchArgumentException;
use TYPO3\CMS\Extbase\Annotation\Inject;

class DisplayController extends ActionController {

    /**
     * categoryRepository
     *
     * @inject
     * @var \SG\SgFaq\Domain\Repository\CategoryRepository
     */
    protected $categoryRepository;

    /**
     * itemRepository
     *
     * @inject
     * @var \SG\SgFaq\Domain\Repository\ItemRepository
     */
    protected $itemRepository;

    /**
     * @var \TYPO3\CMS\Frontend\ContentObject\ContentObjectRenderer
     */
    private $contentObj;

    /**
     * @throws NoSuchArgumentException
     */
    public function indexAction() {
        $this->contentObj = $this->configurationManager->getContentObject();
        $cache = GeneralUtility::makeInstance(CacheManager::class)->getCache('sgfaq_cache');
        $cacheIdentifier = 'sg-faq-'.$this->contentObj->data['uid'];
        $activeCategory = null;

        if (($entry = $cache->get($cacheIdentifier)) === FALSE) {
            $categories = $this->categoryRepository->findAll();
            if ($categories->count() > 0){
                $this->view->assign('categories', $categories);
            }else{
                $this->view->assign('error',1);
                $this->view->assign('errorType','NO-CATEGORIES');
            }

            $this->view->assign('contentObjectUid', $this->contentObj->data['uid']);

            $entry = $this->view->render();

            $tags = array();
            $lifetime = $this->settings['defaultCacheLifetime'];

            // Save value in cache
            $cache->set($cacheIdentifier, $entry, $tags, $lifetime);
        }
        return $entry;
   }

    public function searchAction() {
        if ($this->request->hasArgument('query')) {
            $result = array();
            $a = $this->itemRepository->getSearch($this->request->getArgument('query'));
            $html = '';
            $i = 0;
            foreach ($a as $v) {
                $html.='<div class="accordion sg-accordion" id="accordion'.$i.'" itemscope itemtype="https://schema.org/FAQPage">';
                $html.='<div class="card" itemscope itemprop="mainEntity" itemtype="https://schema.org/FAQQuestion">';
                $html.='<div class="card-header collapsed" id="heading'.$i.'" data-toggle="collapse" data-target="#collapse_'.$i.'" aria-expanded="true" aria-controls="collapse_'.$i.'">';
                $html.='<span itemprop="name">';
                $html.=''.$v['question'].'';
                $html.='</span>';
                $html.='</div>';
                $html.='<div id="collapse_'.$i.'" class="collapse" aria-labelledby="heading{itemsIteration.cycle}" data-parent="#accordion'.$i.'" itemscope itemprop="acceptedAnswer" itemtype="https://schema.org/Answer">';
                $html.='<div class="card-body" itemprop="text">';
                $html.='<p>'.$v['answer'].'</p>';
                $html.='</div></div></div></div>';
                ++$i;
            }
            echo $html;
            exit;
        }
    }
}