<?php

namespace SG\SgFaq\Controller;

use SG\SgFaq\Domain\Model\Category;
use TYPO3\CMS\Core\Cache\CacheManager;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;
use TYPO3\CMS\Extbase\Mvc\Exception\NoSuchArgumentException;

class DisplayController extends ActionController {

    /**
     * categoryRepository
     *
     * @var \SG\SgFaq\Domain\Repository\CategoryRepository
     * @inject
     */
    protected $categoryRepository;

    /**
     * itemRepository
     *
     * @var \SG\SgFaq\Domain\Repository\ItemRepository
     * @inject
     */
    protected $itemRepository;

    /**
     * @var \TYPO3\CMS\Frontend\ContentObject\ContentObjectRenderer
     */
    private $contentObj;

    /**
     * @throws NoSuchArgumentException
     */
    public function indexAction() {
        $this->contentObj = $this->configurationManager->getContentObject();
        $cache = GeneralUtility::makeInstance(CacheManager::class)->getCache('sgfaq_cache');
        $cacheIdentifier = 'sg-faq-'.$this->contentObj->data['uid'];
        $activeCategory = null;

        if (($entry = $cache->get($cacheIdentifier)) === FALSE) {
            $categories = $this->categoryRepository->findAll();
            if ($categories->count() > 0){
                $this->view->assign('categories', $categories);
            }else{
                $this->view->assign('error',1);
                $this->view->assign('errorType','NO-CATEGORIES');
            }

            $entry = $this->view->render();

            $tags = array();
            $lifetime = $this->settings['defaultCacheLifetime'];

            // Save value in cache
            $cache->set($cacheIdentifier, $entry, $tags, $lifetime);
        }
        return $entry;
   }
}