<?php
namespace SG\SgEstateRealty\Controller;

use SG\SgEstateRealty\Domain\Repository\ApiRepository;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;

class RealtyLandingpageController extends ActionController
{
    private $api;
    private $dictionary;

    public function __construct() {
        $this->api              = new ApiRepository;
        $this->dictionary       = $this->getDictionary(); // switch to save into session after first call
    }

    // utils
    protected function getDictionary() {
        $this->api->project_id  = $this->settings['preset']['search']['api_project'];
        return $this->api->getDictionary()->data;
    }

    protected function getCollections($collection) {
        $data = array();
        switch($collection) {
            case 'ort':
                foreach($this->dictionary->orte as $ort) {
                    $data[$ort->id] = $ort->title;
                }
                break;
            case 'stadtteil':
                foreach($this->dictionary->stadtteile as $stadtteil) {
                    $data[$stadtteil->id] = $stadtteil->title;
                }
                break;
            case 'land':
                foreach($this->dictionary->laender as $land) {
                    $data[$land->id] = $land->title;
                }
                break;
            case 'waehrung':
                foreach($this->dictionary->waehrungen as $waehrung) {
                    $data[$waehrung->id] = $waehrung->title; // $waehrung->ISO, for EUR
                }
                break;
        }
        return $data;
    }

    protected function getPossibleArgs() {
        return array(
            'lat'           => 'floatval',
            'lng'           => 'floatval',
            'radius'        => 'intval',
            'ort'           => 'strval'
        );
    }

    protected function buildParams($args) {
        $params         = array();
        $possibleArgs   = $this->getPossibleArgs();
        if(isset($args) && !empty($args)) {
            foreach(array_keys($args) as $arg) {
                if(in_array($arg, array_keys($possibleArgs))) {
                    $func = $possibleArgs[$arg];
                    $params[$arg] = $func(strip_tags($args[$arg]));
                }
            }
        }
        return $params;
    }
    // eof utils

    // actions
    public function indexAction() {
        $this->api->project_id  = $this->settings['preset']['search']['api_project'];
        $args                   = $this->request->getArguments();
        if($args) {
            $params             = $this->buildParams($args);
            if($params) {
                foreach($this->dictionary->orte as $ort) {
                    if(strtolower($ort->title) == strtolower($params['ort'])) {
                        $_args['lat']       = $ort->lat;
                        $_args['lng']       = $ort->lng;
                        $_args['radius']    = !empty($this->settings['radius'])
                            ? $this->settings['radius']
                            : $this->settings['preset']['search']['radius'];
                        $_args['ort']       = $ort->title;
                    }
                }
                $data                       = $this->api->getRealties($_args);
                $this->view->assign('cities',       $this->getCollections('ort'));
                $this->view->assign('stadtteile',   $this->getCollections('stadtteil'));
                $this->view->assign('laender',      $this->getCollections('land'));
                $this->view->assign('realties',     $data->data);
                $this->view->assign('msg',          $data->msg);
                $this->view->assign('total',        $data->total);
                $this->view->assign('city',         $params['ort']);
            }
        }
    }
    // eof actions
}
