<?php

namespace SG\SgEstateRealty\Controller;

use SG\SgEstateRealty\Domain\Repository\ApiRepository;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;
use TYPO3\CMS\Extbase\Utility\DebuggerUtility;

class RealtyController extends ActionController
{

    private $api;
    private $dictionary;

    public function __construct() {
        $this->api              = new ApiRepository;
        $this->dictionary       = $this->getDictionary(); // switch to save into session after first call
    }

    // utils
    protected function getPossibleArgs() {
        return array(
            'query'         => 'strval',
            'address'       => 'strval',
            'lat'           => 'floatval',
            'lng'           => 'floatval',
            'radius'        => 'intval',
            'min_persons'   => 'intval',
            'max_persons'   => 'intval',
            'wbs'           => 'intval',
            'min_qm'        => 'floatval',
            'max_qm'        => 'floatval',
            'min_rooms'     => 'floatval',
            'max_rooms'     => 'floatval',
            'min_price'     => 'floatval',
            'max_price'     => 'floatval',
            'ort'           => 'intval'
        );
    }

    protected function getCollections($collection) {
        $data = array();
        switch($collection) {
            case 'ort':
                foreach($this->dictionary->orte as $ort) {
                    $data[$ort->id] = $ort->title;
                }
            break;
            case 'stadtteil':
                foreach($this->dictionary->stadtteile as $stadtteil) {
                    $data[$stadtteil->id] = $stadtteil->title;
                }
            break;
            case 'land':
                foreach($this->dictionary->laender as $land) {
                    $data[$land->id] = $land->title;
                }
            break;
            case 'waehrung':
                foreach($this->dictionary->waehrungen as $waehrung) {
                    $data[$waehrung->id] = $waehrung->title; // $waehrung->ISO, for EUR
                }
            break;
        }
        return $data;
    }

    protected function getDictionary() {
        $this->api->project_id  = $this->settings['preset']['search']['api_project'];
        return $this->api->getDictionary()->data;
    }

    protected function buildParams($args) {
        $params         = array();
        $possibleArgs   = $this->getPossibleArgs();
        if(isset($args) && !empty($args)) {
            foreach(array_keys($args) as $arg) {
                if(in_array($arg, array_keys($possibleArgs))) {
                    $func = $possibleArgs[$arg];
                    $params[$arg] = $func(strip_tags($args[$arg]));
                }
            }
        }
        return $params;
    }
    // eof utils

    // actions
    public function searchAction() {
        $this->api->project_id  = $this->settings['preset']['search']['api_project'];
        $data                   = $this->api->getRealties(array());
        $cities                 = $this->getCollections('ort');
        $centers                = $this->dictionary->orte;
        $orte                   = array();
        $tmp                    = array();
        $args                   = $this->request->getArguments();
        $params                 = $this->buildParams($args);
        foreach($centers as $center)
            $tmp[$center->id]   = $center;
        foreach($data->data as $realty)
            if($tmp[$realty->objekt_ort]->lat && $tmp[$realty->objekt_ort]->lng) // remove line, if you have all centers !!!
                $orte[]         = $realty->objekt_ort;
        $this->view->assign('orte',         array_unique($orte));
        $this->view->assign('cities',       $cities);
        $this->view->assign('centers',      $centers);
        $this->view->assign('params',       $params);
        $this->view->assign('realties',     $data->data);
    }

    public function listAction() {
        $this->api->project_id  = $this->settings['preset']['search']['api_project'];
        $args                   = $this->request->getArguments();
        $params                 = $this->buildParams($args);
        $data                   = $this->api->getRealties($params);
        $this->view->assign('cities',       $this->getCollections('ort'));
        $this->view->assign('stadtteile',   $this->getCollections('stadtteil'));
        $this->view->assign('laender',      $this->getCollections('land'));
        $this->view->assign('realties',     $data->data);
        $this->view->assign('msg',          $data->msg);
        $this->view->assign('total',        $data->total);
    }

    public function detailAction() {
        $this->api->project_id      = $this->settings['preset']['search']['api_project'];
        if($this->request->hasArgument('realty')) {
            $params = array();
            $params['extern_id']    = $this->request->getArgument('realty');
            if($this->request->hasArgument('lat') && $this->request->hasArgument('lng')) {
                $params['lat']      = $this->request->getArgument('lat');
                $params['lng']      = $this->request->getArgument('lng');
            }
            $data                   = $this->api->getRealty($params);
            $this->view->assign('cities',       $this->getCollections('ort'));
            $this->view->assign('stadtteile',   $this->getCollections('stadtteil'));
            $this->view->assign('laender',      $this->getCollections('land'));
            $this->view->assign('realty',       $data->data);
            $this->view->assign('msg',          $data->msg);
        }
    }

    public function contactAction() {
        $this->api->project_id          = $this->settings['preset']['search']['api_project'];
        if($_SERVER['REQUEST_METHOD'] == 'POST') {
            $params                     = $_POST;
            unset($params['tx_sgestaterealty_pi1']);
            $this->api->sendMail($params);
            $this->view->assign('sent', 1);
        } else {
            if ($this->request->hasArgument('realty')) {
                $params                 = array();
                $params['extern_id']    = $this->request->getArgument('realty');
                $data                   = $this->api->getRealty($params);
                $form                   = null;
                $forms = $this->api->getForms($this->project_id)->data;
                foreach ($forms as $f)
                    if ($this->settings['preset']['search']['api_form'] == $f->id)
                        $form           = $f->fields;
                foreach ($form as $i => $tmp)
                    if(!is_array($tmp->options))
                        $form[$i]->options  = json_decode($tmp->options);
                $this->view->assign('realty',   $data->data);
                $this->view->assign('msg',      $data->msg);
                $this->view->assign('form',     $form);
                $this->view->assign('sent',     0);
            }
        }
    }
    // eof actions
}