<?php

namespace SG\SgEstateRealty\Hooks;

class PageLayoutView implements \TYPO3\CMS\Backend\View\PageLayoutViewDrawItemHookInterface
{
    public function preProcess(\TYPO3\CMS\Backend\View\PageLayoutView &$parentObject, &$drawItem, &$headerContent, &$itemContent, array &$row)
    {
        $controllerAction = '';
        if ($row['list_type'] !== 'sgestaterealty_pi1') {
            return;
        }

        $drawItem = false;

        $flexform = $row['pi_flexform'];

        $xml = simplexml_load_string($flexform);

        foreach ($xml->data->sheet->language->children() as $field) {
            if ((isset($field['index']))&&($field['index'] == 'switchableControllerActions')) {
                $controllerAction = strval($field->value);
            }
        }

        switch ($controllerAction) {
            case 'Realty->search':
                $additionalHeaderContent = ' - Suchbox';
                break;
            case 'Realty->list':
                $additionalHeaderContent = ' - Suchergebnis';
                break;
            case 'Realty->detail':
                $additionalHeaderContent = ' - Exposee';
                break;
            case 'Realty->contact':
                $additionalHeaderContent = ' - Anfrage';
                break;
            default:
                $additionalHeaderContent = '';
                break;
        }

        $headerContent = '<b>sg.estate.realty' . $additionalHeaderContent . '</b><br>';
    }
}
