<?php
namespace SG\SgEstateRealty\Controller;

use SG\SgEstateRealty\Domain\Repository\ApiRepository;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface;

class RealtySetsController extends ActionController
{
    private $api;

    public function __construct() {
        $this->api              = new ApiRepository;
    }

    // utils
    public function getSetsForSelect(array &$configuration)
    {
        $objectManager = GeneralUtility::makeInstance('TYPO3\\CMS\Extbase\\Object\\ObjectManager');
        $configurationManager = $objectManager->get('TYPO3\\CMS\\Extbase\\Configuration\\ConfigurationManager');
        $extbaseFrameworkConfiguration = $configurationManager->getConfiguration(ConfigurationManagerInterface::CONFIGURATION_TYPE_FULL_TYPOSCRIPT);
        $project_id = $extbaseFrameworkConfiguration['plugin.']['tx_sgestaterealty_pi3.']['settings.']['preset.']['search.']['api_project'];
        $this->api->project_id  = $project_id;
        $arr = [];
        foreach($this->api->getRealties([])->data as $realty)
            $arr[] = $realty->objekt_ort;
        $dictionary = $this->api->getDictionary();
        foreach($dictionary->data->orte as $ort)
            if(in_array($ort->id, array_unique($arr)))
                $configuration['items'][] = [$ort->title, $ort->id];
    }

    protected function getDictionary() {
        $this->api->project_id  = $this->settings['preset']['search']['api_project'];
        return $this->api->getDictionary()->data;
    }

    protected function getCollections($collection) {
        $data = array();
        switch($collection) {
            case 'ort':
                foreach($this->dictionary->orte as $ort) {
                    $data[$ort->id] = $ort->title;
                }
                break;
            case 'stadtteil':
                foreach($this->dictionary->stadtteile as $stadtteil) {
                    $data[$stadtteil->id] = $stadtteil->title;
                }
                break;
            case 'land':
                foreach($this->dictionary->laender as $land) {
                    $data[$land->id] = $land->title;
                }
                break;
            case 'waehrung':
                foreach($this->dictionary->waehrungen as $waehrung) {
                    $data[$waehrung->id] = $waehrung->title; // $waehrung->ISO, for EUR
                }
                break;
        }
        return $data;
    }
    // eof utils

    // actions
    public function indexAction()
    {
        $this->api->project_id  = $this->settings['preset']['search']['api_project'];
        $cities = explode(',', $this->settings['sets']);
        $realties = [];
        foreach ($this->api->getRealties([])->data as $realty)
            if(in_array($realty->objekt_ort, array_map('trim', $cities)))
                $realties[] = $realty;
        $this->view->assign('cities',       $this->getCollections('ort'));
        $this->view->assign('total',        count($realties));
        $this->view->assign('realties',     $realties);
    }
    // eof actions
}
