<?php

namespace SG\SgEstateRealty\Util;

abstract class ApiClient {

    protected $debug 	= false;
    protected $ssl 		= false;
    protected $url 		= 'https://api.hl-1.smply.gd.codes';
    protected $delay 	= 7200;

    public $json 	    = false;
    public $headers 	= array(); //array('Accept: application/json',);
    public $pareams 	= array();
    public $method;
    public $action;
    public $response;
    public $code;

    public function request() {
        if($this->debug)
            $streamVerboseHandle      = fopen('php://temp', 'w+');
        $curl                         = curl_init();
        $this->url                   .= '/' . $this->action;
        switch($this->method) {
            case 'POST':
                curl_setopt($curl, CURLOPT_POST,            true);
                curl_setopt($curl, CURLOPT_POSTFIELDS,      $this->json ? json_encode($this->params) : $this->params);
                break;
            case 'PUT':
                curl_setopt($curl, CURLOPT_CUSTOMREQUEST,   $this->method);
                curl_setopt($curl, CURLOPT_POSTFIELDS,      $this->json ? json_encode($this->params) : $this->params);
                break;
            case 'PATCH':
                curl_setopt($curl, CURLOPT_CUSTOMREQUEST,   $this->method);
                curl_setopt($curl, CURLOPT_POSTFIELDS,      $this->json ? json_encode($this->params) : $this->params);
                break;
            case 'DELETE':
                curl_setopt($curl, CURLOPT_CUSTOMREQUEST,   $this->method);
                if($this->params)
                    $this->url      .= '?' . http_build_query($this->params);
                break;
            case 'GET':
                if($this->params)
                    $this->url      .= '?' . http_build_query($this->params);
                break;
        }
        curl_setopt($curl,        CURLOPT_URL, 			    $this->url);
        curl_setopt($curl,        CURLOPT_HTTPHEADER, 		$this->headers);
        curl_setopt($curl,        CURLOPT_RETURNTRANSFER, 	true);
        curl_setopt($curl,        CURLOPT_SSL_VERIFYHOST, 	$this->ssl);
        curl_setopt($curl,        CURLOPT_SSL_VERIFYPEER, 	$this->ssl);
        //curl_setopt($curl, CURLOPT_HTTPHEADER,        array("Expect:  "));
        if($this->debug) {
            curl_setopt($curl,    CURLOPT_VERBOSE,          true);
            curl_setopt($curl,    CURLOPT_STDERR,           $streamVerboseHandle);
        }
        $result = curl_exec($curl);
        $this->response           = json_decode($result);
        $this->code               = curl_getinfo($curl);
        if($this->debug) {
            if ($result === FALSE)
                printf("cUrl error (#%d): %s<br>\n", curl_errno($curl), htmlspecialchars(curl_error($curl)));
            rewind($streamVerboseHandle);
            $verboseLog = stream_get_contents($streamVerboseHandle);
            echo "cUrl verbose information:\n", "<pre>", htmlspecialchars($verboseLog), "</pre>\n";
        }
        curl_close($curl);
    }

    abstract protected function get();
    abstract protected function move();
    abstract protected function update();
    abstract protected function create();
    abstract protected function delete();
    abstract protected function info();

}
