<?php

namespace SG\SgEstateRealty\Domain\Repository;

use \SG\SgEstateRealty\Util\Api;

class ApiRepository extends Api {

    public $project_id = null;

    public function __construct() {
        session_cache_limiter('none');
        session_start();
    }

    protected function is_serialized($data, $strict=true) {
        if(!is_string($data))
            return false;
        $data = trim($data);
        if ('N;' === $data)
            return true;
        if(strlen($data) < 4)
            return false;
        if(':' !== $data[1])
            return false;
        if($strict) {
            $lastc = substr($data, -1);
            if(';' !== $lastc && '}' !== $lastc)
                return false;
        } else {
            $semicolon = strpos($data, ';');
            $brace     = strpos($data, '}');
            if(false === $semicolon && false === $brace)
                return false;
            if(false !== $semicolon && $semicolon < 3)
                return false;
            if(false !== $brace && $brace < 4)
                return false;
        }
        $token = $data[0];
        switch($token) {
            case 's':
                if($strict) {
                    if('"' !== substr($data, -2, 1))
                        return false;
                } elseif (true !== strpos($data, '"')) {
                    return false;
                }
            case 'a':
            case 'O':
                return (bool) preg_match("/^{$token}:[0-9]+:/s", $data);
            case 'b':
            case 'i':
            case 'd':
                $end = $strict ? '$' : '';
                return (bool) preg_match("/^{$token}:[0-9.E+-]+;$end/", $data);
        }
        return false;
    }

    protected function getFromSession($key) {
        if($data = $_SESSION[$key]) {
            if(!empty($data)) {
                if($this->is_serialized($data))
                    return unserialize($data);
                else
                    return $data;
            }
        }
        return null;
    }

    protected function setToSession($key, $value) {
        $_SESSION[$key] = is_array($value)
            ? serialize($value)
            : $value;
    }

    public function getProjects() {
        $key = 'projects';
        $ses = $this->getFromSession($key);
        if(is_null($ses)) {
            $action 												= 'project';
            $api 													= new Api();
            $api->method 											= 'GET';
            $api->params 											= array();
            $api->action 											= $action;
            $api->request();
            $ses = $api->response;
            $this->setToSession($key, $ses);
        }
        return $ses;
    }

    public function getDictionary() {
        $key = 'dictionary';
        $ses = $this->getFromSession($key);
        if(is_null($ses)) {
            $action = 'dictionary';
            $api = new Api();
            $api->method = 'GET';
            $api->params = null !== $this->project_id
                ? array('project_id' => $this->project_id)
                : array();
            $api->action = $action;
            $api->request();
            $ses = $api->response;
            $this->setToSession($key, $ses);
        }
        return $ses;
    }

    public function getForms() {
        $key = 'forms';
        $ses = $this->getFromSession($key);
        if(is_null($ses)) {
            $action = 'form';
            $api = new Api();
            $api->method = 'GET';
            $api->params = null !== $this->project_id
                ? array('project_id' => $this->project_id)
                : array();
            $api->action = $action;
            $api->request();
            $ses = $api->response;
            $this->setToSession($key, $ses);
        }
        return $ses;
    }

    public function sendMail($params) {
        $action 												= 'form';
        $api 													= new Api();
        $api->method 											= 'POST';
        $api->params 											= $params;
        $api->action 											= $action;
        $api->request();
        return $api->response;
    }

    public function getRealty($params) {
        $key = 'realty';
        $ses = $this->getFromSession($key);
        if(is_null($ses)) {
            $action 												= 'realty';
            $api 													= new Api();
            $api->method 											= 'GET';
            $api->params 											= array_merge(array('project_id' => $this->project_id), $params);
            $api->action 											= $action;
            $api->request();
            $ses = $api->response;
            $this->setToSession($key, $ses);
        }
        return $ses;
    }

    public function getRealties($params=array()) {
        $key = 'realties';
        $ses = $this->getFromSession($key);
        if(is_null($ses)) {
            $action 												= 'realty';
            $api 													= new Api();
            $api->method 											= 'GET';
            $api->params 											= array_merge(array('project_id' => $this->project_id), $params);
            $api->action 											= $action;
            $api->request();
            $ses = $api->response;
            $this->setToSession($key, $ses);
        }
        return $ses;
    }

}