<?php

namespace SG\SgEstateMap\Util;

use SG\SgEstateMap\Domain\Model\Map;
use SG\SgEstateMap\Domain\Repository\MapRepository;

class AddFields implements \TYPO3\CMS\Core\SingletonInterface
{

    /**
     * @var \TYPO3\CMS\Extbase\Object\ObjectManager
     */
    protected $objectManager;

    public function __construct()
    {
        $pluginConfiguration = [
            'vendorName' => 'SG',
            'extensionName' => 'sgestatemap',
            'pluginName' => 'MapDetail',
        ];

        $bootstrap = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\CMS\Extbase\Core\Bootstrap');
        $bootstrap->initialize($pluginConfiguration);

        $this->objectManager = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\CMS\Extbase\Object\ObjectManager');
    }

    /**
     *
     * Returns all activated maps for flexform
     *
     * @param $config
     * @return mixed
     */
    public function addMaps($config)
    {
        /** @var MapRepository $mapRepository */
        $mapRepository = $this->objectManager->get(MapRepository::class);
        $optionList = [
            ['Keine',''],
        ];

        /** @var Map $item */
        $maps = $mapRepository->findAll();
        foreach ($mapRepository->findAll() as $item) {
            $optionList[] = [
                0 => $item->getName(),
                1 => $item->getUid(),
            ];
        }
        $config['items'] = array_merge($config['items'], $optionList);
        return $config;
    }
}
