<?php

namespace SG\SgEstateMap\Controller;

use SG\SgEstateMap\Domain\Model\Marker;
use SG\SgEstateMap\Domain\Repository\MapRepository;
use SG\SgEstateMap\Domain\Repository\MarkerRepository;

class ManagementController extends \TYPO3\CMS\Extbase\Mvc\Controller\ActionController
{

    /** @var MapRepository */
    private $mapRepository;

    public function injectMapRepository(MapRepository $mapRepository)
    {
        $this->mapRepository= $mapRepository;
    }

    /** @var MarkerRepository */
    private $markerRepository;

    public function injectMarkerRepository(MarkerRepository $markerRepository)
    {
        $this->markerRepository = $markerRepository;
    }

    public function manageMapsAction(): void
    {
        $maps = $this->mapRepository->findAll();

        $this->view->assignMultiple([
            'maps' => $maps,
        ]);
    }

    public function manageMarkersAction(): void
    {
        $map = null;
        if ($this->request->hasArgument('map')) {
            $map = $this->mapRepository->findByUid($this->request->getArgument('map'));
        }

        $this->view->assignMultiple([
            'map' => $map,
        ]);
    }

    public function saveMarkersAction(): void
    {
        if ($this->request->hasArgument('map')) {
            $entries = $this->request->getArgument('markers');
            foreach ($entries as $key => $value) {
                /** @var Marker $marker */
                $marker = $this->markerRepository->findByUid($key);
                $marker->setPositionX($value[ 'x' ]);
                $marker->setPositionY($value[ 'y' ]);
                $this->markerRepository->update($marker);
            }

            $this->addFlashMessage(
                'We successfully saved your map markers.',
                'Markers saved.',
                $severity = \TYPO3\CMS\Core\Messaging\AbstractMessage::OK,
                $storeInSession = true
            );

            $this->redirect(
                'manageMarkers',
                null,
                null,
                [
                    'map' => $this->request->getArgument('map')
                ]
            );
        }
    }
}
