<?php
namespace SG\SgEstateMap\ViewHelpers;

use SG\SgEstateCore\Domain\Model\Immobilie;
use SG\SgEstateMap\Domain\Model\Map;
use SG\SgEstateMap\Domain\Model\Marker;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class GetMarkersViewHelper extends AbstractViewHelper
{

    public function initializeArguments()
    {
        parent::initializeArguments();
        $this->registerArgument('map', 'object', 'Map we need to search for estate item');
        $this->registerArgument('estateItem', 'object', 'Estate item we shopuld find');
    }

    public function render(){
        if(!$this->arguments['map'] instanceof Map || !$this->arguments['estateItem'] instanceof Immobilie) {
            return [];
        }

        $estateItem = $this->arguments['estateItem'];
        $makers = [];
        /** @var Marker $marker */
        foreach($this->arguments['map']->getMarkers() as $marker) {
            if($marker->hasEstateItem($estateItem)) {
                $makers[] = $marker;
            }
        }
        return $makers;
    }
}