<?php
namespace SG\SgEstateMap\ViewHelpers;

use SG\SgEstateCore\Domain\Model\Immobilie;
use SG\SgEstateMap\Domain\Model\Map;
use SG\SgEstateMap\Domain\Model\Marker;
use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class MarkersClassListViewHelper extends AbstractViewHelper
{

    public function initializeArguments()
    {
        parent::initializeArguments();
        $this->registerArgument('markers', 'array', 'Markers that should be flattened as a class list', true);
        $this->registerArgument('prefix', 'string', 'Class prefix.', true);
    }

    public function render(){
        $prefix = $this->arguments['prefix'];
        $strings = [];
        /** @var Marker $marker */
        foreach($this->arguments['markers'] as $marker) {
            $strings[] = $prefix.$marker->getUid();
        }
        return implode(' ', $strings);
    }
}