<?php

namespace SG\SgEstateMap\Domain\Model;

use SG\SgEstateCore\Domain\Model\Immobilie;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

class Marker extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity
{

    /** @var string  */
    protected $name = '';

    /** @var string  */
    protected $shortName = '';

    /** @var float  */
    protected $positionX = 0.0;

    /** @var float  */
    protected $positionY = 0.0;

    /**
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateCore\Domain\Model\Immobilie>
     */
    protected $estateItems = null;

    public function __construct()
    {
        $this->estateItems = new ObjectStorage();
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName(string $name): void
    {
        $this->name = $name;
    }

    /**
     * @return string
     */
    public function getShortName(): string
    {
        return $this->shortName;
    }

    /**
     * @param string $shortName
     */
    public function setShortName(string $shortName): void
    {
        $this->shortName = $shortName;
    }

    /**
     * @return float
     */
    public function getPositionX(): float
    {
        return $this->positionX;
    }

    /**
     * @param float $positionX
     */
    public function setPositionX(float $positionX): void
    {
        $this->positionX = $positionX;
    }

    /**
     * @return float
     */
    public function getPositionY(): float
    {
        return $this->positionY;
    }

    /**
     * @param float $positionY
     */
    public function setPositionY(float $positionY): void
    {
        $this->positionY = $positionY;
    }

    /**
     * @return ObjectStorage
     */
    public function getEstateItems(): ?ObjectStorage
    {
        return $this->estateItems;
    }

    /**
     * @param ObjectStorage $estateItems
     */
    public function setEstateItems(?ObjectStorage $estateItems): void
    {
        $this->estateItems = $estateItems;
    }

    /**
     * @param Immobilie $estateItem
     */
    public function addEstateItem(Immobilie $estateItem): void
    {
        $this->estateItems->attach($estateItem);
    }

    /**
     * @param Immobilie $estateItem
     */
    public function removeEstateItem(Immobilie $estateItem): void
    {
        $this->estateItems->detach($estateItem);
    }

    public function hasEstateItem(Immobilie $estateItem): bool
    {
        /** @var Immobilie $item */
        foreach($this->getEstateItems() as $item) {
            if($item->getUid() === $estateItem->getUid()) {
               return true;
            }
        }
        return false;
    }
}
