define(['jquery', 'datatables', 'moment'], function ($) {

  window.SGMapBackend = (function(){
    var app = {};
    var _init = false;
    var valueLeft = 0;
    var valueTop = 0;
    var activeEntryUid = 0;
    var $map = false;

    app.init = function(){

      if( _init ){ return; }
      _init = true;

      $map = $( '.custom-map__map' );

      $map.on( 'mousemove', function( event ){
        var $this = $( this );
        var mapOffset = $this.offset();
        var mapWidth = $this.width();
        var mapHeight = $this.height();

        valueLeft = ((100 * (event.pageX - mapOffset.left)) / mapWidth).toFixed( 2 );
        valueTop = ((100 * (event.pageY - mapOffset.top)) / mapHeight).toFixed( 2 );

        $( '.js-sg-map-position-x-display' ).html( valueLeft + '%' );
        $( '.js-sg-map-position-y-display' ).html( valueTop + '%' );
      } );

      $map.on( 'click', function(){
        if( $.isNumeric( activeEntryUid ) && activeEntryUid > 0 )
        {
          var $entry = $( '#customMapMarker' + activeEntryUid );
          $entry.css( 'left', valueLeft + '%' ).css( 'top', valueTop + '%' );
          $entry.find( '.custom-map__position-x' ).val( valueLeft );
          $entry.find( '.custom-map__position-y' ).val( valueTop );
          $entry.removeClass( 'custom-map__marker--active' );
          $( '.js-sg-map-position-name-display' ).html( 'none' );
          activeEntryUid = 0;
        }
      } );

      $( '.custom-map' ).on( 'dblclick', '.custom-map__marker', function(){
        $( '.custom-map__marker' ).removeClass( 'active-item' );
        var $entry = $( this );
        $entry.addClass( 'custom-map__marker--active' );
        activeEntryUid = $entry.attr( 'data-uid' );
        $( '.js-sg-map-position-name-display' ).html( $entry.attr( 'title' ) + ' (' + $entry.attr( 'data-uid' ) + ')' );
      } );

    };

    return app;

  })();

  $( document ).ready( function(){
    window.SGMapBackend.init();
  });

})
