<?php

namespace SG\SgEstateMap\Domain\Model;

use SG\SgEstateCore\Domain\Model\Immobilie;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

class Map extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity
{

    /** @var string  */
    protected $name = '';

    /**
     * @var \TYPO3\CMS\Extbase\Domain\Model\FileReference
     * @cascade remove
     */
    protected $image = null;

    /**
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\SG\SgEstateMap\Domain\Model\Marker>
     */
    protected $markers = null;

    public function __construct()
    {
        $this->markers = new ObjectStorage();
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName(string $name): void
    {
        $this->name = $name;
    }

    /**
     * @return \TYPO3\CMS\Extbase\Domain\Model\FileReference
     */
    public function getImage(): ?\TYPO3\CMS\Extbase\Domain\Model\FileReference
    {
        return $this->image;
    }

    /**
     * @param \TYPO3\CMS\Extbase\Domain\Model\FileReference $image
     */
    public function setImage(?\TYPO3\CMS\Extbase\Domain\Model\FileReference $image): void
    {
        $this->image = $image;
    }

    /**
     * @return ObjectStorage
     */
    public function getMarkers(): ?ObjectStorage
    {
        return $this->markers;
    }

    /**
     * @param ObjectStorage $markers
     */
    public function setMarkers(?ObjectStorage $markers): void
    {
        $this->markers = $markers;
    }

    /**
     * @param Marker $marker
     */
    public function addMarker(Marker $marker): void
    {
        $this->markers->attach($marker);
    }

    /**
     * @param Marker $marker
     */
    public function removeMarker(Marker $marker): void
    {
        $this->markers->detach($marker);
    }

    public function getAllEstateItems(): array
    {
        $estateItems = [];
        /** @var Marker $marker */
        foreach( $this->getMarkers() as $marker ) {
            /** @var Immobilie $item */
            foreach( $marker->getEstateItems() as $item ) {
                if( array_key_exists($item->getUid(), $estateItems) === false ) {
                    $estateItems[$item->getUid()] = $item;
                }
            }
        }
        return array_values($estateItems);
    }

    public function getAllEstateItemsCount(): int
    {
        return count( $this->getAllEstateItems() );
    }
}
