<?php
return [
    'ctrl' => [
        'title' => 'LLL:EXT:sg_estate_map/Resources/Private/Language/locallang_db.xlf:tx_sgestatemap_domain_model_marker',
        'label' => 'name',
        'tstamp' => 'tstamp',
        'crdate' => 'crdate',
        'cruser_id' => 'cruser_id',
        'versioningWS' => true,
        'languageField' => 'sys_language_uid',
        'transOrigPointerField' => 'l10n_parent',
        'transOrigDiffSourceField' => 'l10n_diffsource',
        'enablecolumns' => [
            'disabled' => 'hidden',
            'starttime' => 'starttime',
            'endtime' => 'endtime',
        ],
        'searchFields' => 'name',
        'iconfile' => 'EXT:sg_estate_map/Resources/Public/Icons/tx_sgestatemap_domain_model_marker.png',
    ],
    'interface' => [
        'showRecordFieldList' => 'sys_language_uid,l10n_parent,l10n_diffsource,'
                                 . 'name, short_name, position_x, position_y, estate_items',
    ],
    'types' => [
        '0' => [
            'showitem' => '--div--;LLL:EXT:sg_estate_map/Resources/Private/Language/locallang_db.xlf:tx_sgestatemap_domain_model_marker.basics,
                    --palette--;;basics,
                    --div--;LLL:EXT:sg_estate_map/Resources/Private/Language/locallang_db.xlf:tx_sgestatemap_domain_model_marker.estate,
                    --palette--;;estate,',
        ],
    ],
    'palettes' => [
        'basics' => [
            'showitem' => 'name,--linebreak--,short_name,--linebreak--,position_x,--linebreak--,position_y',
        ],
        'estate' => [
            'showitem' => 'estate_items',
        ],
    ],
    'columns' => [
        'sys_language_uid' => [
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.language',
            'config' => [
                'type' => 'passthrough',
            ],
        ],
        'l10n_parent' => [
            'displayCond' => 'FIELD:sys_language_uid:>:0',
            'exclude' => true,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.l18n_parent',
            'config' => [
                'type' => 'passthrough',
            ],
        ],
        'l10n_diffsource' => [
            'config' => [
                'type' => 'passthrough',
            ],
        ],
        't3ver_label' => [
            'label' => 'LLL:EXT:lang/locallang_general.xlf:LGL.versionLabel',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'max' => 255,
            ],
        ],
        'name' => [
            'exclude' => false,
            'label' => 'LLL:EXT:sg_estate_map/Resources/Private/Language/locallang_db.xlf:tx_sgestatemap_domain_model_marker.name',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim,required',
            ],
        ],
        'short_name' => [
            'exclude' => false,
            'label' => 'LLL:EXT:sg_estate_map/Resources/Private/Language/locallang_db.xlf:tx_sgestatemap_domain_model_marker.short_name',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim,required',
            ],
        ],
        'position_x' => [
            'exclude' => true,
            'label' => 'LLL:EXT:sg_estate_map/Resources/Private/Language/locallang_db.xlf:tx_sgestatemap_domain_model_marker.position_x',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'double2'
            ]
        ],
        'position_y' => [
            'exclude' => true,
            'label' => 'LLL:EXT:sg_estate_map/Resources/Private/Language/locallang_db.xlf:tx_sgestatemap_domain_model_marker.position_y',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'double2'
            ]
        ],
        'estate_items' => [
            'exclude' => 0,
            'label' => 'LLL:EXT:sg_estate_map/Resources/Private/Language/locallang_db.xlf:tx_sgestatemap_domain_model_marker.estate_items',
            'config' => [
                'type' => 'select',
                'renderType' => 'selectMultipleSideBySide',
                'foreign_table' => 'tx_sgestatecore_domain_model_immobilie',
                'MM' => 'tx_sgestatemap_marker_immobilie_mm',
                'size' => 10,
                'autoSizeMax' => 30,
                'maxitems' => 9999,
                'multiple' => 0,
                'fieldControl' => [
                    'editPopup' => [
                        'disabled' => false,
                    ],
                    'addRecord' => [
                        'disabled' => false,
                    ],
                    'listModule' => [
                        'disabled' => true,
                    ],
                ],
            ],
        ]
    ],
];
