<?php

namespace SG\SgEstateMap\Controller;

use SG\SgEstateMap\Domain\Model\Map;
use SG\SgEstateMap\Domain\Repository\MapRepository;

class MapController extends \TYPO3\CMS\Extbase\Mvc\Controller\ActionController
{

    /** @var MapRepository */
    protected $mapRepository;

    public function injectMapRepository(MapRepository $mapRepository): void
    {
        $this->mapRepository = $mapRepository;
    }

    public function showAction(): void
    {
        $map = null;
        if( $this->settings['map'] !== '' ) {
            try {
                $map = $this->mapRepository->findByUid((int)$this->settings[ 'map' ]);
            }
            catch (\Exception $exception){}
        }
        $this->view->assignMultiple([
            'map' => $map,
        ]);
    }
}
