<?php
namespace SG\SgEstateLandingpage\Controller;

use SG\SgEstateCore\Domain\Model\Badausstattung;
use SG\SgEstateCore\Domain\Model\Befeuerungsart;
use SG\SgEstateCore\Domain\Model\Bodenbelag;
use SG\SgEstateCore\Domain\Model\Filter;
use SG\SgEstateCore\Domain\Model\Heizungsart;
use SG\SgEstateCore\Domain\Model\Immobilie;
use SG\SgEstateCore\Domain\Model\Objektart;
use SG\SgEstateCore\Domain\Model\Objektarttyp;
use SG\SgEstateCore\Domain\Model\Ort;
use SG\SgEstateCore\Domain\Model\Stadtteil;
use SG\SgEstateCore\Domain\Model\Vermarktungsart;
use SG\SgEstateCore\Domain\Repository\BefeuerungsartRepository;
use SG\SgEstateCore\Domain\Repository\BodenbelagRepository;
use SG\SgEstateCore\Domain\Repository\HeizungsartRepository;
use SG\SgEstateCore\Domain\Repository\ImmobilieRepository;
use SG\SgEstateCore\Domain\Repository\ObjektartRepository;
use SG\SgEstateCore\Domain\Repository\ObjektarttypRepository;
use SG\SgEstateCore\Domain\Repository\OrtRepository;
use SG\SgEstateCore\Domain\Repository\RegionRepository;
use SG\SgEstateCore\Domain\Repository\StadtteilRepository;
use SG\SgEstateCore\Domain\Repository\VermarktungsartRepository;
use SG\SgEstateCore\Util\SessionHandler;
use TYPO3\CMS\Core\Cache\CacheManager;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;

class LandingpageController extends ActionController {

    /**
     * @var OrtRepository
     */
    private $ortRepository;

    /**
     * @param OrtRepository $ortRepository
     */
    public function injectOrtRepository(OrtRepository $ortRepository)
    {
        $this->ortRepository = $ortRepository;
    }

    /**
     * @var StadtteilRepository
     */
    private $stadtteilRepository;

    /**
     * @param StadtteilRepository $stadtteilRepository
     */
    public function injectStadtteilRepository(StadtteilRepository $stadtteilRepository)
    {
        $this->stadtteilRepository = $stadtteilRepository;
    }

    /**
     * @var ImmobilieRepository
     */
    private $immobilieRepository;

    public function injectImmobilieRepository(ImmobilieRepository $immobilieRepository)
    {
        $this->immobilieRepository = $immobilieRepository;
    }

    /**
     * @var ObjektartRepository
     */
    private $objektartRepository;

    /**
     * @param ObjektartRepository $objektartRepository
     */
    public function injectObjektartRepository(ObjektartRepository $objektartRepository)
    {
        $this->objektartRepository = $objektartRepository;
    }

    /**
     * @var ObjektarttypRepository
     */
    private $objektarttypRepository;

    /**
     * @param ObjektarttypRepository $objektarttypRepository
     */
    public function injectObjektarttypRepository(ObjektarttypRepository $objektarttypRepository)
    {
        $this->objektarttypRepository = $objektarttypRepository;
    }

    /**
     * @var HeizungsartRepository
     */
    private $heizungsartRepository;

    /**
     * @param HeizungsartRepository $heizungsartRepository
     */
    public function injectHeizungsartRepository(HeizungsartRepository $heizungsartRepository)
    {
        $this->heizungsartRepository = $heizungsartRepository;
    }

    /**
     * @var BefeuerungsartRepository
     */
    private $befeuerungsartRepository;

    /**
     * @param BefeuerungsartRepository $befeuerungsartRepository
     */
    public function injectBefeuerungsartRepository(BefeuerungsartRepository $befeuerungsartRepository)
    {
        $this->befeuerungsartRepository = $befeuerungsartRepository;
    }

    /**
     * @var BodenbelagRepository
     */
    private $bodenbelagRepository;

    /**
     * @param BodenbelagRepository $bodenbelagRepository
     */
    public function injectBodenbelagRepository(BodenbelagRepository $bodenbelagRepository)
    {
        $this->bodenbelagRepository = $bodenbelagRepository;
    }

    /**
     * @var VermarktungsartRepository
     */
    private $vermarktungsartRepository;

    /**
     * @param VermarktungsartRepository $vermarktungsartRepository
     */
    public function injectVermarktungsartRepository(VermarktungsartRepository $vermarktungsartRepository)
    {
        $this->vermarktungsartRepository = $vermarktungsartRepository;
    }

    /**
     * @var RegionRepository
     */
    private $regionRepository;

    /**
     * @param RegionRepository $regionRepository
     */
    public function injectRegionRepository(RegionRepository $regionRepository)
    {
        $this->regionRepository = $regionRepository;
    }

    /**
     * @var Filter
     */
    private $filter;

    /**
     * @var SessionHandler
     */
    private $sessionHandler;

    public function injectSessionHandler(SessionHandler $sessionHandler)
    {
        $this->sessionHandler = $sessionHandler;
    }

    public function indexAction(){
        /**
         * @var $filter \SG\SgEstateCore\Domain\Model\Filter
         */

        $cacheIdentifier = 'landingpage_'. $GLOBALS['TSFE']->id .'_' . sha1(serialize($this->settings['filter']));
        $cache = GeneralUtility::makeInstance(CacheManager::class)->getCache('sgestate_cache');

        if (($entry = $cache->get($cacheIdentifier)) === FALSE) {
            $filter = $this->objectManager->get('SG\SgEstateCore\Domain\Model\Filter');

            // Orte
            if ($this->settings['filter']['ort'] != ''){
                $arrayOrtUids = explode(',',$this->settings['filter']['ort']);
                foreach ($arrayOrtUids as $ortUid){
                    $ort = $this->ortRepository->findByUid($ortUid);
                    if ($ort instanceof \SG\SgEstateCore\Domain\Model\Ort){
                        $filter->addOrt($ort);
                        $ort = null;
                    }
                }
            }

            // Stadtteile
            if ($this->settings['filter']['stadtteil'] != ''){
                $arrayStadtteilUids = explode(',',$this->settings['filter']['stadtteil']);
                foreach ($arrayStadtteilUids as $stadtteilUid){
                    $stadtteil = $this->stadtteilRepository->findByUid($stadtteilUid);
                    if ($stadtteil instanceof Stadtteil){
                        $filter->addStadtteil($stadtteil);
                        $stadtteil = null;
                    }
                }
            }

            // Zimmer von bis
            if (($this->settings['filter']['zimmerVon'] != '')&&(is_numeric(($this->settings['filter']['zimmerVon'])))){
                $filter->setRaeumeAb(floatval($this->settings['filter']['zimmerVon']));
            }
            if (($this->settings['filter']['zimmerBis'] != '')&&(is_numeric(($this->settings['filter']['zimmerBis'])))){
                $filter->setRaeumeBis(floatval($this->settings['filter']['zimmerBis']));
            }

            // Wohnflaeche von bis
            if (($this->settings['filter']['wohnflaecheVon'] != '')&&(is_numeric(($this->settings['filter']['wohnflaecheVon'])))){
                $filter->setFlaecheAb(floatval($this->settings['filter']['wohnflaecheVon']));
            }
            if (($this->settings['filter']['wohnflaecheBis'] != '')&&(is_numeric(($this->settings['filter']['wohnflaecheBis'])))){
                $filter->setFlaeacheBis(floatval($this->settings['filter']['wohnflaecheBis']));
            }

            // Kaltmiete von bis
            if (($this->settings['filter']['kaltmieteVon'] != '')&&(is_numeric(($this->settings['filter']['kaltmieteVon'])))){
                $filter->setKaltmieteAb(floatval($this->settings['filter']['kaltmieteVon']));
            }
            if (($this->settings['filter']['kaltmieteBis'] != '')&&(is_numeric(($this->settings['filter']['kaltmieteBis'])))){
                $filter->setKaltmieteBis(floatval($this->settings['filter']['kaltmieteBis']));
            }

            // Objektarten
            if ($this->settings['filter']['objektart'] != ''){
                $arrayObjektartUids = explode(',',$this->settings['filter']['objektart']);
                foreach ($arrayObjektartUids as $objektartUid){
                    $objektart = $this->objektartRepository->findByUid($objektartUid);
                    if ($objektart instanceof Objektart){
                        $filter->addObjektart($objektart);
                        $objektart = null;
                    }
                }
            }

            // Objektarttypen
            if ($this->settings['filter']['objektarttyp'] != ''){
                $arrayObjektarttypUids = explode(',',$this->settings['filter']['objektarttyp']);
                foreach ($arrayObjektarttypUids as $objektarttypUid){
                    $objektarttyp = $this->objektarttypRepository->findByUid($objektarttypUid);
                    if ($objektarttyp instanceof Objektarttyp){
                        $filter->addObjektarttyp($objektarttyp);
                        $objektarttyp = null;
                    }
                }
            }

            // Vermarktungsarten
            if ($this->settings['filter']['vermarktungsart'] != ''){

                $arrayVermarktungsartUids = explode(',',$this->settings['filter']['vermarktungsart']);
                foreach ($arrayVermarktungsartUids as $vermarktungsartUid){
                    $vermarktungsart = $this->vermarktungsartRepository->findByUid($vermarktungsartUid);
                    if ($vermarktungsart instanceof Vermarktungsart){
                        $filter->addVermarktungsart($vermarktungsart);
                        $vermarktungsart = null;
                    }
                }
            }


            // Heizungsarten
            if ($this->settings['filter']['heizungsart'] != ''){
                $arrayHeizungsartUids = explode(',',$this->settings['filter']['heizungsart']);
                foreach ($arrayHeizungsartUids as $heizungsartUid){
                    $heizungsart = $this->heizungsartRepository->findByUid($heizungsartUid);
                    if ($heizungsart instanceof Heizungsart){
                        $filter->addHeizungsart($heizungsart);
                        $heizungsart = null;
                    }
                }
            }

            // Befeuerungsarten
            if ($this->settings['filter']['befeuerungsart'] != ''){
                $arrayBefeuerungsartUids = explode(',',$this->settings['filter']['befeuerungsart']);
                foreach ($arrayBefeuerungsartUids as $befeuerungsartUid){
                    $befeuerungsart = $this->befeuerungsartRepository->findByUid($befeuerungsartUid);
                    if ($befeuerungsart instanceof Befeuerungsart){
                        $filter->addBefeuerungsart($befeuerungsart);
                        $befeuerungsart = null;
                    }
                }
            }

            // Bodenbeläge
            if ($this->settings['filter']['bodenbelag'] != ''){
                $arrayBodenbelagUids = explode(',',$this->settings['filter']['bodenbelag']);
                foreach ($arrayBodenbelagUids as $bodenbelagUid){
                    $bodenbelag = $this->bodenbelagRepository->findByUid($bodenbelagUid);
                    if ($bodenbelag instanceof Bodenbelag){
                        $filter->addBodenbelag($bodenbelag);
                        $bodenbelag = null;
                    }
                }
            }

            // Einbauküche
            if ($this->settings['filter']['einbaukueche'] != ''){
                $filter->setEinbaukueche($this->settings['filter']['einbaukueche']);
            }

            // Balkon
            if ($this->settings['filter']['balkon'] != ''){
                $filter->setBalkon($this->settings['filter']['balkon']);
            }

            // Garten
            if ($this->settings['filter']['garten'] != ''){
                $filter->setGarten($this->settings['filter']['garten']);
            }

            // Keller
            if ($this->settings['filter']['keller'] != ''){
                $filter->setKeller($this->settings['filter']['keller']);
            }

            // Bad mit Wanne
            if ($this->settings['filter']['badMitWanne'] != ''){
                $filter->setBadMitWanne($this->settings['filter']['badMitWanne']);
            }

            // Bad mit Dusche
            if ($this->settings['filter']['badMitDusche'] != ''){
                $filter->setBadMitDusche($this->settings['filter']['badMitDusche']);
            }

            // Bad mit Fenster
            if ($this->settings['filter']['badMitFenster'] != ''){
                $filter->setBadMitFenster($this->settings['filter']['badMitFenster']);
            }

            // Gäste WC
            if ($this->settings['filter']['gaestewc'] != ''){
                $filter->setGaestewc($this->settings['filter']['gaestewc']);
            }

            // Haustiere
            if ($this->settings['filter']['haustiere'] != ''){
                $filter->setHaustiere($this->settings['filter']['haustiere']);
            }

            // Wohnberechtigungsschein
            if ($this->settings['filter']['wbs'] != ''){
                $filter->setWbs($this->settings['filter']['wbs']);
            }

            // Barrierefrei
            if ($this->settings['filter']['barrierefrei'] != ''){
                $filter->setBarrierefrei($this->settings['filter']['barrierefrei']);
            }

            // Leichter Zugang
            if ($this->settings['filter']['leichterZugang'] != ''){
                $filter->setLeichterZugang($this->settings['filter']['leichterZugang']);
            }

            // Aufzug
            if ($this->settings['filter']['aufzug'] != ''){
                $filter->setAufzug($this->settings['filter']['aufzug']);
            }

            // Wohnungsnummern
            if ($this->settings['filter']['wohnungsnummern'] != ''){
                $uidArray = array();
                $arrayWohnungsnummern = explode(',',$this->settings['filter']['wohnungsnummern']);
                foreach ($arrayWohnungsnummern as $wohnungsnummer){
                    $immobilien = $this->immobilieRepository->findAllByObjektnrExtern(strval($wohnungsnummer));
                    foreach ($immobilien as $immobilie){
                        if ($immobilie instanceof Immobilie){
                            array_push($uidArray, $immobilie->getUid());
                        }
                    }
                }
                $filter->setUids($uidArray);

            }

            $result = $this->immobilieRepository->findAllWithFilter($filter);

            $this->view->assign('filter', $filter);
            $this->view->assign('presets', $this->generateFilterPresetsFromResult($result));
            $this->view->assign('referer', 'landing'.$GLOBALS['TSFE']->id);
            $this->view->assign('realties', $result);

            $entry = $this->view->render();

            $tags = array('landingpage');
            $lifetime = $this->settings['defaultCacheLifetime'];

            // Save value in cache
            $cache->set($cacheIdentifier, $entry, $tags, $lifetime);
        }
        return $entry;
    }

    /**
     * @param $result
     * @return array
     */
    private function generateFilterPresetsFromResult($result){
        $presets = array();

        // Initialize
        $cities = array();
        $balcony = false;
        $lift = false;
        $wbs = false;
        $bathShower = false;
        $bathTub = false;
        $bathWindow = false;

        foreach ($result as $realty){
            /**
             * Identifiy those cities and districts that lead to valid results (take all realties locations)
             * @var $realty Immobilie
             */
            $cities[$realty->getObjektOrt()->getUid()]['bezeichner'] = $realty->getObjektOrt()->getBezeichner();
            if (is_object($realty->getObjektStadtteil())){
                $cities[$realty->getObjektOrt()->getUid()]['districts'][$realty->getObjektStadtteil()->getUid()] = array(
                    'uid' => $realty->getObjektStadtteil()->getUid(),
                    'bezeichner' => $realty->getObjektStadtteil()->getBezeichner()
                );
            }

            /**
             * Identify all cities and districts and create hierarchical tree
             */
            $allCities = array();
            $tempAllCities = $this->ortRepository->findAll();
            $presets['tempAllCities'] = $tempAllCities;
            foreach( $tempAllCities as $tempCity )
            {
                if( $tempCity instanceof Ort )
                {
                    if( $tempCity->getFuerSucheVerwenden() === true )
                    {
                        $tempDistricts = $tempCity->getStadtteile();
                        $tempDistrictsCount = $tempDistricts->count();
                        if( $tempDistrictsCount > 0 )
                        {
                            // now inspect all disricts and identify those we want to add to the presets
                            $districtsArray = array();
                            foreach( $tempDistricts as $tempDistrict )
                            {
                                if( $tempDistrict instanceof Stadtteil )
                                {
                                    if( $tempDistrict->getFuerSucheVerwenden() === true )
                                    {
                                        // choose this districts
                                        $districtsArray[] = array(
                                            'uid' => $tempDistrict->getUid(),
                                            'bezeichner' => $tempDistrict->getBezeichner()
                                        );
                                    }
                                }
                            }
                            // valid city and districts combination found, add to "all cities array"
                            if( count( $districtsArray ) > 0 )
                            {
                                // sort districts, pass reference
                                $this->sortDistrictsPresetArray( $districtsArray );
                                // append array
                                $allCities[ $tempCity->getUid() ] = array(
                                    'bezeichner' => $tempCity->getBezeichner(),
                                    'districts' => $districtsArray
                                );
                            }
                        }
                    }
                }
            }

            // Balcony
            if ($realty->getAnzahlBalkone() > 0){$balcony = true;}

            // Lift
            if ($realty->getAufzugPersonen() == 1){$lift = true;}

            // WBS
            if ($realty->getWbsErforderlich() == 1){$wbs = true;}

            // Bath
            /**
             * @var $badAusstattung Badausstattung
             */
            foreach ($realty->getAusstattungBad() as $badAusstattung){
                if ($badAusstattung->getKuerzel() == 'WANNE'){$bathTub = true;}
                if ($badAusstattung->getKuerzel() == 'DUSCHE'){$bathShower = true;}
                if ($badAusstattung->getKuerzel() == 'FENSTER'){$bathWindow = true;}
            }

        }



        // Build Return Variable
        $presets['cities'] = $cities;
        $presets['allCities'] = $allCities;
        $presets['allRegions'] = $this->regionRepository->findAll();
        $presets['balcony'] = $balcony;
        $presets['lift'] = $lift;
        $presets['wbs'] = $wbs;
        $presets['bathShower'] = $bathShower;
        $presets['bathTub'] = $bathTub;
        $presets['bathWindow'] = $bathWindow;

        return $presets;
    }

    /**
     * Sort a given district array that was optimized for preset use in template
     * in ascending order (bezeichner field)
     * @param  array &$districts Array to sort
     */
    private function sortDistrictsPresetArray( &$districts )
    {
        $sorted = false;
        $districtsCount = count( $districts )-1;
        while( $sorted === false )
        {
            $changes = 0;
            for( $i = 0; $i < $districtsCount; $i++ )
            {
                if( $districts[$i]['bezeichner'] > $districts[$i+1]['bezeichner'] )
                {
                    // change position and increment counter
                    $h = $districts[$i];
                    $districts[$i] = $districts[$i+1];
                    $districts[$i+1] = $h;
                    $changes++;
                }
            }
            if( $changes == 0 )
            {
                $sorted = true;
            }
        }
    }
}