<?php
namespace SG\SgEstateImportSwoppen\Domain\Repository;

use TYPO3\CMS\Extbase\Persistence\QueryInterface;

/**
 * The repository for Lastimport
 */
class LastimportRepository extends \TYPO3\CMS\Extbase\Persistence\Repository {

    public function initializeObject() {
        /** @var $querySettings \TYPO3\CMS\Extbase\Persistence\Generic\Typo3QuerySettings */
        $querySettings = $this->objectManager->get('TYPO3\\CMS\\Extbase\\Persistence\\Generic\\Typo3QuerySettings');
        $querySettings->setRespectStoragePage(FALSE);
        $this->setDefaultQuerySettings($querySettings);
    }

    /**
     * @param array $arrayOfImportIds
     * @return array|\TYPO3\CMS\Extbase\Persistence\QueryResultInterface
     * @throws \TYPO3\CMS\Extbase\Persistence\Exception\InvalidQueryException
     */
    public function findLastTstempByImportId(array $arrayOfImportIds)
    {
        /**
         * @var QueryInterface $query
         */
        $query = $this->createQuery();

        $query->matching(
            $query->in('importNumber', $arrayOfImportIds)
        );

        return $query->execute();
    }
}