<?php
namespace SG\SgEstateImportOpenimmo\Tasks;

class ImportAdditionalFieldProvider implements \TYPO3\CMS\Scheduler\AdditionalFieldProviderInterface {

    /**
     * Gets additional fields to render in the form to add/edit a task
     *
     * @param array $taskInfo Values of the fields from the add/edit task form
     * @param \TYPO3\CMS\Scheduler\Task\AbstractTask $task The task object being edited. Null when adding a task!
     * @param \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule Reference to the scheduler backend module
     * @return array A two dimensional array, array('Identifier' => array('fieldId' => array('code' => '', 'label' => '', 'cshKey' => '', 'cshLabel' => ''))
     */
    public function getAdditionalFields(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule)
    {
        $additionalFields['task_sgestateimportopenimmo_storagepid']             = $this->getStoragePidAdditionalField($taskInfo, $task, $schedulerModule);
        $additionalFields['task_sgestateimportopenimmo_storagefolder']          = $this->getStorageFolderAdditionalField($taskInfo, $task, $schedulerModule);
        $additionalFields['task_sgestateimportopenimmo_debugmode']              = $this->getDebugModeAdditionalField($taskInfo, $task, $schedulerModule);
        $additionalFields['task_sgestateimportopenimmo_reportsenderemail']      = $this->getReportSenderEmailField($taskInfo, $task, $schedulerModule);
        $additionalFields['task_sgestateimportopenimmo_reportreceiveremails']   = $this->getReportReceiverEmailsField($taskInfo, $task, $schedulerModule);
        $additionalFields['task_sgestateimportopenimmo_reportsubject']          = $this->getReportSubjectField($taskInfo, $task, $schedulerModule);
        $additionalFields['task_sgestateimportopenimmo_failedimportsreceiveremails']   = $this->getFailedImportsReceiverEmailsField($taskInfo, $task, $schedulerModule);
        $additionalFields['task_sgestateimportopenimmo_failedimportssubject']   = $this->getFailedImportsSubjectField($taskInfo, $task, $schedulerModule);
        $additionalFields['task_sgestateimportopenimmo_reporttemplatepath']     = $this->getReportTemplatePathField($taskInfo, $task, $schedulerModule);
        $additionalFields['task_sgestateimportopenimmo_daystokeeparchivefiles'] = $this->getDaysToKeepArchiveFilesField($taskInfo, $task, $schedulerModule);

        return $additionalFields;
    }

    public function validateAdditionalFields(array &$submittedData, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule)
    {
        $validData =    $this->validateStoragePidAdditionalField($submittedData, $schedulerModule);
        $validData &=   $this->validateReportSenderEmail($submittedData, $schedulerModule);
        $validData &=   $this->validateReportReceiverEmails($submittedData, $schedulerModule);
        $validData &=   $this->validateReportSubject($submittedData, $schedulerModule);
        $validData &=   $this->validateFailedImportsReceiverEmails($submittedData, $schedulerModule);
        $validData &=   $this->validateFailedImportsSubject($submittedData, $schedulerModule);
        $validData &=   $this->validateReportTemplatePath($submittedData, $schedulerModule);
        $validData &=   $this->validateDaysToKeepArchiveFiles($submittedData, $schedulerModule);

        return $validData;
    }

    public function saveAdditionalFields(array $submittedData, \TYPO3\CMS\Scheduler\Task\AbstractTask $task)
    {
        /**
         * @var $task \SG\SgEstateImportOpenimmo\Tasks\Import
         */

        $task->setStoragePid((int)$submittedData['task_sgestateimportopenimmo_storagepid']);
        $task->setStorageFolder($submittedData['task_sgestateimportopenimmo_storagefolder']);
        $task->setDebugMode($submittedData['task_sgestateimportopenimmo_debugmode']);
        $task->setReportSenderEmail($submittedData['task_sgestateimportopenimmo_reportsenderemail']);
        $task->setReportReceiverEmails(explode(',',$submittedData['task_sgestateimportopenimmo_reportreceiveremails']));
        $task->setReportSubject($submittedData['task_sgestateimportopenimmo_reportsubject']);
        $task->setFailedImportsReceiverEmails(explode(',',$submittedData['task_sgestateimportopenimmo_failedimportsreceiveremails']));
        $task->setFailedImportsSubject($submittedData['task_sgestateimportopenimmo_failedimportssubject']);
        $task->setReportTemplatePath($submittedData['task_sgestateimportopenimmo_reporttemplatepath']);
        $task->setDaysToKeepArchiveFiles($submittedData['task_sgestateimportopenimmo_daystokeeparchivefiles']);
    }

    protected function getStoragePidAdditionalField(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule) {
        /**
         * @var $task \SG\SgEstateImportOpenimmo\Tasks\Import
         */

        if (empty($taskInfo['task_sgestateimportopenimmo_storagepid'])) {
            if ($schedulerModule->CMD === 'add') {
                $taskInfo['task_sgestateimportopenimmo_storagepid'] = 0;
            } elseif ($schedulerModule->CMD === 'edit') {
                $taskInfo['task_sgestateimportopenimmo_storagepid'] = $task->getStoragePid();
            }
        }

        $fieldName = 'tx_scheduler[task_sgestateimportopenimmo_storagepid]';
        $fieldId = 'task_sgestateimportopenimmo_storagepid';
        $fieldHtml = '<input class="form-control" type="text" ' . 'name="' . $fieldName . '" ' . 'id="' . $fieldId . '" value="' . (int)$taskInfo['task_sgestateimportopenimmo_storagepid'] . '" ' . 'size="4" />';
        $fieldConfiguration = array(
            'code' => $fieldHtml,
            'label' => 'PID des Immobilienspeichers',
            'cshKey' => '_MOD_system_txschedulerM1',
            'cshLabel' => $fieldId
        );
        return $fieldConfiguration;
    }

    protected function getStorageFolderAdditionalField(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule) {
        /**
         * @var $task \SG\SgEstateImportOpenimmo\Tasks\Import
         */

        if (empty($taskInfo['task_sgestateimportopenimmo_storagefolder'])) {
            if ($schedulerModule->CMD === 'add') {
                $taskInfo['task_sgestateimportopenimmo_storagefolder'] = '';
            } elseif ($schedulerModule->CMD === 'edit') {
                $taskInfo['task_sgestateimportopenimmo_storagefolder'] = $task->getStorageFolder();
            }
        }

        $fieldName = 'tx_scheduler[task_sgestateimportopenimmo_storagefolder]';
        $fieldId = 'task_sgestateimportopenimmo_storagefolder';
        $fieldHtml = '<input class="form-control" type="text" ' . 'name="' . $fieldName . '" ' . 'id="' . $fieldId . '" value="' . $taskInfo['task_sgestateimportopenimmo_storagefolder'] . '" ' . ' />';
        $fieldConfiguration = array(
            'code' => $fieldHtml,
            'label' => 'Importpfad, falls vom Standard abweicht (uploads/tx_sgestateimportopenimmo/) ohne Leading-Slash aber mit Trailing-Slash.',
            'cshKey' => '_MOD_system_txschedulerM1',
            'cshLabel' => $fieldId
        );
        return $fieldConfiguration;
    }

    protected function getDebugModeAdditionalField(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
        /**
         * @var $task \SG\SgEstateImportOpenimmo\Tasks\Import
         */

        if (empty($taskInfo['task_sgestateimportopenimmo_debugmode'])) {
            if ($schedulerModule->CMD === 'add') {
                $taskInfo['task_sgestateimportopenimmo_debugmode'] = 0;
            } elseif ($schedulerModule->CMD === 'edit') {
                $taskInfo['task_sgestateimportopenimmo_debugmode'] = $task->isDebugMode();
            }
        }

        $fieldName = 'tx_scheduler[task_sgestateimportopenimmo_debugmode]';
        $fieldId = 'task_sgestateimportopenimmo_debugmode';
        if ($taskInfo['task_sgestateimportopenimmo_debugmode'] == 1){
            $selected = 'checked="checked"';
        }else{
            $selected = '';
        }

        $fieldHtml = '<input type="checkbox" ' . 'name="' . $fieldName . '" ' . 'id="' . $fieldId . '" value="1" ' . $selected.' />';
        $fieldConfiguration = array(
            'code' => $fieldHtml,
            'label' => 'Debug-Mode aktivieren',
            'cshKey' => '_MOD_system_txschedulerM1',
            'cshLabel' => $fieldId
        );
        return $fieldConfiguration;
    }

    protected function getReportSenderEmailField(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
        /**
         * @var $task \SG\SgEstateImportOpenimmo\Tasks\Import
         */

        if (empty($taskInfo['task_sgestateimportopenimmo_reportsenderemail'])) {
            if ($schedulerModule->CMD === 'add') {
                $taskInfo['task_sgestateimportopenimmo_reportsenderemail'] = '';
            } elseif ($schedulerModule->CMD === 'edit') {
                $taskInfo['task_sgestateimportopenimmo_reportsenderemail'] = $task->getReportSenderEmail();
            }
        }

        $fieldName = 'tx_scheduler[task_sgestateimportopenimmo_reportsenderemail]';
        $fieldId = 'task_sgestateimportopenimmo_reportsenderemail';
        $fieldHtml = '<input class="form-control" type="text" ' . 'name="' . $fieldName . '" ' . 'id="' . $fieldId . '" value="' . $taskInfo['task_sgestateimportopenimmo_reportsenderemail'] . '" ' . 'size="50" />';
        $fieldConfiguration = array(
            'code' => $fieldHtml,
            'label' => 'Absender E-Mail Adresse für Report',
            'cshKey' => '_MOD_system_txschedulerM1',
            'cshLabel' => $fieldId
        );
        return $fieldConfiguration;
    }

    protected function getFailedImportsSenderEmailField(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
        /**
         * @var $task \SG\SgEstateImportOpenimmo\Tasks\Import
         */

        if (empty($taskInfo['task_sgestateimportopenimmo_failedimportssenderemail'])) {
            if ($schedulerModule->CMD === 'add') {
                $taskInfo['task_sgestateimportopenimmo_failedimportssenderemail'] = '';
            } elseif ($schedulerModule->CMD === 'edit') {
                $taskInfo['task_sgestateimportopenimmo_failedimportssenderemail'] = $task->getReportSenderEmail();
            }
        }

        $fieldName = 'tx_scheduler[task_sgestateimportopenimmo_failedimportssenderemail]';
        $fieldId = 'task_sgestateimportopenimmo_failedimportssenderemail';
        $fieldHtml = '<input class="form-control" type="text" ' . 'name="' . $fieldName . '" ' . 'id="' . $fieldId . '" value="' . $taskInfo['task_sgestateimportopenimmo_failedimportssenderemail'] . '" ' . 'size="50" />';
        $fieldConfiguration = array(
            'code' => $fieldHtml,
            'label' => 'Absender E-Mail Adresse für Failed Imports',
            'cshKey' => '_MOD_system_txschedulerM1',
            'cshLabel' => $fieldId
        );
        return $fieldConfiguration;
    }

    protected function getReportReceiverEmailsField(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
        /**
         * @var $task \SG\SgEstateImportOpenimmo\Tasks\Import
         */

        if (empty($taskInfo['task_sgestateimportopenimmo_reportreceiveremails'])) {
            if ($schedulerModule->CMD === 'add') {
                $taskInfo['task_sgestateimportopenimmo_reportreceiveremails'] = '';
            } elseif ($schedulerModule->CMD === 'edit') {
                $taskInfo['task_sgestateimportopenimmo_reportreceiveremails'] = implode(",",$task->getReportReceiverEmails());
            }
        }

        $fieldName = 'tx_scheduler[task_sgestateimportopenimmo_reportreceiveremails]';
        $fieldId = 'task_sgestateimportopenimmo_reportreceiveremails';
        $fieldHtml = '<textarea class="form-control" name="' . $fieldName . '" ' . 'id="' . $fieldId . '" rows="5" cols="50">'.$taskInfo['task_sgestateimportopenimmo_reportreceiveremails'] .'</textarea>';
        $fieldConfiguration = array(
            'code' => $fieldHtml,
            'label' => 'Empfänger E-Mails für den Report (kommagetrennt)',
            'cshKey' => '_MOD_system_txschedulerM1',
            'cshLabel' => $fieldId
        );
        return $fieldConfiguration;
    }

    protected function getFailedImportsReceiverEmailsField(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
        /**
         * @var $task \SG\SgEstateImportOpenimmo\Tasks\Import
         */

        if (empty($taskInfo['task_sgestateimportopenimmo_failedimportsreceiveremails'])) {
            if ($schedulerModule->CMD === 'add') {
                $taskInfo['task_sgestateimportopenimmo_failedimportsreceiveremails'] = '';
            } elseif ($schedulerModule->CMD === 'edit') {
                $taskInfo['task_sgestateimportopenimmo_failedimportsreceiveremails'] = implode(",",$task->getFailedImportsReceiverEmails());
            }
        }

        $fieldName = 'tx_scheduler[task_sgestateimportopenimmo_failedimportsreceiveremails]';
        $fieldId = 'task_sgestateimportopenimmo_failedimportsreceiveremails';
        $fieldHtml = '<textarea class="form-control" name="' . $fieldName . '" ' . 'id="' . $fieldId . '" rows="5" cols="50">'.$taskInfo['task_sgestateimportopenimmo_failedimportsreceiveremails'] .'</textarea>';
        $fieldConfiguration = array(
            'code' => $fieldHtml,
            'label' => 'Empfänger E-Mails für Failed Imports (kommagetrennt)',
            'cshKey' => '_MOD_system_txschedulerM1',
            'cshLabel' => $fieldId
        );
        return $fieldConfiguration;
    }

    protected function getReportSubjectField(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
        /**
         * @var $task \SG\SgEstateImportOpenimmo\Tasks\Import
         */

        if (empty($taskInfo['task_sgestateimportopenimmo_reportsubject'])) {
            if ($schedulerModule->CMD === 'add') {
                $taskInfo['task_sgestateimportopenimmo_reportsubject'] = '';
            } elseif ($schedulerModule->CMD === 'edit') {
                $taskInfo['task_sgestateimportopenimmo_reportsubject'] = $task->getReportSubject();
            }
        }

        $fieldName = 'tx_scheduler[task_sgestateimportopenimmo_reportsubject]';
        $fieldId = 'task_sgestateimportopenimmo_reportsubject';
        $fieldHtml = '<input class="form-control" type="text" ' . 'name="' . $fieldName . '" ' . 'id="' . $fieldId . '" value="' . $taskInfo['task_sgestateimportopenimmo_reportsubject'] . '" ' . 'size="50" />';
        $fieldConfiguration = array(
            'code' => $fieldHtml,
            'label' => 'Betreff der Report E-Mail',
            'cshKey' => '_MOD_system_txschedulerM1',
            'cshLabel' => $fieldId
        );
        return $fieldConfiguration;
    }

    protected function getFailedImportsSubjectField(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
        /**
         * @var $task \SG\SgEstateImportOpenimmo\Tasks\Import
         */

        if (empty($taskInfo['task_sgestateimportopenimmo_failedimportssubject'])) {
            if ($schedulerModule->CMD === 'add') {
                $taskInfo['task_sgestateimportopenimmo_failedimportssubject'] = '';
            } elseif ($schedulerModule->CMD === 'edit') {
                $taskInfo['task_sgestateimportopenimmo_failedimportssubject'] = $task->getFailedImportsSubject();
            }
        }

        $fieldName = 'tx_scheduler[task_sgestateimportopenimmo_failedimportssubject]';
        $fieldId = 'task_sgestateimportopenimmo_failedimportssubject';
        $fieldHtml = '<input class="form-control" type="text" ' . 'name="' . $fieldName . '" ' . 'id="' . $fieldId . '" value="' . $taskInfo['task_sgestateimportopenimmo_failedimportssubject'] . '" ' . 'size="50" />';
        $fieldConfiguration = array(
            'code' => $fieldHtml,
            'label' => 'Betreff der Failed Imports E-Mail',
            'cshKey' => '_MOD_system_txschedulerM1',
            'cshLabel' => $fieldId
        );
        return $fieldConfiguration;
    }

    protected function getReportTemplatePathField(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
        /**
         * @var $task \SG\SgEstateImportOpenimmo\Tasks\Import
         */

        if (empty($taskInfo['task_sgestateimportopenimmo_reporttemplatepath'])) {
            if ($schedulerModule->CMD === 'add') {
                $taskInfo['task_sgestateimportopenimmo_reporttemplatepath'] = '';
            } elseif ($schedulerModule->CMD === 'edit') {
                $taskInfo['task_sgestateimportopenimmo_reporttemplatepath'] = $task->getReportTemplatePath();
            }
        }

        $fieldName = 'tx_scheduler[task_sgestateimportopenimmo_reporttemplatepath]';
        $fieldId = 'task_sgestateimportopenimmo_reporttemplatepath';
        $fieldHtml = '<input class="form-control" type="text" ' . 'name="' . $fieldName . '" ' . 'id="' . $fieldId . '" value="' . $taskInfo['task_sgestateimportopenimmo_reporttemplatepath'] . '" ' . 'size="50" />';
        $fieldConfiguration = array(
            'code' => $fieldHtml,
            'label' => 'Verzeichnis mit Report.html',
            'cshKey' => '_MOD_system_txschedulerM1',
            'cshLabel' => $fieldId
        );
        return $fieldConfiguration;
    }

    protected function getDaysToKeepArchiveFilesField(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
        /**
         * @var $task \SG\SgEstateImportOpenimmo\Tasks\Import
         */

        if (empty($taskInfo['task_sgestateimportopenimmo_daystokeeparchivefiles'])) {
            if ($schedulerModule->CMD === 'add') {
                $taskInfo['task_sgestateimportopenimmo_daystokeeparchivefiles'] = '7';
            } elseif ($schedulerModule->CMD === 'edit') {
                $taskInfo['task_sgestateimportopenimmo_daystokeeparchivefiles'] = $task->getDaysToKeepArchiveFiles();
            }
        }

        $fieldName = 'tx_scheduler[task_sgestateimportopenimmo_daystokeeparchivefiles]';
        $fieldId = 'task_sgestateimportopenimmo_daystokeeparchivefiles';
        $fieldHtml = '<input class="form-control" type="text" ' . 'name="' . $fieldName . '" ' . 'id="' . $fieldId . '" value="' . $taskInfo['task_sgestateimportopenimmo_daystokeeparchivefiles'] . '" ' . 'size="5" />';
        $fieldConfiguration = array(
            'code' => $fieldHtml,
            'label' => 'Wieviel Tage sollen die Exporte archiviert werden?',
            'cshKey' => '_MOD_system_txschedulerM1',
            'cshLabel' => $fieldId
        );
        return $fieldConfiguration;
    }

    protected function validateStoragePidAdditionalField(array &$submittedData, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule) {
        $validData = FALSE;
        if (!isset($submittedData['task_sgestateimportopenimmo_storagepid'])) {
            $validData = TRUE;
        } elseif ((int)$submittedData['task_sgestateimportopenimmo_storagepid'] >= 0) {
            $validData = TRUE;
        } else {
            $schedulerModule->addMessage('Bitte eine gültige PID eingeben!', \TYPO3\CMS\Core\Messaging\FlashMessage::ERROR);
        }
        return $validData;
    }

    protected function validateReportSenderEmail(array &$submittedData, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
        $validData = false;
        if (\TYPO3\CMS\Core\Utility\GeneralUtility::validEmail($submittedData['task_sgestateimportopenimmo_reportsenderemail'])){
            $validData = true;
        }else{
            $schedulerModule->addMessage('Bitte geben Sie eine gültige E-Mail Adresse ein!', \TYPO3\CMS\Core\Messaging\FlashMessage::ERROR);
        }
        return $validData;
    }

    protected function validateReportReceiverEmails(array &$submittedData, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
        $validData = true;

        $tempArray = explode(',',$submittedData['task_sgestateimportopenimmo_reportreceiveremails']);

        foreach ($tempArray as $emailaddress){
            if (!\TYPO3\CMS\Core\Utility\GeneralUtility::validEmail($emailaddress)){
                $validData = false;
            }
        }
        if ($validData == false){
            $schedulerModule->addMessage('Bitte geben Sie nur gültige E-Mail Adressen ein!', \TYPO3\CMS\Core\Messaging\FlashMessage::ERROR);
        }
        return $validData;
    }

    protected function validateReportSubject(array &$submittedData, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
        $validData = false;
        if ($submittedData['task_sgestateimportopenimmo_reportsubject'] != ''){
            $validData = true;
        }else{
            $schedulerModule->addMessage('Bitte geben Sie einen Betreff ein!', \TYPO3\CMS\Core\Messaging\FlashMessage::ERROR);
        }
        return $validData;
    }

    protected function validateFailedImportsReceiverEmails(array &$submittedData, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
        $validData = true;

        $tempArray = explode(',',$submittedData['task_sgestateimportopenimmo_failedimportsreceiveremails']);

        foreach ($tempArray as $emailaddress){
            if (!\TYPO3\CMS\Core\Utility\GeneralUtility::validEmail($emailaddress)){
                $validData = false;
            }
        }
        if ($validData == false){
            $schedulerModule->addMessage('Bitte geben Sie nur gültige E-Mail Adressen ein!', \TYPO3\CMS\Core\Messaging\FlashMessage::ERROR);
        }
        return $validData;
    }

    protected function validateFailedImportsSubject(array &$submittedData, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
        $validData = false;
        if ($submittedData['task_sgestateimportopenimmo_failedimportssubject'] != ''){
            $validData = true;
        }else{
            $schedulerModule->addMessage('Bitte geben Sie einen Betreff ein!', \TYPO3\CMS\Core\Messaging\FlashMessage::ERROR);
        }
        return $validData;
    }

    protected function validateReportTemplatePath(array &$submittedData, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
        return true;
    }

    protected function validateDaysToKeepArchiveFiles(array &$submittedData, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
        $validData = false;
        if (is_numeric($submittedData['task_sgestateimportopenimmo_daystokeeparchivefiles'])){
            $validData = true;
        }else{
            $schedulerModule->addMessage('Bitte geben Sie eine Zahl ein!', \TYPO3\CMS\Core\Messaging\FlashMessage::ERROR);
        }
        return $validData;

    }
}