<?php
namespace SG\SgEstateImportOpenimmo\Tasks;

class DailyReportAdditionalFieldProvider implements \TYPO3\CMS\Scheduler\AdditionalFieldProviderInterface {

    /**
     * Gets additional fields to render in the form to add/edit a task
     *
     * @param array $taskInfo Values of the fields from the add/edit task form
     * @param \TYPO3\CMS\Scheduler\Task\AbstractTask $task The task object being edited. Null when adding a task!
     * @param \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule Reference to the scheduler backend module
     * @return array A two dimensional array, array('Identifier' => array('fieldId' => array('code' => '', 'label' => '', 'cshKey' => '', 'cshLabel' => ''))
     */
    public function getAdditionalFields(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule)
    {
        $additionalFields['task_sgestateimportopenimmo_dailyreportsenderemail']      = $this->getDailyReportSenderEmailField($taskInfo, $task, $schedulerModule);
        $additionalFields['task_sgestateimportopenimmo_dailyreportreceiveremails']   = $this->getDailyReportReceiverEmailsField($taskInfo, $task, $schedulerModule);
        $additionalFields['task_sgestateimportopenimmo_dailyreportsubject']          = $this->getDailyReportSubjectField($taskInfo, $task, $schedulerModule);
        $additionalFields['task_sgestateimportopenimmo_dailyreportexternalreceiveremails']   = $this->getDailyReportExternalReceiverEmailsField($taskInfo, $task, $schedulerModule);
        $additionalFields['task_sgestateimportopenimmo_dailyreportexternalsubject']          = $this->getDailyReportExternalSubjectField($taskInfo, $task, $schedulerModule);

        return $additionalFields;
    }

    public function validateAdditionalFields(array &$submittedData, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule)
    {
        $validData =   $this->validateDailyReportSenderEmail($submittedData, $schedulerModule);
        $validData &=   $this->validateDailyReportReceiverEmails($submittedData, $schedulerModule);
        $validData &=   $this->validateDailyReportSubject($submittedData, $schedulerModule);
        $validData &=   $this->validateDailyReportExternalReceiverEmails($submittedData, $schedulerModule);
        $validData &=   $this->validateDailyReportExternalSubject($submittedData, $schedulerModule);

        return $validData;
    }

    public function saveAdditionalFields(array $submittedData, \TYPO3\CMS\Scheduler\Task\AbstractTask $task)
    {
        /**
         * @var $task \SG\SgEstateImportOpenimmo\Tasks\Import
         */
        $task->setDailyReportSenderEmail($submittedData['task_sgestateimportopenimmo_dailyreportsenderemail']);
        $task->setDailyReportReceiverEmails(explode(',',$submittedData['task_sgestateimportopenimmo_dailyreportreceiveremails']));
        $task->setDailyReportSubject($submittedData['task_sgestateimportopenimmo_dailyreportsubject']);
        $task->setDailyReportExternalReceiverEmails(explode(',',$submittedData['task_sgestateimportopenimmo_dailyreportexternalreceiveremails']));
        $task->setDailyReportExternalSubject($submittedData['task_sgestateimportopenimmo_dailyreportexternalsubject']);
    }

    protected function getDailyReportSenderEmailField(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
        /**
         * @var $task \SG\SgEstateImportOpenimmo\Tasks\Import
         */

        if (empty($taskInfo['task_sgestateimportopenimmo_dailyreportsenderemail'])) {
            if ($schedulerModule->CMD === 'add') {
                $taskInfo['task_sgestateimportopenimmo_dailyreportsenderemail'] = '';
            } elseif ($schedulerModule->CMD === 'edit') {
                $taskInfo['task_sgestateimportopenimmo_dailyreportsenderemail'] = $task->getDailyReportSenderEmail();
            }
        }

        $fieldName = 'tx_scheduler[task_sgestateimportopenimmo_dailyreportsenderemail]';
        $fieldId = 'task_sgestateimportopenimmo_dailyreportsenderemail';
        $fieldHtml = '<input class="form-control" type="text" ' . 'name="' . $fieldName . '" ' . 'id="' . $fieldId . '" value="' . $taskInfo['task_sgestateimportopenimmo_dailyreportsenderemail'] . '" ' . 'size="50" />';
        $fieldConfiguration = array(
            'code' => $fieldHtml,
            'label' => 'Absender E-Mail Adresse für Report',
            'cshKey' => '_MOD_system_txschedulerM1',
            'cshLabel' => $fieldId
        );
        return $fieldConfiguration;
    }

    protected function getDailyReportReceiverEmailsField(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
        /**
         * @var $task \SG\SgEstateImportOpenimmo\Tasks\Import
         */

        if (empty($taskInfo['task_sgestateimportopenimmo_dailyreportreceiveremails'])) {
            if ($schedulerModule->CMD === 'add') {
                $taskInfo['task_sgestateimportopenimmo_dailyreportreceiveremails'] = '';
            } elseif ($schedulerModule->CMD === 'edit') {
                $taskInfo['task_sgestateimportopenimmo_dailyreportreceiveremails'] = implode(",",$task->getDailyReportReceiverEmails());
            }
        }

        $fieldName = 'tx_scheduler[task_sgestateimportopenimmo_dailyreportreceiveremails]';
        $fieldId = 'task_sgestateimportopenimmo_dailyreportreceiveremails';
        $fieldHtml = '<textarea class="form-control" name="' . $fieldName . '" ' . 'id="' . $fieldId . '" rows="5" cols="50">'.$taskInfo['task_sgestateimportopenimmo_dailyreportreceiveremails'] .'</textarea>';
        $fieldConfiguration = array(
            'code' => $fieldHtml,
            'label' => 'Empfänger E-Mails für den Report (kommagetrennt)',
            'cshKey' => '_MOD_system_txschedulerM1',
            'cshLabel' => $fieldId
        );
        return $fieldConfiguration;
    }

    protected function getDailyReportSubjectField(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
        /**
         * @var $task \SG\SgEstateImportOpenimmo\Tasks\Import
         */

        if (empty($taskInfo['task_sgestateimportopenimmo_dailyreportsubject'])) {
            if ($schedulerModule->CMD === 'add') {
                $taskInfo['task_sgestateimportopenimmo_dailyreportsubject'] = '';
            } elseif ($schedulerModule->CMD === 'edit') {
                $taskInfo['task_sgestateimportopenimmo_dailyreportsubject'] = $task->getDailyReportSubject();
            }
        }

        $fieldName = 'tx_scheduler[task_sgestateimportopenimmo_dailyreportsubject]';
        $fieldId = 'task_sgestateimportopenimmo_dailyreportsubject';
        $fieldHtml = '<input class="form-control" type="text" ' . 'name="' . $fieldName . '" ' . 'id="' . $fieldId . '" value="' . $taskInfo['task_sgestateimportopenimmo_dailyreportsubject'] . '" ' . 'size="50" />';
        $fieldConfiguration = array(
            'code' => $fieldHtml,
            'label' => 'Betreff der Report E-Mail',
            'cshKey' => '_MOD_system_txschedulerM1',
            'cshLabel' => $fieldId
        );
        return $fieldConfiguration;
    }

    protected function validateDailyReportSenderEmail(array &$submittedData, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
        $validData = false;
        if (\TYPO3\CMS\Core\Utility\GeneralUtility::validEmail($submittedData['task_sgestateimportopenimmo_dailyreportsenderemail'])){
            $validData = true;
        }else{
            $schedulerModule->addMessage('Bitte geben Sie eine gültige E-Mail Adresse ein!', \TYPO3\CMS\Core\Messaging\FlashMessage::ERROR);
        }
        return $validData;
    }

    protected function validateDailyReportReceiverEmails(array &$submittedData, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
        $validData = true;

        $tempArray = explode(',',$submittedData['task_sgestateimportopenimmo_dailyreportreceiveremails']);

        foreach ($tempArray as $emailaddress){
            if (!\TYPO3\CMS\Core\Utility\GeneralUtility::validEmail($emailaddress)){
                $validData = false;
            }
        }
        if ($validData == false){
            $schedulerModule->addMessage('Bitte geben Sie nur gültige E-Mail Adressen ein!', \TYPO3\CMS\Core\Messaging\FlashMessage::ERROR);
        }
        return $validData;
    }

    protected function validateDailyReportSubject(array &$submittedData, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
        $validData = false;
        if ($submittedData['task_sgestateimportopenimmo_dailyreportsubject'] != ''){
            $validData = true;
        }else{
            $schedulerModule->addMessage('Bitte geben Sie einen Betreff ein!', \TYPO3\CMS\Core\Messaging\FlashMessage::ERROR);
        }
        return $validData;
    }

    protected function getDailyReportExternalReceiverEmailsField(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
        /**
         * @var $task \SG\SgEstateImportOpenimmo\Tasks\Import
         */

        if (empty($taskInfo['task_sgestateimportopenimmo_dailyreportexternalreceiveremails'])) {
            if ($schedulerModule->CMD === 'add') {
                $taskInfo['task_sgestateimportopenimmo_dailyreportexternalreceiveremails'] = '';
            } elseif ($schedulerModule->CMD === 'edit') {
                $taskInfo['task_sgestateimportopenimmo_dailyreportexternalreceiveremails'] = implode(",",$task->getDailyReportExternalReceiverEmails());
            }
        }

        $fieldName = 'tx_scheduler[task_sgestateimportopenimmo_dailyreportexternalreceiveremails]';
        $fieldId = 'task_sgestateimportopenimmo_dailyreportexternalreceiveremails';
        $fieldHtml = '<textarea class="form-control" name="' . $fieldName . '" ' . 'id="' . $fieldId . '" rows="5" cols="50">'.$taskInfo['task_sgestateimportopenimmo_dailyreportexternalreceiveremails'] .'</textarea>';
        $fieldConfiguration = array(
            'code' => $fieldHtml,
            'label' => 'Externe Empfänger E-Mails für den Report (kommagetrennt)',
            'cshKey' => '_MOD_system_txschedulerM1',
            'cshLabel' => $fieldId
        );
        return $fieldConfiguration;
    }

    protected function getDailyReportExternalSubjectField(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
        /**
         * @var $task \SG\SgEstateImportOpenimmo\Tasks\Import
         */

        if (empty($taskInfo['task_sgestateimportopenimmo_dailyreportexternalsubject'])) {
            if ($schedulerModule->CMD === 'add') {
                $taskInfo['task_sgestateimportopenimmo_dailyreportexternalsubject'] = '';
            } elseif ($schedulerModule->CMD === 'edit') {
                $taskInfo['task_sgestateimportopenimmo_dailyreportexternalsubject'] = $task->getDailyReportExternalSubject();
            }
        }

        $fieldName = 'tx_scheduler[task_sgestateimportopenimmo_dailyreportexternalsubject]';
        $fieldId = 'task_sgestateimportopenimmo_dailyreportexternalsubject';
        $fieldHtml = '<input class="form-control" type="text" ' . 'name="' . $fieldName . '" ' . 'id="' . $fieldId . '" value="' . $taskInfo['task_sgestateimportopenimmo_dailyreportexternalsubject'] . '" ' . 'size="50" />';
        $fieldConfiguration = array(
            'code' => $fieldHtml,
            'label' => 'Betreff der Report E-Mail an Externe',
            'cshKey' => '_MOD_system_txschedulerM1',
            'cshLabel' => $fieldId
        );
        return $fieldConfiguration;
    }

    protected function validateDailyReportExternalReceiverEmails(array &$submittedData, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
        $validData = true;

        $tempArray = explode(',',$submittedData['task_sgestateimportopenimmo_dailyreportexternalreceiveremails']);

        foreach ($tempArray as $emailaddress){
            if (!\TYPO3\CMS\Core\Utility\GeneralUtility::validEmail($emailaddress)){
                $validData = false;
            }
        }
        if ($validData == false){
            $schedulerModule->addMessage('Bitte geben Sie nur gültige E-Mail Adressen ein!', \TYPO3\CMS\Core\Messaging\FlashMessage::ERROR);
        }
        return $validData;
    }

    protected function validateDailyReportExternalSubject(array &$submittedData, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
        $validData = false;
        if ($submittedData['task_sgestateimportopenimmo_dailyreportexternalsubject'] != ''){
            $validData = true;
        }else{
            $schedulerModule->addMessage('Bitte geben Sie einen Betreff für die Mail an Externe ein!', \TYPO3\CMS\Core\Messaging\FlashMessage::ERROR);
        }
        return $validData;
    }
}