<?php
namespace SG\SgEstateImportOpenimmo\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use TYPO3\CMS\Core\Core\Environment;

class ClearlogCommand extends Command
{

    /**
     * @var string
     */
    private $logFile = '';


    protected function configure()
    {
        $this->setName('sg.estate.import.openimmo.clearlog');
        $this->setDescription('Clear import log');
        $this->addArgument('importIdentifier', InputArgument::REQUIRED, 'Unique Identifier for this Import (must be numeric)'); // 7
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        if ($this->preprocess($input, $output)) {
            file_put_contents($this->logFile, '');
        }
        return 0;
    }

    private function preprocess(InputInterface $input, OutputInterface $output)
    {
        $basePathForImportCommand = Environment::getVarPath() . '/uploads/tx_sgestateimportopenimmo/' . $input->getArgument('importIdentifier');
        $this->logFile = $basePathForImportCommand . '/log/log.json';
        return true;
    }
}
