<?php
namespace SG\SgEstateImportOpenimmo\Tasks;

use DateInterval;
use DateTime;
use TYPO3\CMS\Scheduler\Task\AbstractTask;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;

class DailyReport extends AbstractTask {
    /**************************************
     * BEGIN
     * Members for Task-Settings
     ***************************************/

    /**
     * @var string
     */
    protected $dailyReportSenderEmail = '';

    /**
     * @var array
     */
    protected $dailyReportReceiverEmails = array();

    /**
     * @var array
     */
    protected $dailyReportExternalReceiverEmails = array();

    /**
     * @var string
     */
    protected $dailyReportSubject = '';

    /**
     * @var string
     */
    protected $dailyReportExternalSubject = '';


    /********************************
     * END
     * Members for Task-Settings
     ********************************/

    public function execute(){
        $imports = $this->getDailyImports();
        $estateCoreServices = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\CMS\Extbase\Object\ObjectManager')->get('SG\SgEstateCore\Util\Services');
        $estateCoreServices->sendTemplateEmail(
            $this->getDailyReportReceiverEmails(),
            array(),
            $this->getDailyReportSenderEmail(),
            $this->getDailyReportSubject(),
            'EXT:sg_estate_import_openimmo/Resources/Private/Templates/Email/',
            'DailyReport',
            array(
                'dailyImports' => [
                    "startdate" => $imports["startdate"],
                    "enddate" => $imports["enddate"],
                    "count_partial" => $imports["count_partial"],
                    "count_full" => $imports["count_full"],
                    "count_added" => $imports["count_added"],
                    "count_updated" => $imports["count_updated"],
                    "count_deleted" => $imports["count_deleted"],
                    "imports" => [
                        $imports["imports"]
                    ]
                ]
            ),
            array(),
            'html'
        );

        return true;
    }

    protected function getDailyImports(){
        $today = new DateTime();
        $today->setTime(18,0,0);
        $yesterday = new DateTime();
        $yesterday->setTime(18,0,0);
        $yesterday->sub(new DateInterval('P1D'));

        $query_builder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('tx_sgimportopenimmo_domain_model_importreport');
        $statement = $query_builder
            ->select('*')
            ->from('tx_sgimportopenimmo_domain_model_importreport')
            ->where(
                'end > :yesterday AND end < :today'
            )
            ->setParameter('yesterday', $yesterday->getTimestamp())
            ->setParameter('today', $today->getTimestamp())
            ->execute();

        $count_partial = 0;
        $count_full = 0;
        $count_added = 0;
        $count_updated = 0;
        $count_deleted = 0;
        $counter = 0;

        $entry = array();
        while ($row = $statement->fetch()) {
            $counter++;
            $row_start = $row['start'];
            $temp_start = new DateTime("@$row_start");
            $temp_start->setTimezone(new DateTimeZone('Europe/Berlin'));
            $row_end = $row['end'];
            $temp_end = new DateTime("@$row_end");
            $temp_end->setTimezone(new DateTimeZone('Europe/Berlin'));

            $temp['counter'] = $counter;
            $temp['uid'] = $row['uid'];
            $temp['start'] = $temp_start->format("d.m.Y H:i:s");
            $temp['end'] = $temp_end->format("d.m.Y H:i:s");
            $temp['identifier'] = $row['import_identifier'];
            $temp['typ'] = $row['typ'];
            if ($temp["typ"] === "partial"){$temp['typ_string'] = "Teilabgleich"; $count_partial++;}
            else if ($temp["typ"] === "full"){$temp['typ_string'] = "Vollabgleich"; $count_full++;}
            $temp['counter_added'] = $row['counter_added'];
            $count_added = $count_added + $temp['counter_added'];
            $temp['counter_changed'] = $row['counter_changed'];
            $count_updated = $count_updated + $temp['counter_changed'];
            $temp['counter_deleted'] = $row['counter_deleted'];
            $count_deleted = $count_deleted + $temp['counter_deleted'];

            $entry[] = $temp;
        }
        return array(
            "startdate" => $yesterday->format('d.m.Y'),
            "enddate" => $today->format('d.m.Y'),
            "count_partial" => $count_partial,
            "count_full" => $count_full,
            "count_added" => $count_added,
            "count_updated" => $count_updated,
            "count_deleted" => $count_deleted,
            "imports" => $entry
        );
    }

    /**
     * @return string
     */
    public function getDailyReportSenderEmail()
    {
        return $this->dailyReportSenderEmail;
    }

    /**
     * @param string $reportSenderEmail
     * @return $this
     */
    public function setDailyReportSenderEmail($dailyReportSenderEmail)
    {
        $this->dailyReportSenderEmail = $dailyReportSenderEmail;
        return $this;
    }

    /**
     * @return array
     */
    public function getDailyReportReceiverEmails()
    {
        return $this->dailyReportReceiverEmails;
    }

    /**
     * @param array $dailyReportReceiverEmails
     * @return $this
     */
    public function setDailyReportReceiverEmails($dailyReportReceiverEmails)
    {
        $this->dailyReportReceiverEmails = $dailyReportReceiverEmails;
        return $this;
    }

    /**
     * @return string
     */
    public function getDailyReportSubject()
    {
        return $this->dailyReportSubject;
    }

    /**
     * @param string $dailyReportSubject
     * @return $this
     */
    public function setDailyReportSubject($dailyReportSubject)
    {
        $this->dailyReportSubject = $dailyReportSubject;
        return $this;
    }

    /**
     * @return array
     */
    public function getDailyReportExternalReceiverEmails()
    {
        return $this->dailyReportExternalReceiverEmails;
    }

    /**
     * @param array $dailyReportReceiverEmails
     * @return $this
     */
    public function setDailyReportExternalReceiverEmails($dailyReportExternalReceiverEmails): DailyReport
    {
        $this->dailyReportExternalReceiverEmails = $dailyReportExternalReceiverEmails;
        return $this;
    }

    /**
     * @return string
     */
    public function getDailyReportExternalSubject()
    {
        return $this->dailyReportExternalSubject;
    }

    /**
     * @param string $dailyReportSubject
     * @return $this
     */
    public function setDailyReportExternalSubject($dailyReportExternalSubject)
    {
        $this->dailyReportExternalSubject = $dailyReportExternalSubject;
        return $this;
    }
}