<?php
namespace SG\SgEstateImportOpenimmo\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use TYPO3\CMS\Core\Core\Environment;

class ReadlogCommand extends Command
{

    /**
     * @var string
     */
    private $logFile = '';


    protected function configure()
    {
        $this->setName('sg.estate.import.openimmo.readlog');
        $this->setDescription('Read import log');
        $this->addArgument('importIdentifier', InputArgument::REQUIRED, 'Unique Identifier for this Import (must be numeric)'); // 7
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        if ($this->preprocess($input, $output)) {
            $current = file_get_contents($this->logFile);
            foreach(explode("\n\n\n\n\n\n", $current) as $json) {
                echo '<pre>', print_r(json_decode($json), true), '</pre>';
                echo "<br><br>";
            }
        }
        $this->postprocess($input, $output);
        return 0;
    }

    private function preprocess(InputInterface $input, OutputInterface $output)
    {
        $basePathForImportCommand = Environment::getPublicPath() . '/uploads/tx_sgestateimportopenimmo/' . $input->getArgument('importIdentifier');
        $this->logFile = $basePathForImportCommand . '/log/log.json';
        return true;
    }

    private function postprocess(InputInterface $input, OutputInterface $output)
    {
        return true;
    }

}
