<?php
    require_once(\TYPO3\CMS\Core\Utility\ExtensionManagementUtility::extPath('sg_estate_import_is24').'/Classes/Util/Immocaster/Sdk.php');
    class ext_update
    {

        private $oImmocaster;

        private $extConf;

        private $usernamesToCert = array();

        public function __construct(){
            $this->extConf = unserialize($GLOBALS['TYPO3_CONF_VARS']['EXT']['extConf']['sg_estate_import_is24']);
        }

        public function access() {
            $rows = $GLOBALS['TYPO3_DB']->exec_SELECTgetRows(
                'uid,serialized_task_object',
                'tx_scheduler_task',
                ''
            );
            $usernames = array();
            foreach($rows as $entry){
                $task = unserialize($entry['serialized_task_object']);
                if ($task instanceof SG\SgEstateImportIs24\Tasks\Import){
                  $usernames[] = array($task->getUsername(), $task->getUselive(), $task->getApiKey(), $task->getApiSecret());
                }
            }

            foreach ($usernames as $username){
                $rows = $GLOBALS['TYPO3_DB']->exec_SELECTgetRows(
                    'ic_id',
                    'tx_sgestateimportis24_immocaster',
                    'ic_username = "'.$username[0].'"'
                );
                if (count($rows) == 0){
                    $this->usernamesToCert[] = $username;
                }
            }


            if (count($this->usernamesToCert) > 0){
                return true;
            }else{
                return false;
            }


        }

        public function main(){
          $this->oImmocaster = Immocaster_Sdk::getInstance('is24',$this->usernamesToCert[0][2],$this->usernamesToCert[0][3]);
          $this->oImmocaster->setDataStorage(array(
            'mysql',
            $GLOBALS['TYPO3_CONF_VARS']['DB']['Connections']['Default']['host'],
            $GLOBALS['TYPO3_CONF_VARS']['DB']['Connections']['Default']['user'],
            $GLOBALS['TYPO3_CONF_VARS']['DB']['Connections']['Default']['password'],
            $GLOBALS['TYPO3_CONF_VARS']['DB']['Connections']['Default']['dbname']
          ),null,'tx_sgestateimportis24_immocaster');

          $this->oImmocaster->authenticateWithoutDB(false);
            $this->oImmocaster->useHttps(true);
            if ($this->usernamesToCert[0][1] == 1){
                $this->oImmocaster->setRequestUrl('live');
            }

            $sCertifyURL = \TYPO3\CMS\Core\Utility\GeneralUtility::getIndpEnv('REQUEST_URI'); // Komplette URL inkl. Parameter auf der das Script eingebunden wird
            if(isset($_GET['main_registration'])||isset($_GET['state']))
            {
                if(isset($_POST['user'])){ $sUser=$_POST['user']; }
                if(isset($_GET['user'])){ $sUser=$_GET['user']; }

                $aParameter = array('callback_url'=>\TYPO3\CMS\Core\Utility\GeneralUtility::getIndpEnv('TYPO3_REQUEST_URL').'&user='.$sUser,'verifyApplication'=>true);

                // Benutzer neu zertifizieren
                if($this->oImmocaster->getAccess($aParameter))
                {
                    print_r($this->oImmocaster->getAccess($aParameter));
                    $content = '<div id="appVerifyInfo">Zertifizierung war erfolgreich.</div>';
                }
                else
                {
                    // Test ob Benutzer schon zertifiziert ist
                    if($this->oImmocaster->getApplicationTokenAndSecret($sUser))
                    {
                        $content =  '<div id="appVerifyInfo">Dieser Benutzer ist bereits zertifiziert.</div>';
                    }
                }
            }else{
                if ($this->usernamesToCert[0][1] == 1){
                    $content = '<p>Live-System</p>';
                }else{
                    $content = '<p>Sandbox-System</p>';
                }
                $content .=  '
                    <form action="'.$sCertifyURL.'&main_registration=1" method="post">
                        <div id="appVerifyButton">
                            Benutzername: <input type="text" name="user" value="'.$this->usernamesToCert[0][0].'" readonly="readonly" /><br />
                            <input type="submit" value="Jetzt zertifizieren" />
                        </div>
                    </form>
                    ';
            }

            return $content;
        }
    }