<?php
namespace SG\SgEstateImportIs24\Tasks;

class ImportAdditionalFieldProvider implements \TYPO3\CMS\Scheduler\AdditionalFieldProviderInterface {

  /**
   * Gets additional fields to render in the form to add/edit a task
   *
   * @param array $taskInfo Values of the fields from the add/edit task form
   * @param \TYPO3\CMS\Scheduler\Task\AbstractTask $task The task object being edited. Null when adding a task!
   * @param \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule Reference to the scheduler backend module
   * @return array A two dimensional array, array('Identifier' => array('fieldId' => array('code' => '', 'label' => '', 'cshKey' => '', 'cshLabel' => ''))
   */
  public function getAdditionalFields(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule)
  {
    $additionalFields['task_sgestateimportis24_title']            = $this->getTitleAdditionalField($taskInfo, $task, $schedulerModule);
    $additionalFields['task_sgestateimportis24_storagepid']       = $this->getStoragePidAdditionalField($taskInfo, $task, $schedulerModule);
    $additionalFields['task_sgestateimportis24_username']         = $this->getUsernameAdditionalField($taskInfo, $task, $schedulerModule);
    $additionalFields['task_sgestateimportis24_reportsenderemail']= $this->getReportSenderEmailField($taskInfo, $task, $schedulerModule);
    $additionalFields['task_sgestateimportis24_reportversandan']  = $this->getReportVersandAnAdditionalField($taskInfo, $task, $schedulerModule);
    $additionalFields['task_sgestateimportis24_alertversandan']   = $this->getAlertVersandAnAdditionalField($taskInfo, $task, $schedulerModule);
    $additionalFields['task_sgestateimportis24_typesforimport']   = $this->getTypesForImport($taskInfo, $task, $schedulerModule);
    $additionalFields['task_sgestateimportis24_imagewidth']       = $this->getImageWidth($taskInfo, $task, $schedulerModule);
    $additionalFields['task_sgestateimportis24_imageheight']      = $this->getImageHeight($taskInfo, $task, $schedulerModule);
    $additionalFields['task_sgestateimportis24_uselive']          = $this->getUseliveAdditionalField($taskInfo, $task, $schedulerModule);
    $additionalFields['task_sgestateimportis24_publishchannel']   = $this->getPublishChannelField($taskInfo, $task, $schedulerModule);
    $additionalFields['task_sgestateimportis24_apikey']           = $this->getApiKeyField($taskInfo, $task, $schedulerModule);
    $additionalFields['task_sgestateimportis24_apisecret']        = $this->getApiSecretField($taskInfo, $task, $schedulerModule);


    return $additionalFields;
  }

  public function validateAdditionalFields(array &$submittedData, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule)
  {
    $validData = $this->validateTitleAdditionalField($submittedData, $schedulerModule);
    $validData &= $this->validateStoragePidAdditionalField($submittedData, $schedulerModule);
    $validData &= $this->validateUsernameAdditionalField($submittedData, $schedulerModule);
    $validData &= $this->validateReportSenderEmail($submittedData, $schedulerModule);
    $validData &= $this->validateReportVersandAnAdditionalField($submittedData, $schedulerModule);
    $validData &= $this->validateAlertVersandAnAdditionalField($submittedData, $schedulerModule);
    $validData &= $this->validateTypesForImport($submittedData, $schedulerModule);
    $validData &= $this->validateImageWidth($submittedData, $schedulerModule);
    $validData &= $this->validateImageHeight($submittedData, $schedulerModule);
    $validData &= $this->validatePublishChannel($submittedData, $schedulerModule);
    $validData &= $this->validateApiKeyAdditionalField($submittedData, $schedulerModule);
    $validData &= $this->validateApiSecretAdditionalField($submittedData, $schedulerModule);

    return $validData;
  }

  public function saveAdditionalFields(array $submittedData, \TYPO3\CMS\Scheduler\Task\AbstractTask $task)
  {
    /**
     * @var $task \SG\SgEstateImportIs24\Tasks\Import
     */
    $task->setTitle($submittedData['task_sgestateimportis24_title']);
    $task->setStoragePid((int)$submittedData['task_sgestateimportis24_storagepid']);
    $task->setUsername($submittedData['task_sgestateimportis24_username']);
    $task->setReportSenderEmail($submittedData['task_sgestateimportis24_reportsenderemail']);
    $task->setReportVersandAn(\TYPO3\CMS\Core\Utility\GeneralUtility::trimExplode(LF, $submittedData['task_sgestateimportis24_reportversandan'], TRUE));
    $task->setAlertVersandAn(\TYPO3\CMS\Core\Utility\GeneralUtility::trimExplode(LF, $submittedData['task_sgestateimportis24_alertversandan'], TRUE));
    $task->setTypesForImport($submittedData['task_sgestateimportis24_typesforimport']);
    $task->setImageWidth($submittedData['task_sgestateimportis24_imagewidth']);
    $task->setImageHeight($submittedData['task_sgestateimportis24_imageheight']);
    $task->setUselive($submittedData['task_sgestateimportis24_uselive']);
    $task->setPublishChannel($submittedData['task_sgestateimportis24_publishchannel']);
    $task->setApiKey($submittedData['task_sgestateimportis24_apikey']);
    $task->setApiSecret($submittedData['task_sgestateimportis24_apisecret']);
  }

  protected function getTitleAdditionalField(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
    /**
     * @var $task \SG\SgEstateImportIs24\Tasks\Import
     */
    if (empty($taskInfo['task_sgestateimportis24_title'])) {
      if ($schedulerModule->CMD === 'add') {
        $taskInfo['task_sgestateimportis24_title'] = '';
      } elseif ($schedulerModule->CMD === 'edit') {
        $taskInfo['task_sgestateimportis24_title'] = $task->getTitle();
      }
    }

    $fieldName = 'tx_scheduler[task_sgestateimportis24_title]';
    $fieldId = 'task_sgestateimportis24_title';
    $fieldHtml = '<input type="text" ' . 'name="' . $fieldName . '" ' . 'id="' . $fieldId . '" value="' . $taskInfo['task_sgestateimportis24_title'] . '" ' . ' />';
    $fieldConfiguration = array(
      'code' => $fieldHtml,
      'label' => 'Task Title',
      'cshKey' => '_MOD_system_txschedulerM1',
      'cshLabel' => $fieldId
    );
    return $fieldConfiguration;
  }

  protected function getStoragePidAdditionalField(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule) {
    /**
     * @var $task \SG\SgEstateImportIs24\Tasks\Import
     */

    if (empty($taskInfo['task_sgestateimportis24_storagepid'])) {
      if ($schedulerModule->CMD === 'add') {
        $taskInfo['task_sgestateimportis24_storagepid'] = 0;
      } elseif ($schedulerModule->CMD === 'edit') {
        $taskInfo['task_sgestateimportis24_storagepid'] = $task->getStoragePid();
      }
    }

    $fieldName = 'tx_scheduler[task_sgestateimportis24_storagepid]';
    $fieldId = 'task_sgestateimportis24_storagepid';
    $fieldHtml = '<input type="text" ' . 'name="' . $fieldName . '" ' . 'id="' . $fieldId . '" value="' . (int)$taskInfo['task_sgestateimportis24_storagepid'] . '" ' . 'size="4" />';
    $fieldConfiguration = array(
      'code' => $fieldHtml,
      'label' => 'PID des Immobilienspeichers',
      'cshKey' => '_MOD_system_txschedulerM1',
      'cshLabel' => $fieldId
    );
    return $fieldConfiguration;
  }

  protected function getUsernameAdditionalField(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
    /**
     * @var $task \SG\SgEstateImportIs24\Tasks\Import
     */

    if (empty($taskInfo['task_sgestateimportis24_username'])) {
      if ($schedulerModule->CMD === 'add') {
        $taskInfo['task_sgestateimportis24_username'] = '';
      } elseif ($schedulerModule->CMD === 'edit') {
        $taskInfo['task_sgestateimportis24_username'] = $task->getUsername();
      }
    }

    $fieldName = 'tx_scheduler[task_sgestateimportis24_username]';
    $fieldId = 'task_sgestateimportis24_username';
    $fieldHtml = '<input type="text" ' . 'name="' . $fieldName . '" ' . 'id="' . $fieldId . '" value="' . $taskInfo['task_sgestateimportis24_username'] . '" ' . ' />';
    $fieldConfiguration = array(
      'code' => $fieldHtml,
      'label' => 'Username des Maklers bei IS24',
      'cshKey' => '_MOD_system_txschedulerM1',
      'cshLabel' => $fieldId
    );
    return $fieldConfiguration;
  }

  protected function getReportSenderEmailField(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
    /**
     * @var $task \SG\SgEstateImportIs24\Tasks\Import
     */

    if (empty($taskInfo['task_sgestateimportis24_reportsenderemail'])) {
      if ($schedulerModule->CMD === 'add') {
        $taskInfo['task_sgestateimportis24_reportsenderemail'] = '';
      } elseif ($schedulerModule->CMD === 'edit') {
        $taskInfo['task_sgestateimportis24_reportsenderemail'] = $task->getReportSenderEmail();
      }
    }

    $fieldName = 'tx_scheduler[task_sgestateimportis24_reportsenderemail]';
    $fieldId = 'task_sgestateimportis24_reportsenderemail';
    $fieldHtml = '<input type="text" ' . 'name="' . $fieldName . '" ' . 'id="' . $fieldId . '" value="' . $taskInfo['task_sgestateimportis24_reportsenderemail'] . '" ' . 'size="50" />';
    $fieldConfiguration = array(
      'code' => $fieldHtml,
      'label' => 'Absender E-Mail Adresse für Report',
      'cshKey' => '_MOD_system_txschedulerM1',
      'cshLabel' => $fieldId
    );
    return $fieldConfiguration;
  }

  protected function getReportVersandAnAdditionalField(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
    /**
     * @var $task \SG\SgEstateImportIs24\Tasks\Import
     */

    if (empty($taskInfo['task_sgestateimportis24_reportversandan'])) {
      if ($schedulerModule->CMD === 'add') {
        $taskInfo['task_sgestateimportis24_reportversandan'] = '';
      } elseif ($schedulerModule->CMD === 'edit') {
        $taskInfo['task_sgestateimportis24_reportversandan'] = implode(LF, $task->getReportVersandAn());
      }
    }

    $fieldName = 'tx_scheduler[task_sgestateimportis24_reportversandan]';
    $fieldId = 'task_sgestateimportis24_reportversandan';
    $fieldHtml = '<textarea rows="4" cols="40" ' . 'name="' . $fieldName . '" ' . 'id="' . $fieldId . '">'.$taskInfo['task_sgestateimportis24_reportversandan'].'</textarea>';
    $fieldConfiguration = array(
      'code' => $fieldHtml,
      'label' => 'Versand des Reports (Eine E-Mail-Adresse pro Zeile)',
      'cshKey' => '_MOD_system_txschedulerM1',
      'cshLabel' => $fieldId
    );
    return $fieldConfiguration;
  }

  protected function getAlertVersandAnAdditionalField(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
    /**
     * @var $task \SG\SgEstateImportIs24\Tasks\Import
     */

    if (empty($taskInfo['task_sgestateimportis24_alertversandan'])) {
      if ($schedulerModule->CMD === 'add') {
        $taskInfo['task_sgestateimportis24_alertversandan'] = '';
      } elseif ($schedulerModule->CMD === 'edit') {
        $taskInfo['task_sgestateimportis24_alertversandan'] = implode(LF, $task->getAlertVersandAn());
      }
    }

    $fieldName = 'tx_scheduler[task_sgestateimportis24_alertversandan]';
    $fieldId = 'task_sgestateimportis24_alertversandan';
    $fieldHtml = '<textarea rows="4" cols="40" ' . 'name="' . $fieldName . '" ' . 'id="' . $fieldId . '">'.$taskInfo['task_sgestateimportis24_alertversandan'].'</textarea>';
    $fieldConfiguration = array(
      'code' => $fieldHtml,
      'label' => 'Versand von Warnungen (Eine E-Mail-Adresse pro Zeile)',
      'cshKey' => '_MOD_system_txschedulerM1',
      'cshLabel' => $fieldId
    );
    return $fieldConfiguration;
  }

  protected function getTypesForImport(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
    /**
     * @var $task \SG\SgEstateImportIs24\Tasks\Import
     */

    if (empty($taskInfo['task_sgestateimportis24_typesforimport'])) {
      if ($schedulerModule->CMD === 'add') {
        $taskInfo['task_sgestateimportis24_typesforimport'] = null;
      } elseif ($schedulerModule->CMD === 'edit') {
        $taskInfo['task_sgestateimportis24_typesforimport'] = $task->getTypesForImport();
      }
    }

    $fieldName = 'tx_scheduler[task_sgestateimportis24_typesforimport][]';
    $fieldId = 'task_sgestateimportis24_typesforimport';

    $allTypesForImport = array(
      'offerlistelement:OfferApartmentRent'           => 'Wohnung Miete',
      'offerlistelement:OfferHouseRent'               => 'Haus Miete',
      'offerlistelement:OfferApartmentBuy'            => 'Wohnung Kauf',
      'offerlistelement:OfferHouseBuy'                => 'Haus Kauf',
      'offerlistelement:OfferShortTermAccommodation'  => 'Wohnen auf Zeit',
      'offerlistelement:OfferGarageBuy'               => 'Garage Kauf',
      'offerlistelement:OfferGarageRent'              => 'Garage Miete',
      'offerlistelement:OfferOffice'                  => 'Büro',
      'offerlistelement:OfferStore'                   => 'Geschäft',
      'offerlistelement:OfferGastronomy'              => 'Gastronomie',
      'offerlistelement:OfferIndustry'                => 'Industrie',
      'offerlistelement:OfferInvestment'              => 'Investment',
      'offerlistelement:OfferLivingBuySite'           => 'LivingBuySite',
      'offerlistelement:OfferLivingRentSite'          => 'LivingRentSite',
      'offerlistelement:OfferTradeSite'               => 'TradeSite',
      'offerlistelement:OfferSpecialPurpose'          => 'SpecialPurpose',
      'offerlistelement:OfferHouseType'               => 'OfferHouseType',
      'offerlistelement:OfferFlatShareRoom'           => 'FlatShareRoom',
      'offerlistelement:OfferAssistedLiving'          => 'AssistedLiving',
      'offerlistelement:OfferSeniorCare'              => 'SeniorCar',
      'offerlistelement:OfferCompulsoryAuction'       => 'Zwangsversteigerung',
    );

    $fieldHtml = '<select name="'.$fieldName.'" id="'.$fieldId.'" multiple="multiple" size="10">';
    foreach($allTypesForImport as $key => $value){
      $selected = '';
      if ((is_array($taskInfo['task_sgestateimportis24_typesforimport']))&&(in_array($key, $taskInfo['task_sgestateimportis24_typesforimport']))){
        $selected = 'selected="selected"';
      }
      $fieldHtml .= '<option value="'.$key.'" '.$selected.'>'.$value.'</option>';
    }
    $fieldHtml .= '</select>';


    $fieldConfiguration = array(
      'code' => $fieldHtml,
      'label' => 'Zu importierende Immobilientypen',
      'cshKey' => '_MOD_system_txschedulerM1',
      'cshLabel' => $fieldId
    );
    return $fieldConfiguration;
  }

  protected function getImageWidth(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
    /**
     * @var $task \SG\SgEstateImportIs24\Tasks\Import
     */

    if (empty($taskInfo['task_sgestateimportis24_imagewidth'])) {
      if ($schedulerModule->CMD === 'add') {
        $taskInfo['task_sgestateimportis24_imagewidth'] = '1024';
      } elseif ($schedulerModule->CMD === 'edit') {
        $taskInfo['task_sgestateimportis24_imagewidth'] = $task->getImageWidth();
      }
    }

    $fieldName = 'tx_scheduler[task_sgestateimportis24_imagewidth]';
    $fieldId = 'task_sgestateimportis24_imagewidth';
    $fieldHtml = '<input type="text" ' . 'name="' . $fieldName . '" ' . 'id="' . $fieldId . '" value="' . $taskInfo['task_sgestateimportis24_imagewidth'] . '" ' . ' />';
    $fieldConfiguration = array(
      'code' => $fieldHtml,
      'label' => 'Breite der importierten Bilder',
      'cshKey' => '_MOD_system_txschedulerM1',
      'cshLabel' => $fieldId
    );
    return $fieldConfiguration;
  }

  protected function getImageHeight(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
    /**
     * @var $task \SG\SgEstateImportIs24\Tasks\Import
     */

    if (empty($taskInfo['task_sgestateimportis24_imageheight'])) {
      if ($schedulerModule->CMD === 'add') {
        $taskInfo['task_sgestateimportis24_imageheight'] = '768';
      } elseif ($schedulerModule->CMD === 'edit') {
        $taskInfo['task_sgestateimportis24_imageheight'] = $task->getImageHeight();
      }
    }

    $fieldName = 'tx_scheduler[task_sgestateimportis24_imageheight]';
    $fieldId = 'task_sgestateimportis24_imageheight';
    $fieldHtml = '<input type="text" ' . 'name="' . $fieldName . '" ' . 'id="' . $fieldId . '" value="' . $taskInfo['task_sgestateimportis24_imageheight'] . '" ' . ' />';
    $fieldConfiguration = array(
      'code' => $fieldHtml,
      'label' => 'Höhe der importierten Bilder',
      'cshKey' => '_MOD_system_txschedulerM1',
      'cshLabel' => $fieldId
    );
    return $fieldConfiguration;
  }

  protected function getUseliveAdditionalField(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
    /**
     * @var $task \SG\SgEstateImportIs24\Tasks\Import
     */

    if (empty($taskInfo['task_sgestateimportis24_uselive'])) {
      if ($schedulerModule->CMD === 'add') {
        $taskInfo['task_sgestateimportis24_uselive'] = 0;
      } elseif ($schedulerModule->CMD === 'edit') {
        $taskInfo['task_sgestateimportis24_uselive'] = $task->getUselive();
      }
    }

    $fieldName = 'tx_scheduler[task_sgestateimportis24_uselive]';
    $fieldId = 'task_sgestateimportis24_uselive';
    if ($taskInfo['task_sgestateimportis24_uselive'] == 1){
      $selected = 'checked="checked"';
    }else{
      $selected = '';
    }

    $fieldHtml = '<input type="checkbox" ' . 'name="' . $fieldName . '" ' . 'id="' . $fieldId . '" value="1" ' . $selected.' />';
    $fieldConfiguration = array(
      'code' => $fieldHtml,
      'label' => 'Live-System verwenden',
      'cshKey' => '_MOD_system_txschedulerM1',
      'cshLabel' => $fieldId
    );
    return $fieldConfiguration;
  }

  protected function getPublishChannelField(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
    /**
     * @var $task \SG\SgEstateImportIs24\Tasks\Import
     */

    if (empty($taskInfo['task_sgestateimportis24_publishchannel'])) {
      if ($schedulerModule->CMD === 'add') {
        $taskInfo['task_sgestateimportis24_publishchannel'] = null;
      } elseif ($schedulerModule->CMD === 'edit') {
        $taskInfo['task_sgestateimportis24_publishchannel'] = $task->getPublishChannel();
      }
    }

    $fieldName = 'tx_scheduler[task_sgestateimportis24_publishchannel]';
    $fieldId = 'task_sgestateimportis24_publishchannel';

    $allPublishChannels = array(
      'Homepage'          => 'Anbieterseite bei IS24',
      'IS24'              => 'Immobilienscout 24',
    );

    $fieldHtml = '<select name="'.$fieldName.'" id="'.$fieldId.'">';
    foreach($allPublishChannels as $key => $value){
      $selected = '';
      if ($taskInfo['task_sgestateimportis24_publishchannel'] == $key){
        $selected = 'selected="selected"';
      }
      $fieldHtml .= '<option value="'.$key.'" '.$selected.'>'.$value.'</option>';
    }
    $fieldHtml .= '</select>';


    $fieldConfiguration = array(
      'code' => $fieldHtml,
      'label' => 'Channel der importiert werden soll',
      'cshKey' => '_MOD_system_txschedulerM1',
      'cshLabel' => $fieldId
    );
    return $fieldConfiguration;
  }

  protected function getApiKeyField(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
    /**
     * @var $task \SG\SgEstateImportIs24\Tasks\Import
     */

    if (empty($taskInfo['task_sgestateimportis24_apikey'])) {
      if ($schedulerModule->CMD === 'add') {
        $taskInfo['task_sgestateimportis24_apikey'] = '';
      } elseif ($schedulerModule->CMD === 'edit') {
        $taskInfo['task_sgestateimportis24_apikey'] = $task->getApiKey();
      }
    }

    $fieldName = 'tx_scheduler[task_sgestateimportis24_apikey]';
    $fieldId = 'task_sgestateimportis24_apikey';
    $fieldHtml = '<input type="text" ' . 'name="' . $fieldName . '" ' . 'id="' . $fieldId . '" value="' . $taskInfo['task_sgestateimportis24_apikey'] . '" ' . ' />';
    $fieldConfiguration = array(
      'code' => $fieldHtml,
      'label' => 'IS24 API Key',
      'cshKey' => '_MOD_system_txschedulerM1',
      'cshLabel' => $fieldId
    );
    return $fieldConfiguration;
  }

  protected function getApiSecretField(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
    /**
     * @var $task \SG\SgEstateImportIs24\Tasks\Import
     */

    if (empty($taskInfo['task_sgestateimportis24_apisecret'])) {
      if ($schedulerModule->CMD === 'add') {
        $taskInfo['task_sgestateimportis24_apisecret'] = '';
      } elseif ($schedulerModule->CMD === 'edit') {
        $taskInfo['task_sgestateimportis24_apisecret'] = $task->getApiSecret();
      }
    }

    $fieldName = 'tx_scheduler[task_sgestateimportis24_apisecret]';
    $fieldId = 'task_sgestateimportis24_apisecret';
    $fieldHtml = '<input type="text" ' . 'name="' . $fieldName . '" ' . 'id="' . $fieldId . '" value="' . $taskInfo['task_sgestateimportis24_apisecret'] . '" ' . ' />';
    $fieldConfiguration = array(
      'code' => $fieldHtml,
      'label' => 'IS24 API Secret',
      'cshKey' => '_MOD_system_txschedulerM1',
      'cshLabel' => $fieldId
    );
    return $fieldConfiguration;
  }

  protected function validateTitleAdditionalField(array &$submittedData, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule) {
    $validData = FALSE;
    if (!isset($submittedData['task_sgestateimportis24_title'])) {
      $validData = TRUE;
    } elseif ((int)$submittedData['task_sgestateimportis24_title'] >= 0) {
      $validData = TRUE;
    } else {
      $schedulerModule->addMessage('Bitte einen Title eingeben!', \TYPO3\CMS\Core\Messaging\FlashMessage::ERROR);
    }
    return $validData;
  }

  protected function validateStoragePidAdditionalField(array &$submittedData, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule) {
    $validData = FALSE;
    if (!isset($submittedData['task_sgestateimportis24_storagepid'])) {
      $validData = TRUE;
    } elseif ((int)$submittedData['task_sgestateimportis24_storagepid'] >= 0) {
      $validData = TRUE;
    } else {
      $schedulerModule->addMessage('Bitte eine gültige PID eingeben!', \TYPO3\CMS\Core\Messaging\FlashMessage::ERROR);
    }
    return $validData;
  }

  protected function validateReportSenderEmail(array &$submittedData, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
    $validData = false;
    if (\TYPO3\CMS\Core\Utility\GeneralUtility::validEmail($submittedData['task_sgestateimportis24_reportsenderemail'])){
      $validData = true;
    }else{
      $schedulerModule->addMessage('Bitte geben Sie eine gültige E-Mail Adresse ein!', \TYPO3\CMS\Core\Messaging\FlashMessage::ERROR);
    }
    return $validData;
  }

  protected function validateUsernameAdditionalField(array &$submittedData, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
    $validData = FALSE;
    if (isset($submittedData['task_sgestateimportis24_username'])) {
      $validData = TRUE;
    } else {
      $schedulerModule->addMessage('Bitte einen gültigen Username eingeben!', \TYPO3\CMS\Core\Messaging\FlashMessage::ERROR);
    }
    return $validData;
  }

  protected function validateReportVersandAnAdditionalField(array &$submittedData, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
    $validData = FALSE;
    $tempData = \TYPO3\CMS\Core\Utility\GeneralUtility::trimExplode(LF, $submittedData['task_sgestateimportis24_reportversandan'], TRUE);
    if (is_array($tempData)){
      $invalidAdressFound = FALSE;
      foreach($tempData as $email){
        if (!\TYPO3\CMS\Core\Utility\GeneralUtility::validEmail($email)){
          $invalidAdressFound = TRUE;
        }
      }
      if ($invalidAdressFound){
        $schedulerModule->addMessage('Bitte nur gültige E-Mail Adressen eingeben!', \TYPO3\CMS\Core\Messaging\FlashMessage::ERROR);
      }else{
        $validData = TRUE;
      }

    }else{
      $schedulerModule->addMessage('Bitte mindestens eine E-Mail Adresse für den Reportversand angeben!', \TYPO3\CMS\Core\Messaging\FlashMessage::ERROR);
    }

    return $validData;
  }

  protected function validateAlertVersandAnAdditionalField(array &$submittedData, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
    $validData = FALSE;
    $tempData = \TYPO3\CMS\Core\Utility\GeneralUtility::trimExplode(LF, $submittedData['task_sgestateimportis24_alertversandan'], TRUE);
    if (is_array($tempData)){
      $invalidAdressFound = FALSE;
      foreach($tempData as $email){
        if (!\TYPO3\CMS\Core\Utility\GeneralUtility::validEmail($email)){
          $invalidAdressFound = TRUE;
        }
      }
      if ($invalidAdressFound){
        $schedulerModule->addMessage('Bitte nur gültige E-Mail Adressen eingeben!', \TYPO3\CMS\Core\Messaging\FlashMessage::ERROR);
      }else{
        $validData = TRUE;
      }

    }else{
      $schedulerModule->addMessage('Bitte mindestens eine E-Mail Adresse für den Warnungsversand angeben!', \TYPO3\CMS\Core\Messaging\FlashMessage::ERROR);
    }

    return $validData;
  }

  protected function validateTypesForImport(array &$submittedData, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
    $validData = FALSE;
    if (is_array($submittedData['task_sgestateimportis24_typesforimport'])&&(count($submittedData['task_sgestateimportis24_typesforimport']) > 0)) {
      $validData = TRUE;
    } else {
      $schedulerModule->addMessage('Bitte mindestens einen Importtyp auswählen!', \TYPO3\CMS\Core\Messaging\FlashMessage::ERROR);
    }

    return $validData;
  }

  protected function validateImageWidth(array &$submittedData, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
    $validData = FALSE;
    if (isset($submittedData['task_sgestateimportis24_imagewidth'])) {
      $validData = TRUE;
    } else {
      $schedulerModule->addMessage('Bitte eine gültige Breite eingeben!', \TYPO3\CMS\Core\Messaging\FlashMessage::ERROR);
    }
    return $validData;
  }

  protected function validateImageHeight(array &$submittedData, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
    $validData = FALSE;
    if (isset($submittedData['task_sgestateimportis24_imagewidth'])) {
      $validData = TRUE;
    } else {
      $schedulerModule->addMessage('Bitte eine gültige Breite eingeben!', \TYPO3\CMS\Core\Messaging\FlashMessage::ERROR);
    }
    return $validData;
  }

  protected function validatePublishChannel(array &$submittedData, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
    $validData = FALSE;
    if ($submittedData['task_sgestateimportis24_publishchannel'] != '') {
      $validData = TRUE;
    } else {
      $schedulerModule->addMessage('Bitte einen Channel auswählen!', \TYPO3\CMS\Core\Messaging\FlashMessage::ERROR);
    }

    return $validData;
  }

  protected function validateApiKeyAdditionalField(array &$submittedData, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
    $validData = FALSE;
    if (isset($submittedData['task_sgestateimportis24_apikey'])) {
      $validData = TRUE;
    } else {
      $schedulerModule->addMessage('Bitte einen gültigen ApiKey eingeben!', \TYPO3\CMS\Core\Messaging\FlashMessage::ERROR);
    }
    return $validData;
  }

  protected function validateApiSecretAdditionalField(array &$submittedData, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
    $validData = FALSE;
    if (isset($submittedData['task_sgestateimportis24_apisecret'])) {
      $validData = TRUE;
    } else {
      $schedulerModule->addMessage('Bitte einen gültigen ApiSecret eingeben!', \TYPO3\CMS\Core\Messaging\FlashMessage::ERROR);
    }
    return $validData;
  }
}