<?php
namespace Daho\SgEstateImportCsv\Tasks;

class ImportAdditionalFieldProvider implements \TYPO3\CMS\Scheduler\AdditionalFieldProviderInterface {

    /**
     * Gets additional fields to render in the form to add/edit a task
     *
     * @param array $taskInfo Values of the fields from the add/edit task form
     * @param \TYPO3\CMS\Scheduler\Task\AbstractTask $task The task object being edited. Null when adding a task!
     * @param \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule Reference to the scheduler backend module
     * @return array A two dimensional array, array('Identifier' => array('fieldId' => array('code' => '', 'label' => '', 'cshKey' => '', 'cshLabel' => ''))
     */
    public function getAdditionalFields(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule)
    {
        $additionalFields['task_sgestateimportcsv_storagepid']       = $this->getStoragePidAdditionalField($taskInfo, $task, $schedulerModule);
        $additionalFields['task_sgestateimportcsv_debugmode']        = $this->getDebugModeAdditionalField($taskInfo, $task, $schedulerModule);
        $additionalFields['task_sgestateimportcsv_configpfad']         = $this->getConfigPfadAdditionalField($taskInfo, $task, $schedulerModule);
        $additionalFields['task_sgestateimportcsv_daystokeeparchivefiles'] = $this->getDaysToKeepArchiveFilesField($taskInfo, $task, $schedulerModule);
//        $additionalFields['task_immobilienimportis24_reportversandan']  = $this->getReportVersandAnAdditionalField($taskInfo, $task, $schedulerModule);
//        $additionalFields['task_immobilienimportis24_alertversandan']   = $this->getAlertVersandAnAdditionalField($taskInfo, $task, $schedulerModule);
//        $additionalFields['task_immobilienimportis24_typesforimport']   = $this->getTypesForImport($taskInfo, $task, $schedulerModule);
//        $additionalFields['task_immobilienimportis24_imagewidth']       = $this->getImageWidth($taskInfo, $task, $schedulerModule);
//        $additionalFields['task_immobilienimportis24_imageheight']      = $this->getImageHeight($taskInfo, $task, $schedulerModule);
//        $additionalFields['task_immobilienimportis24_uselive']          = $this->getUseliveAdditionalField($taskInfo, $task, $schedulerModule);
//        $additionalFields['task_immobilienimportis24_publishchannel']   = $this->getPublishChannelField($taskInfo, $task, $schedulerModule);

        return $additionalFields;
    }

    public function validateAdditionalFields(array &$submittedData, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule)
    {
        $validData = $this->validateStoragePidAdditionalField($submittedData, $schedulerModule);
        $validData &= $this->validateConfigPfadAdditionalField($submittedData, $schedulerModule);
        $validData &=   $this->validateDaysToKeepArchiveFiles($submittedData, $schedulerModule);
//        $validData &= $this->validateReportVersandAnAdditionalField($submittedData, $schedulerModule);
//        $validData &= $this->validateAlertVersandAnAdditionalField($submittedData, $schedulerModule);
//        $validData &= $this->validateTypesForImport($submittedData, $schedulerModule);
//        $validData &= $this->validateImageWidth($submittedData, $schedulerModule);
//        $validData &= $this->validateImageHeight($submittedData, $schedulerModule);
//        $validData &= $this->validatePublishChannel($submittedData, $schedulerModule);

        return $validData;
    }

    public function saveAdditionalFields(array $submittedData, \TYPO3\CMS\Scheduler\Task\AbstractTask $task)
    {
        /**
         * @var $task \Daho\SgEstateImportCsv\Tasks\Import
         */

        $task->setStoragePid((int)$submittedData['task_sgestateimportcsv_storagepid']);
        $task->setDebugMode($submittedData['task_sgestateimportcsv_debugmode']);
        $task->setConfigPfad($submittedData['task_sgestateimportcsv_configpfad']);
        $task->setDaysToKeepArchiveFiles($submittedData['task_sgestateimportcsv_daystokeeparchivefiles']);
//        $task->setReportVersandAn(\TYPO3\CMS\Core\Utility\GeneralUtility::trimExplode(LF, $submittedData['task_immobilienimportis24_reportversandan'], TRUE));
//        $task->setAlertVersandAn(\TYPO3\CMS\Core\Utility\GeneralUtility::trimExplode(LF, $submittedData['task_immobilienimportis24_alertversandan'], TRUE));
//        $task->setTypesForImport($submittedData['task_immobilienimportis24_typesforimport']);
//        $task->setImageWidth($submittedData['task_immobilienimportis24_imagewidth']);
//        $task->setImageHeight($submittedData['task_immobilienimportis24_imageheight']);
//        $task->setUselive($submittedData['task_immobilienimportis24_uselive']);
//        $task->setPublishChannel($submittedData['task_immobilienimportis24_publishchannel']);
    }



    protected function getStoragePidAdditionalField(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule) {
        /**
         * @var $task \Daho\SgEstateImportCsv\Tasks\Import
         */

        if (empty($taskInfo['task_sgestateimportcsv_storagepid'])) {
            if ($schedulerModule->CMD === 'add') {
                $taskInfo['task_sgestateimportcsv_storagepid'] = 0;
            } elseif ($schedulerModule->CMD === 'edit') {
                $taskInfo['task_sgestateimportcsv_storagepid'] = $task->getStoragePid();
            }
        }

        $fieldName = 'tx_scheduler[task_sgestateimportcsv_storagepid]';
        $fieldId = 'task_sgestateimportcsv_storagepid';
        $fieldHtml = '<input type="text" ' . 'name="' . $fieldName . '" ' . 'id="' . $fieldId . '" value="' . (int)$taskInfo['task_sgestateimportcsv_storagepid'] . '" ' . 'size="4" />';
        $fieldConfiguration = array(
            'code' => $fieldHtml,
            'label' => 'PID des Immobilienspeichers',
            'cshKey' => '_MOD_system_txschedulerM1',
            'cshLabel' => $fieldId
        );
        return $fieldConfiguration;
    }

    protected function getDebugModeAdditionalField(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
        /**
         * @var $task \Daho\SgEstateImportCsv\Tasks\Import
         */

        if (empty($taskInfo['task_sgestateimportcsv_debugmode'])) {
            if ($schedulerModule->CMD === 'add') {
                $taskInfo['task_sgestateimportcsv_debugmode'] = 0;
            } elseif ($schedulerModule->CMD === 'edit') {
                $taskInfo['task_sgestateimportcsv_debugmode'] = $task->isDebugMode();
            }
        }

        $fieldName = 'tx_scheduler[task_sgestateimportcsv_debugmode]';
        $fieldId = 'task_sgestateimportcsv_debugmode';
        if ($taskInfo['task_sgestateimportcsv_debugmode'] == 1){
            $selected = 'checked="checked"';
        }else{
            $selected = '';
        }

        $fieldHtml = '<input type="checkbox" ' . 'name="' . $fieldName . '" ' . 'id="' . $fieldId . '" value="1" ' . $selected.' />';
        $fieldConfiguration = array(
            'code' => $fieldHtml,
            'label' => 'Debug-Mode aktivieren',
            'cshKey' => '_MOD_system_txschedulerM1',
            'cshLabel' => $fieldId
        );
        return $fieldConfiguration;
    }


    protected function getConfigPfadAdditionalField(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
        /**
         * @var $task \Daho\SgEstateImportCsv\Tasks\Import
         */

        if (empty($taskInfo['task_sgestateimportcsv_configpfad'])) {
            if ($schedulerModule->CMD === 'add') {
                $taskInfo['task_sgestateimportcsv_configpfad'] = '';
            } elseif ($schedulerModule->CMD === 'edit') {
                $taskInfo['task_sgestateimportcsv_configpfad'] = $task->getConfigPfad();
            }
        }

        $fieldName = 'tx_scheduler[task_sgestateimportcsv_configpfad]';
        $fieldId = 'task_sgestateimportcsv_configpfad';
        $fieldHtml = '<input type="text" ' . 'name="' . $fieldName . '" ' . 'id="' . $fieldId . '" value="' . $taskInfo['task_sgestateimportcsv_configpfad'] . '" ' . ' />';
        $fieldConfiguration = array(
            'code' => $fieldHtml,
            'label' => 'Pfad zu den Konfigurationsdateien',
            'cshKey' => '_MOD_system_txschedulerM1',
            'cshLabel' => $fieldId
        );
        return $fieldConfiguration;
    }

  protected function getDaysToKeepArchiveFilesField(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
    /**
     * @var $task \Daho\SgEstateImportCsv\Tasks\Import
     */

    if (empty($taskInfo['task_sgestateimportcsv_daystokeeparchivefiles'])) {
      if ($schedulerModule->CMD === 'add') {
        $taskInfo['task_sgestateimportcsv_daystokeeparchivefiles'] = '7';
      } elseif ($schedulerModule->CMD === 'edit') {
        $taskInfo['task_sgestateimportcsv_daystokeeparchivefiles'] = $task->getDaysToKeepArchiveFiles();
      }
    }

    $fieldName = 'tx_scheduler[task_sgestateimportcsv_daystokeeparchivefiles]';
    $fieldId = 'task_sgestateimportcsv_daystokeeparchivefiles';
    $fieldHtml = '<input type="text" ' . 'name="' . $fieldName . '" ' . 'id="' . $fieldId . '" value="' . $taskInfo['task_sgestateimportcsv_daystokeeparchivefiles'] . '" ' . 'size="5" />';
    $fieldConfiguration = array(
      'code' => $fieldHtml,
      'label' => 'Wieviel Tage sollen die Exporte archiviert werden?',
      'cshKey' => '_MOD_system_txschedulerM1',
      'cshLabel' => $fieldId
    );
    return $fieldConfiguration;
  }

//    protected function getReportVersandAnAdditionalField(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
//        /**
//         * @var $task \DAHO\T3ImmobilienImportIs24\Tasks\Immobilienimport
//         */
//
//        if (empty($taskInfo['task_immobilienimportis24_reportversandan'])) {
//            if ($schedulerModule->CMD === 'add') {
//                $taskInfo['task_immobilienimportis24_reportversandan'] = '';
//            } elseif ($schedulerModule->CMD === 'edit') {
//                $taskInfo['task_immobilienimportis24_reportversandan'] = implode(LF, $task->getReportVersandAn());
//            }
//        }
//
//        $fieldName = 'tx_scheduler[task_immobilienimportis24_reportversandan]';
//        $fieldId = 'task_immobilienimportis24_reportversandan';
//        $fieldHtml = '<textarea rows="4" cols="40" ' . 'name="' . $fieldName . '" ' . 'id="' . $fieldId . '">'.$taskInfo['task_immobilienimportis24_reportversandan'].'</textarea>';
//        $fieldConfiguration = array(
//            'code' => $fieldHtml,
//            'label' => 'Versand des Reports (Eine E-Mail-Adresse pro Zeile)',
//            'cshKey' => '_MOD_system_txschedulerM1',
//            'cshLabel' => $fieldId
//        );
//        return $fieldConfiguration;
//    }

//    protected function getAlertVersandAnAdditionalField(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
//        /**
//         * @var $task \DAHO\T3ImmobilienImportIs24\Tasks\Immobilienimport
//         */
//
//        if (empty($taskInfo['task_immobilienimportis24_alertversandan'])) {
//            if ($schedulerModule->CMD === 'add') {
//                $taskInfo['task_immobilienimportis24_alertversandan'] = '';
//            } elseif ($schedulerModule->CMD === 'edit') {
//                $taskInfo['task_immobilienimportis24_alertversandan'] = implode(LF, $task->getAlertVersandAn());
//            }
//        }
//
//        $fieldName = 'tx_scheduler[task_immobilienimportis24_alertversandan]';
//        $fieldId = 'task_immobilienimportis24_alertversandan';
//        $fieldHtml = '<textarea rows="4" cols="40" ' . 'name="' . $fieldName . '" ' . 'id="' . $fieldId . '">'.$taskInfo['task_immobilienimportis24_alertversandan'].'</textarea>';
//        $fieldConfiguration = array(
//            'code' => $fieldHtml,
//            'label' => 'Versand von Warnungen (Eine E-Mail-Adresse pro Zeile)',
//            'cshKey' => '_MOD_system_txschedulerM1',
//            'cshLabel' => $fieldId
//        );
//        return $fieldConfiguration;
//    }

//    protected function getTypesForImport(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
//        /**
//         * @var $task \DAHO\T3ImmobilienImportIs24\Tasks\Immobilienimport
//         */
//
//        if (empty($taskInfo['task_immobilienimportis24_typesforimport'])) {
//            if ($schedulerModule->CMD === 'add') {
//                $taskInfo['task_immobilienimportis24_typesforimport'] = null;
//            } elseif ($schedulerModule->CMD === 'edit') {
//                $taskInfo['task_immobilienimportis24_typesforimport'] = $task->getTypesForImport();
//            }
//        }
//
//        $fieldName = 'tx_scheduler[task_immobilienimportis24_typesforimport][]';
//        $fieldId = 'task_immobilienimportis24_typesforimport';
//
//        $allTypesForImport = array(
//            'offerlistelement:OfferApartmentRent'           => 'Wohnung Miete',
//            'offerlistelement:OfferHouseRent'               => 'Haus Miete',
//            'offerlistelement:OfferApartmentBuy'            => 'Wohnung Kauf',
//            'offerlistelement:OfferHouseBuy'                => 'Haus Kauf',
//            'offerlistelement:OfferShortTermAccommodation'  => 'Wohnen auf Zeit',
//            'offerlistelement:OfferGarageBuy'               => 'Garage Kauf',
//            'offerlistelement:OfferGarageRent'              => 'Garage Miete',
//            'offerlistelement:OfferOffice'                  => 'Büro',
//            'offerlistelement:OfferStore'                   => 'Geschäft',
//            'offerlistelement:OfferGastronomy'              => 'Gastronomie',
//            'offerlistelement:OfferIndustry'                => 'Industrie',
//            'offerlistelement:OfferInvestment'              => 'Investment',
//            'offerlistelement:OfferLivingBuySite'           => 'LivingBuySite',
//            'offerlistelement:OfferLivingRentSite'          => 'LivingRentSite',
//            'offerlistelement:OfferTradeSite'               => 'TradeSite',
//            'offerlistelement:OfferSpecialPurpose'          => 'SpecialPurpose',
//            'offerlistelement:OfferHouseType'               => 'OfferHouseType',
//            'offerlistelement:OfferFlatShareRoom'           => 'FlatShareRoom',
//            'offerlistelement:OfferAssistedLiving'          => 'AssistedLiving',
//            'offerlistelement:OfferSeniorCare'              => 'SeniorCar',
//            'offerlistelement:OfferCompulsoryAuction'       => 'Zwangsversteigerung',
//        );
//
//        $fieldHtml = '<select name="'.$fieldName.'" id="'.$fieldId.'" multiple="multiple" size="10">';
//        foreach($allTypesForImport as $key => $value){
//            $selected = '';
//            if ((is_array($taskInfo['task_immobilienimportis24_typesforimport']))&&(in_array($key, $taskInfo['task_immobilienimportis24_typesforimport']))){
//                $selected = 'selected="selected"';
//            }
//            $fieldHtml .= '<option value="'.$key.'" '.$selected.'>'.$value.'</option>';
//        }
//        $fieldHtml .= '</select>';
//
//
//        $fieldConfiguration = array(
//            'code' => $fieldHtml,
//            'label' => 'Zu importierende Immobilientypen',
//            'cshKey' => '_MOD_system_txschedulerM1',
//            'cshLabel' => $fieldId
//        );
//        return $fieldConfiguration;
//    }

//    protected function getImageWidth(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
//        /**
//         * @var $task \DAHO\T3ImmobilienImportIs24\Tasks\Immobilienimport
//         */
//
//        if (empty($taskInfo['task_immobilienimportis24_imagewidth'])) {
//            if ($schedulerModule->CMD === 'add') {
//                $taskInfo['task_immobilienimportis24_imagewidth'] = '1024';
//            } elseif ($schedulerModule->CMD === 'edit') {
//                $taskInfo['task_immobilienimportis24_imagewidth'] = $task->getImageWidth();
//            }
//        }
//
//        $fieldName = 'tx_scheduler[task_immobilienimportis24_imagewidth]';
//        $fieldId = 'task_immobilienimportis24_imagewidth';
//        $fieldHtml = '<input type="text" ' . 'name="' . $fieldName . '" ' . 'id="' . $fieldId . '" value="' . $taskInfo['task_immobilienimportis24_imagewidth'] . '" ' . ' />';
//        $fieldConfiguration = array(
//            'code' => $fieldHtml,
//            'label' => 'Breite der importierten Bilder',
//            'cshKey' => '_MOD_system_txschedulerM1',
//            'cshLabel' => $fieldId
//        );
//        return $fieldConfiguration;
//    }

//    protected function getImageHeight(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
//        /**
//         * @var $task \DAHO\T3ImmobilienImportIs24\Tasks\Immobilienimport
//         */
//
//        if (empty($taskInfo['task_immobilienimportis24_imageheight'])) {
//            if ($schedulerModule->CMD === 'add') {
//                $taskInfo['task_immobilienimportis24_imageheight'] = '768';
//            } elseif ($schedulerModule->CMD === 'edit') {
//                $taskInfo['task_immobilienimportis24_imageheight'] = $task->getImageHeight();
//            }
//        }
//
//        $fieldName = 'tx_scheduler[task_immobilienimportis24_imageheight]';
//        $fieldId = 'task_immobilienimportis24_imageheight';
//        $fieldHtml = '<input type="text" ' . 'name="' . $fieldName . '" ' . 'id="' . $fieldId . '" value="' . $taskInfo['task_immobilienimportis24_imageheight'] . '" ' . ' />';
//        $fieldConfiguration = array(
//            'code' => $fieldHtml,
//            'label' => 'Höhe der importierten Bilder',
//            'cshKey' => '_MOD_system_txschedulerM1',
//            'cshLabel' => $fieldId
//        );
//        return $fieldConfiguration;
//    }

//    protected function getUseliveAdditionalField(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
//        /**
//         * @var $task \DAHO\T3ImmobilienImportIs24\Tasks\Immobilienimport
//         */
//
//        if (empty($taskInfo['task_immobilienimportis24_uselive'])) {
//            if ($schedulerModule->CMD === 'add') {
//                $taskInfo['task_immobilienimportis24_uselive'] = 0;
//            } elseif ($schedulerModule->CMD === 'edit') {
//                $taskInfo['task_immobilienimportis24_uselive'] = $task->getUselive();
//            }
//        }
//
//        $fieldName = 'tx_scheduler[task_immobilienimportis24_uselive]';
//        $fieldId = 'task_immobilienimportis24_uselive';
//        if ($taskInfo['task_immobilienimportis24_uselive'] == 1){
//            $selected = 'checked="checked"';
//        }else{
//            $selected = '';
//        }
//
//        $fieldHtml = '<input type="checkbox" ' . 'name="' . $fieldName . '" ' . 'id="' . $fieldId . '" value="1" ' . $selected.' />';
//        $fieldConfiguration = array(
//            'code' => $fieldHtml,
//            'label' => 'Live-System verwenden',
//            'cshKey' => '_MOD_system_txschedulerM1',
//            'cshLabel' => $fieldId
//        );
//        return $fieldConfiguration;
//    }

//    protected function getPublishChannelField(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
//        /**
//         * @var $task \DAHO\T3ImmobilienImportIs24\Tasks\Immobilienimport
//         */
//
//        if (empty($taskInfo['task_immobilienimportis24_publishchannel'])) {
//            if ($schedulerModule->CMD === 'add') {
//                $taskInfo['task_immobilienimportis24_publishchannel'] = null;
//            } elseif ($schedulerModule->CMD === 'edit') {
//                $taskInfo['task_immobilienimportis24_publishchannel'] = $task->getPublishChannel();
//            }
//        }
//
//        $fieldName = 'tx_scheduler[task_immobilienimportis24_publishchannel]';
//        $fieldId = 'task_immobilienimportis24_publishchannel';
//
//        $allPublishChannels = array(
//            'Homepage'          => 'Anbieterseite bei IS24',
//            'IS24'              => 'Immobilienscout 24',
//        );
//
//        $fieldHtml = '<select name="'.$fieldName.'" id="'.$fieldId.'">';
//        foreach($allPublishChannels as $key => $value){
//            $selected = '';
//            if ($taskInfo['task_immobilienimportis24_publishchannel'] == $key){
//                $selected = 'selected="selected"';
//            }
//            $fieldHtml .= '<option value="'.$key.'" '.$selected.'>'.$value.'</option>';
//        }
//        $fieldHtml .= '</select>';
//
//
//        $fieldConfiguration = array(
//            'code' => $fieldHtml,
//            'label' => 'Channel der importiert werden soll',
//            'cshKey' => '_MOD_system_txschedulerM1',
//            'cshLabel' => $fieldId
//        );
//        return $fieldConfiguration;
//    }

    public function validateStoragePidAdditionalField(array &$submittedData, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule) {
        $validData = FALSE;
        if (!isset($submittedData['task_sgestateimportcsv_storagepid'])) {
            $validData = TRUE;
        } elseif ((int)$submittedData['task_sgestateimportcsv_storagepid'] >= 0) {
            $validData = TRUE;
        } else {
            $schedulerModule->addMessage('Bitte eine gültige PID eingeben!', \TYPO3\CMS\Core\Messaging\FlashMessage::ERROR);
        }
        return $validData;
    }

    public function validateConfigPfadAdditionalField(array &$submittedData, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
        $validData = FALSE;
        if (isset($submittedData['task_sgestateimportcsv_configpfad'])) {
            $validData = TRUE;
        } else {
            $schedulerModule->addMessage('Bitte einen gültigen Pfad eingeben!', \TYPO3\CMS\Core\Messaging\FlashMessage::ERROR);
        }
        return $validData;
    }

//    public function validateReportVersandAnAdditionalField(array &$submittedData, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
//        $validData = FALSE;
//        $tempData = \TYPO3\CMS\Core\Utility\GeneralUtility::trimExplode(LF, $submittedData['task_immobilienimportis24_reportversandan'], TRUE);
//        if (is_array($tempData)){
//            $invalidAdressFound = FALSE;
//            foreach($tempData as $email){
//                if (!\TYPO3\CMS\Core\Utility\GeneralUtility::validEmail($email)){
//                    $invalidAdressFound = TRUE;
//                }
//            }
//            if ($invalidAdressFound){
//                $schedulerModule->addMessage('Bitte nur gültige E-Mail Adressen eingeben!', \TYPO3\CMS\Core\Messaging\FlashMessage::ERROR);
//            }else{
//                $validData = TRUE;
//            }
//
//        }else{
//            $schedulerModule->addMessage('Bitte mindestens eine E-Mail Adresse für den Reportversand angeben!', \TYPO3\CMS\Core\Messaging\FlashMessage::ERROR);
//        }
//
//        return $validData;
//    }

//    public function validateAlertVersandAnAdditionalField(array &$submittedData, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
//        $validData = FALSE;
//        $tempData = \TYPO3\CMS\Core\Utility\GeneralUtility::trimExplode(LF, $submittedData['task_immobilienimportis24_alertversandan'], TRUE);
//        if (is_array($tempData)){
//            $invalidAdressFound = FALSE;
//            foreach($tempData as $email){
//                if (!\TYPO3\CMS\Core\Utility\GeneralUtility::validEmail($email)){
//                    $invalidAdressFound = TRUE;
//                }
//            }
//            if ($invalidAdressFound){
//                $schedulerModule->addMessage('Bitte nur gültige E-Mail Adressen eingeben!', \TYPO3\CMS\Core\Messaging\FlashMessage::ERROR);
//            }else{
//                $validData = TRUE;
//            }
//
//        }else{
//            $schedulerModule->addMessage('Bitte mindestens eine E-Mail Adresse für den Warnungsversand angeben!', \TYPO3\CMS\Core\Messaging\FlashMessage::ERROR);
//        }
//
//        return $validData;
//    }

//    public function validateTypesForImport(array &$submittedData, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
//        $validData = FALSE;
//        if (is_array($submittedData['task_immobilienimportis24_typesforimport'])&&(count($submittedData['task_immobilienimportis24_typesforimport'] > 0))) {
//            $validData = TRUE;
//        } else {
//            $schedulerModule->addMessage('Bitte mindestens einen Importtyp auswählen!', \TYPO3\CMS\Core\Messaging\FlashMessage::ERROR);
//        }
//
//        return $validData;
//    }

//    public function validateImageWidth(array &$submittedData, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
//        $validData = FALSE;
//        if (isset($submittedData['task_immobilienimportis24_imagewidth'])) {
//            $validData = TRUE;
//        } else {
//            $schedulerModule->addMessage('Bitte eine gültige Breite eingeben!', \TYPO3\CMS\Core\Messaging\FlashMessage::ERROR);
//        }
//        return $validData;
//    }

//    public function validateImageHeight(array &$submittedData, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
//        $validData = FALSE;
//        if (isset($submittedData['task_immobilienimportis24_imagewidth'])) {
//            $validData = TRUE;
//        } else {
//            $schedulerModule->addMessage('Bitte eine gültige Breite eingeben!', \TYPO3\CMS\Core\Messaging\FlashMessage::ERROR);
//        }
//        return $validData;
//    }

//    public function validatePublishChannel(array &$submittedData, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
//        $validData = FALSE;
//        if ($submittedData['task_immobilienimportis24_publishchannel'] != '') {
//            $validData = TRUE;
//        } else {
//            $schedulerModule->addMessage('Bitte einen Channel auswählen!', \TYPO3\CMS\Core\Messaging\FlashMessage::ERROR);
//        }
//
//        return $validData;
//    }
  protected function validateDaysToKeepArchiveFiles(array &$submittedData, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
    $validData = false;
    if (is_numeric($submittedData['task_sgestateimportcsv_daystokeeparchivefiles'])){
      $validData = true;
    }else{
      $schedulerModule->addMessage('Bitte geben Sie eine Zahl ein!', \TYPO3\CMS\Core\Messaging\FlashMessage::ERROR);
    }
    return $validData;

  }

}