<?php
namespace SG\SgEstateImportCsv\Tasks;

class ImportAdditionalFieldProvider implements \TYPO3\CMS\Scheduler\AdditionalFieldProviderInterface {

    /**
     * Gets additional fields to render in the form to add/edit a task
     *
     * @param array $taskInfo Values of the fields from the add/edit task form
     * @param \TYPO3\CMS\Scheduler\Task\AbstractTask $task The task object being edited. Null when adding a task!
     * @param \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule Reference to the scheduler backend module
     * @return array A two dimensional array, array('Identifier' => array('fieldId' => array('code' => '', 'label' => '', 'cshKey' => '', 'cshLabel' => ''))
     */
    public function getAdditionalFields(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule)
    {
        $additionalFields['task_sgestateimportcsv_storagepid']       = $this->getStoragePidAdditionalField($taskInfo, $task, $schedulerModule);
        $additionalFields['task_sgestateimportcsv_debugmode']        = $this->getDebugModeAdditionalField($taskInfo, $task, $schedulerModule);
        $additionalFields['task_sgestateimportcsv_configpfad']         = $this->getConfigPfadAdditionalField($taskInfo, $task, $schedulerModule);
        $additionalFields['task_sgestateimportcsv_daystokeeparchivefiles'] = $this->getDaysToKeepArchiveFilesField($taskInfo, $task, $schedulerModule);

        return $additionalFields;
    }

    public function validateAdditionalFields(array &$submittedData, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule)
    {
        $validData = $this->validateStoragePidAdditionalField($submittedData, $schedulerModule);
        $validData &= $this->validateConfigPfadAdditionalField($submittedData, $schedulerModule);
        $validData &=   $this->validateDaysToKeepArchiveFiles($submittedData, $schedulerModule);

        return $validData;
    }

    public function saveAdditionalFields(array $submittedData, \TYPO3\CMS\Scheduler\Task\AbstractTask $task)
    {
        /**
         * @var $task \SG\SgEstateImportCsv\Tasks\Import
         */

        $task->setStoragePid((int)$submittedData['task_sgestateimportcsv_storagepid']);
        $task->setDebugMode($submittedData['task_sgestateimportcsv_debugmode']);
        $task->setConfigPfad($submittedData['task_sgestateimportcsv_configpfad']);
        $task->setDaysToKeepArchiveFiles($submittedData['task_sgestateimportcsv_daystokeeparchivefiles']);
    }



    protected function getStoragePidAdditionalField(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule) {
        /**
         * @var $task \SG\SgEstateImportCsv\Tasks\Import
         */

        if (empty($taskInfo['task_sgestateimportcsv_storagepid'])) {
            if ($schedulerModule->CMD === 'add') {
                $taskInfo['task_sgestateimportcsv_storagepid'] = 0;
            } elseif ($schedulerModule->CMD === 'edit') {
                $taskInfo['task_sgestateimportcsv_storagepid'] = $task->getStoragePid();
            }
        }

        $fieldName = 'tx_scheduler[task_sgestateimportcsv_storagepid]';
        $fieldId = 'task_sgestateimportcsv_storagepid';
        $fieldHtml = '<input type="text" ' . 'name="' . $fieldName . '" ' . 'id="' . $fieldId . '" value="' . (int)$taskInfo['task_sgestateimportcsv_storagepid'] . '" ' . 'size="4" />';
        $fieldConfiguration = array(
            'code' => $fieldHtml,
            'label' => 'PID des Immobilienspeichers',
            'cshKey' => '_MOD_system_txschedulerM1',
            'cshLabel' => $fieldId
        );
        return $fieldConfiguration;
    }

    protected function getDebugModeAdditionalField(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
        /**
         * @var $task \SG\SgEstateImportCsv\Tasks\Import
         */

        if (empty($taskInfo['task_sgestateimportcsv_debugmode'])) {
            if ($schedulerModule->CMD === 'add') {
                $taskInfo['task_sgestateimportcsv_debugmode'] = 0;
            } elseif ($schedulerModule->CMD === 'edit') {
                $taskInfo['task_sgestateimportcsv_debugmode'] = $task->isDebugMode();
            }
        }

        $fieldName = 'tx_scheduler[task_sgestateimportcsv_debugmode]';
        $fieldId = 'task_sgestateimportcsv_debugmode';
        if ($taskInfo['task_sgestateimportcsv_debugmode'] == 1){
            $selected = 'checked="checked"';
        }else{
            $selected = '';
        }

        $fieldHtml = '<input type="checkbox" ' . 'name="' . $fieldName . '" ' . 'id="' . $fieldId . '" value="1" ' . $selected.' />';
        $fieldConfiguration = array(
            'code' => $fieldHtml,
            'label' => 'Debug-Mode aktivieren',
            'cshKey' => '_MOD_system_txschedulerM1',
            'cshLabel' => $fieldId
        );
        return $fieldConfiguration;
    }


    protected function getConfigPfadAdditionalField(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
        /**
         * @var $task \SG\SgEstateImportCsv\Tasks\Import
         */

        if (empty($taskInfo['task_sgestateimportcsv_configpfad'])) {
            if ($schedulerModule->CMD === 'add') {
                $taskInfo['task_sgestateimportcsv_configpfad'] = '';
            } elseif ($schedulerModule->CMD === 'edit') {
                $taskInfo['task_sgestateimportcsv_configpfad'] = $task->getConfigPfad();
            }
        }

        $fieldName = 'tx_scheduler[task_sgestateimportcsv_configpfad]';
        $fieldId = 'task_sgestateimportcsv_configpfad';
        $fieldHtml = '<input type="text" ' . 'name="' . $fieldName . '" ' . 'id="' . $fieldId . '" value="' . $taskInfo['task_sgestateimportcsv_configpfad'] . '" ' . ' />';
        $fieldConfiguration = array(
            'code' => $fieldHtml,
            'label' => 'Pfad zu den Konfigurationsdateien',
            'cshKey' => '_MOD_system_txschedulerM1',
            'cshLabel' => $fieldId
        );
        return $fieldConfiguration;
    }

  protected function getDaysToKeepArchiveFilesField(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
    /**
     * @var $task \SG\SgEstateImportCsv\Tasks\Import
     */

    if (empty($taskInfo['task_sgestateimportcsv_daystokeeparchivefiles'])) {
      if ($schedulerModule->CMD === 'add') {
        $taskInfo['task_sgestateimportcsv_daystokeeparchivefiles'] = '7';
      } elseif ($schedulerModule->CMD === 'edit') {
        $taskInfo['task_sgestateimportcsv_daystokeeparchivefiles'] = $task->getDaysToKeepArchiveFiles();
      }
    }

    $fieldName = 'tx_scheduler[task_sgestateimportcsv_daystokeeparchivefiles]';
    $fieldId = 'task_sgestateimportcsv_daystokeeparchivefiles';
    $fieldHtml = '<input type="text" ' . 'name="' . $fieldName . '" ' . 'id="' . $fieldId . '" value="' . $taskInfo['task_sgestateimportcsv_daystokeeparchivefiles'] . '" ' . 'size="5" />';
    $fieldConfiguration = array(
      'code' => $fieldHtml,
      'label' => 'Wieviel Tage sollen die Exporte archiviert werden?',
      'cshKey' => '_MOD_system_txschedulerM1',
      'cshLabel' => $fieldId
    );
    return $fieldConfiguration;
  }

    public function validateStoragePidAdditionalField(array &$submittedData, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule) {
        $validData = FALSE;
        if (!isset($submittedData['task_sgestateimportcsv_storagepid'])) {
            $validData = TRUE;
        } elseif ((int)$submittedData['task_sgestateimportcsv_storagepid'] >= 0) {
            $validData = TRUE;
        } else {
            $schedulerModule->addMessage('Bitte eine gültige PID eingeben!', \TYPO3\CMS\Core\Messaging\FlashMessage::ERROR);
        }
        return $validData;
    }

    public function validateConfigPfadAdditionalField(array &$submittedData, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
        $validData = FALSE;
        if (isset($submittedData['task_sgestateimportcsv_configpfad'])) {
            $validData = TRUE;
        } else {
            $schedulerModule->addMessage('Bitte einen gültigen Pfad eingeben!', \TYPO3\CMS\Core\Messaging\FlashMessage::ERROR);
        }
        return $validData;
    }

  protected function validateDaysToKeepArchiveFiles(array &$submittedData, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
    $validData = false;
    if (is_numeric($submittedData['task_sgestateimportcsv_daystokeeparchivefiles'])){
      $validData = true;
    }else{
      $schedulerModule->addMessage('Bitte geben Sie eine Zahl ein!', \TYPO3\CMS\Core\Messaging\FlashMessage::ERROR);
    }
    return $validData;

  }

}