<?php
namespace Daho\SgEstateImportCsv\Tasks;

class Import extends \TYPO3\CMS\Scheduler\Task\AbstractTask{

  /**
   * An email address to be used during the process
   *
   * @var integer $storagePid
   */
  protected $storagePid;

  /**
   * @var bool
   */
  protected $debugMode = false;


  /**
   * @var array
   */
  private $reportDaten = array();

  /**
   * @var array
   */
  private $fehlerBeiAusfuehrung = array();

  /**
   * Extension Configuration
   *
   * @var array
   */
  private $extConf = array();

  /**
   * Array zur Speicherung von Warnungen während der Ausführung um diese nachher gesammelt zu Versenden
   *
   * Aufbau
   * [] = array(
   *      'titel' => '',
   *      'text'  => '',
   * )
   *
   * @var array
   */
  private $warnungen = array();

  /**
   * @var \TYPO3\CMS\Extbase\Object\ObjectManager
   */
  private $objectManager;

  /**
   * @var $sgEstateCoreServices \Daho\SgEstateCore\Util\Services
   */
  private $sgEstateCoreServices;

  /**
   * @var string $uploadPfad
   */
  protected $uploadPfad = '';

  /**
   * @var string
   */
  protected $tempPfad = '';

  /**
   * @var string
   */
  protected $filenameDatafile = '';

  /**
   * @var string
   */
  protected $archivPfad = '';

  /**
   * @var string
   */
  protected $mediaPfad = '';

  /**
   * @var string
   */
  protected $configPfad = '';

  /**
   * @var int
   */
  protected $daysToKeepArchiveFiles = 7;

  /**
   * @var \TYPO3\CMS\Core\Database\DatabaseConnection
   */
  protected $database;

  public function execute()
  {

    $this->reportDaten['importStart'] = date('d.m.Y H:i:s');
    $this->initialize();

    if ($this->preprocess()){
      $this->import();
    }

    $this->postprocess();

    $this->reportDaten['importEnde'] = date('d.m.Y H:i:s');
    if (count($this->fehlerBeiAusfuehrung) > 0){
      throw new \RuntimeException(implode(', ', $this->fehlerBeiAusfuehrung), 4711);
    }else{
      return true;
    }
  }

  /**
   * Initializes All needed Variables
   */
  private function initialize(){
    if (!$this->systemcheck()){
      array_push($this->fehlerBeiAusfuehrung,'System-Check fehlgeschlagen');
      throw new \RuntimeException(implode(', ', $this->fehlerBeiAusfuehrung), 4711);
    }
    $this->database = $GLOBALS['TYPO3_DB'];
    $this->fehlerBeiAusfuehrung = array();
    $this->extConf = unserialize($GLOBALS['TYPO3_CONF_VARS']['EXT']['extConf']['sg_estate_import_csv']);

    $this->objectManager = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\CMS\Extbase\Object\ObjectManager');
    $this->sgEstateCoreServices = $this->objectManager->get('Daho\SgEstateCore\Util\Services');

    $this->tempPfad = PATH_site . 'uploads/tx_sgestateimportcsv/temp/';
    $this->archivPfad = PATH_site . 'uploads/tx_sgestateimportcsv/archiv/';
    $this->uploadPfad = PATH_site . 'uploads/tx_sgestateimportcsv/upload/';

    $this->mediaPfad = PATH_site . 'uploads/tx_sgestatecore/media/';
  }

  /**
   * Cleans up Archive Files
   */
  private function cleanUpArchiveFiles()
  {
    $handle = opendir($this->archivPfad);
    $now = time();
    $secondsToKeepArchiveFiles = $this->getDaysToKeepArchiveFiles()*24*60*60;
    $borderTimestamp = $now - $secondsToKeepArchiveFiles;

    while ($file = readdir($handle)) {
      $filetime= filemtime($this->archivPfad . $file);
      if ($file != '..' && $file != '.' && $filetime < $borderTimestamp){
        @unlink($this->archivPfad . $file);
      }
    }
    closedir($handle);
  }

  /**
   * Unzips the archive and archives the Upload-File
   *
   * @return bool
   */
  private function preprocess(){
    $handle = opendir($this->uploadPfad);
    while ($datei = readdir ($handle)) {
      $temp = pathinfo($this->uploadPfad.$datei);

      if (strtolower($temp['extension']) == 'zip'){
        if ($this->unzip($this->uploadPfad.$datei, $this->tempPfad)){
          if ($this->isDebugMode()){
            copy($this->uploadPfad.$datei, $this->archivPfad.'data-'.date('Y_m_d').'-'.uniqid().'.zip');
          }else{
            rename($this->uploadPfad.$datei, $this->archivPfad.'data-'.date('Y_m_d').'-'.uniqid().'.zip');
          }

          $tempDirHandle = opendir($this->tempPfad);
          while ($dataFile = readdir($tempDirHandle)){
            $dataFileInfo = pathinfo($this->tempPfad.$dataFile);
            if (strtolower($dataFileInfo['extension']) == 'csv'){
              $this->filenameDatafile = $dataFile;
              closedir($tempDirHandle);
              closedir($handle);
              return true;
            }
          }
        }else{
          $this->addWarnung('Fehler','Datei konnte nicht entpackt werden');
        }
        break;
      }
    }
    closedir($handle);
    return false;
  }

  private function postprocess(){
    //@todo: Reportversand


    $directoryContent = scandir($this->tempPfad);
    foreach ($directoryContent as $entry) {
      if (!is_dir($entry)){
        @unlink($this->tempPfad.$entry);
      }
    }

    $this->cleanUpArchiveFiles();
  }

  /**
   * Does the Import
   */
  private function import(){
    $this->sgEstateCoreServices->deleteAllUpdatableRealties($this->taskUid);
    $fileHandle = fopen($this->tempPfad.$this->filenameDatafile,'r');
    while (($data = fgetcsv($fileHandle, 0, "|")) !== FALSE) {
      if ($data[$this->getCol('kindOfObject')] == 0){ //@todo: Derzeit werden nur Wohnungen importiert
        // UID der Stadt suchen, wenn nicht vorhanden anlegen
        $cityName = utf8_encode($data[$this->getCol('city',$data[$this->getCol('kindOfObject')])]);
        $cityUid = $this->addCity($cityName);

        // UID des Stadtteils suchen, wenn nicht vorhanden anlegen
        if (($this->getCol('district',$data[$this->getCol('kindOfObject')]) != null)&&($data[$this->getCol('district',$data[$this->getCol('kindOfObject')])]) != ''){
          $districtName = utf8_encode($data[$this->getCol('district',$data[$this->getCol('kindOfObject')])]);
          $districtUid = $this->addDistrict($districtName, $cityUid);
        }else{
          $districtUid = null;
        }

        // BEGIN: Immobilie importieren
        $realtyData = array(
          'pid' => $this->storagePid,
          'updatable' => 1,
          'import_number' => $this->taskUid
        );
        $kindOfUseStorage = NULL;
        $marketingMethodStorage = NULL;

        if ($this->getCol('objectNumberInternal',$data[$this->getCol('kindOfObject')]) != null){
          $realtyData['objektnr_intern'] = $data[$this->getCol('objectNumberInternal',$data[$this->getCol('kindOfObject')])];
        }
        if ($this->getCol('objectNumberExternal',$data[$this->getCol('kindOfObject')]) != null){
          $realtyData['objektnr_extern'] = $data[$this->getCol('objectNumberExternal',$data[$this->getCol('kindOfObject')])];
        }
        if ($this->getCol('openimmoObjectId',$data[$this->getCol('kindOfObject')]) != null){
          $realtyData['openimmo_objid'] = $data[$this->getCol('openimmoObjectId',$data[$this->getCol('kindOfObject')])];
        }
        if ($this->getCol('updated',$data[$this->getCol('kindOfObject')]) != null){
          $realtyData['stand_vom'] = date_format(date_create($data[$this->getCol('updated',$data[$this->getCol('kindOfObject')])]),'U');
        }
        if ($this->getCol('zip',$data[$this->getCol('kindOfObject')]) != null){
          $realtyData['objekt_plz'] = $data[$this->getCol('zip',$data[$this->getCol('kindOfObject')])];
        }
        if ($this->getCol('street',$data[$this->getCol('kindOfObject')]) != null){
          $realtyData['objekt_strasse'] = utf8_encode($data[$this->getCol('street',$data[$this->getCol('kindOfObject')])]);
        }
        if ($this->getCol('housenumber',$data[$this->getCol('kindOfObject')]) != null){
          $realtyData['objekt_hausnummer'] = utf8_encode($data[$this->getCol('housenumber',$data[$this->getCol('kindOfObject')])]);
        }
        if ($this->getCol('floor',$data[$this->getCol('kindOfObject')]) != null){
          $realtyData['objekt_etage'] = $data[$this->getCol('floor',$data[$this->getCol('kindOfObject')])] != '' ? $data[$this->getCol('floor',$data[$this->getCol('kindOfObject')])] : 0;
        }
        if ($this->getCol('floorCount',$data[$this->getCol('kindOfObject')]) != null){
          $realtyData['objekt_anzahl_etagen'] = $data[$this->getCol('floorCount',$data[$this->getCol('kindOfObject')])] != '' ? $data[$this->getCol('floorCount',$data[$this->getCol('kindOfObject')])] : 0;
        }
        // @todo: Land utf8_encode($item[$this->getCol('country',$item[$this->getCol('kindOfObject')])])
        if ($this->getCol('netRentExclusiveOfHeating',$data[$this->getCol('kindOfObject')]) != null){
          $realtyData['kaltmiete'] = $data[$this->getCol('netRentExclusiveOfHeating',$data[$this->getCol('kindOfObject')])] != '' ? str_replace(',','.',$data[$this->getCol('netRentExclusiveOfHeating',$data[$this->getCol('kindOfObject')])]) : 0;
        }
        if ($this->getCol('additionalExpenses',$data[$this->getCol('kindOfObject')]) != null){
          $realtyData['nebenkosten'] = $data[$this->getCol('additionalExpenses',$data[$this->getCol('kindOfObject')])] != '' ? str_replace(',','.',$data[$this->getCol('additionalExpenses',$data[$this->getCol('kindOfObject')])]) : 0;
        }
        if ($this->getCol('deposit',$data[$this->getCol('kindOfObject')]) != null){
          $realtyData['kaution'] = $data[$this->getCol('deposit',$data[$this->getCol('kindOfObject')])] != '' ? str_replace(',','.',$data[$this->getCol('deposit',$data[$this->getCol('kindOfObject')])]) : 0;
        }
        if ($this->getCol('brokerage',$data[$this->getCol('kindOfObject')]) != null){
          $realtyData['provisionspflichtig'] = $this->getBoolWert($data[$this->getCol('brokerage',$data[$this->getCol('kindOfObject')])]);
        }
        if ($this->getCol('brokerageValue',$data[$this->getCol('kindOfObject')]) != null){
          $realtyData['courtage_hinweis'] = utf8_encode($data[$this->getCol('brokerageValue',$data[$this->getCol('kindOfObject')])]);
        }
        if ($this->getCol('heatingCosts',$data[$this->getCol('kindOfObject')]) != null){
          $realtyData['heizkosten'] = $data[$this->getCol('heatingCosts',$data[$this->getCol('kindOfObject')])] != '' ? str_replace(',','.',$data[$this->getCol('heatingCosts',$data[$this->getCol('kindOfObject')])]) : 0;
        }
        if ($this->getCol('rentIncludesHeatingCosts',$data[$this->getCol('kindOfObject')]) != null){
          $realtyData['heizkosten_enthalten'] = $this->getBoolWert($data[$this->getCol('rentIncludesHeatingCosts',$data[$this->getCol('kindOfObject')])]);
        }
        if ($this->getCol('livingSpace',$data[$this->getCol('kindOfObject')]) != null){
          $realtyData['wohnflaeche'] = $data[$this->getCol('livingSpace',$data[$this->getCol('kindOfObject')])] != '' ? str_replace(',','.',$data[$this->getCol('livingSpace',$data[$this->getCol('kindOfObject')])]) : 0;
        }
        if ($this->getCol('basementSpace',$data[$this->getCol('kindOfObject')]) != null){
          $realtyData['kellerflaeche'] = $data[$this->getCol('basementSpace',$data[$this->getCol('kindOfObject')])] != '' ? str_replace(',','.',$data[$this->getCol('basementSpace',$data[$this->getCol('kindOfObject')])]) : 0;
        }
        if ($this->getCol('effectiveSurface',$data[$this->getCol('kindOfObject')]) != null){
          $realtyData['nutzflaeche'] = $data[$this->getCol('effectiveSurface',$data[$this->getCol('kindOfObject')])] != '' ? str_replace(',','.',$data[$this->getCol('effectiveSurface',$data[$this->getCol('kindOfObject')])]) : 0;
        }
        if ($this->getCol('totalArea',$data[$this->getCol('kindOfObject')]) != null){
          $realtyData['gesamtflaeche'] = $data[$this->getCol('totalArea',$data[$this->getCol('kindOfObject')])] != '' ? str_replace(',','.',$data[$this->getCol('totalArea',$data[$this->getCol('kindOfObject')])]) : 0;
        }
        if ($this->getCol('roomCount',$data[$this->getCol('kindOfObject')]) != null){
          $realtyData['anzahl_zimmer'] = $data[$this->getCol('roomCount',$data[$this->getCol('kindOfObject')])] != '' ? str_replace(',','.',$data[$this->getCol('roomCount',$data[$this->getCol('kindOfObject')])]) : 0;
        }
        if ($this->getCol('balconyCount',$data[$this->getCol('kindOfObject')]) != null){
          $realtyData['anzahl_balkone'] = $data[$this->getCol('balconyCount',$data[$this->getCol('kindOfObject')])] != '' ? str_replace(',','.',$data[$this->getCol('balconyCount',$data[$this->getCol('kindOfObject')])]) : 0;
        }
        if ($this->getCol('yearOfConstruction',$data[$this->getCol('kindOfObject')]) != null){
          $realtyData['baujahr'] = $data[$this->getCol('yearOfConstruction',$data[$this->getCol('kindOfObject')])];
        }
        if ($this->getCol('title',$data[$this->getCol('kindOfObject')]) != null){
          $realtyData['objekttitel'] = utf8_encode($data[$this->getCol('title',$data[$this->getCol('kindOfObject')])]);
        }
        if ($this->getCol('siteDescription',$data[$this->getCol('kindOfObject')]) != null){
          $realtyData['lage'] = utf8_encode($data[$this->getCol('siteDescription',$data[$this->getCol('kindOfObject')])]);
        }
        if ($this->getCol('description',$data[$this->getCol('kindOfObject')]) != null){
          $realtyData['objektbeschreibung'] = utf8_encode($data[$this->getCol('description',$data[$this->getCol('kindOfObject')])]);
        }
        if ($this->getCol('equipmentDescription',$data[$this->getCol('kindOfObject')]) != null){
          $realtyData['austattungsbeschreibung'] = utf8_encode($data[$this->getCol('equipmentDescription',$data[$this->getCol('kindOfObject')])]);
        }
        if ($this->getCol('additionalDescription',$data[$this->getCol('kindOfObject')]) != null){
          $realtyData['sonstige_angaben'] = utf8_encode($data[$this->getCol('additionalDescription',$data[$this->getCol('kindOfObject')])]);
        }
        if ($this->getCol('showGeo',$data[$this->getCol('kindOfObject')]) != null){
          $realtyData['objektadresse_freigeben'] = $this->getBoolWert($data[$this->getCol('showGeo',$data[$this->getCol('kindOfObject')])]);
        }
        if ($this->getCol('availableFrom',$data[$this->getCol('kindOfObject')]) != null){
          $realtyData['verfuegbar_ab'] = utf8_encode($data[$this->getCol('availableFrom',$data[$this->getCol('kindOfObject')])]);
        }
        if ($this->getCol('wohnberechtigungsschein',$data[$this->getCol('kindOfObject')]) != null){
          $realtyData['wbs_erforderlich'] = $this->getBoolWert($data[$this->getCol('wohnberechtigungsschein',$data[$this->getCol('kindOfObject')])]);
        }
        if ($this->getCol('petAllowed',$data[$this->getCol('kindOfObject')]) != null){
          $realtyData['haustiere'] = $this->getBoolWert($data[$this->getCol('petAllowed',$data[$this->getCol('kindOfObject')])]);
        }
        if ($this->getCol('separateToilet',$data[$this->getCol('kindOfObject')]) != null){
          $realtyData['gaestewc'] = $this->getBoolWert($data[$this->getCol('separateToilet',$data[$this->getCol('kindOfObject')])]);
        }
        if ($this->getCol('lift',$data[$this->getCol('kindOfObject')]) != null){
          $realtyData['aufzug_personen'] = $this->getBoolWert($data[$this->getCol('lift',$data[$this->getCol('kindOfObject')])]);
        }
        if ($this->getCol('goodsLift',$data[$this->getCol('kindOfObject')]) != null){
          $realtyData['aufzug_lasten'] = $this->getBoolWert($data[$this->getCol('goodsLift',$data[$this->getCol('kindOfObject')])]);
        }
        if ($this->getCol('accessibleForWheelchairs',$data[$this->getCol('kindOfObject')]) != null){
          $realtyData['rollstuhlgerecht'] = $this->getBoolWert($data[$this->getCol('accessibleForWheelchairs',$data[$this->getCol('kindOfObject')])]);
        }
        if ($this->getCol('barrierFree',$data[$this->getCol('kindOfObject')]) != null){
          $realtyData['barrierefrei'] = $this->getBoolWert($data[$this->getCol('barrierFree',$data[$this->getCol('kindOfObject')])]);
        }
        if ($this->getCol('gardenUse',$data[$this->getCol('kindOfObject')]) != null){
          $realtyData['gartennutzung'] = $this->getBoolWert($data[$this->getCol('setGardenUse',$data[$this->getCol('kindOfObject')])]);
        }
        if ($this->getCol('basementAvailable',$data[$this->getCol('kindOfObject')]) != null){
          $realtyData['unterkellert'] = $this->getBoolWert($data[$this->getCol('basementAvailable',$data[$this->getCol('kindOfObject')])]);
        }
        if ($this->getCol('fittedKitchen',$data[$this->getCol('kindOfObject')]) != null){
          //@todo: Einbaukueche $item[$this->getCol('fittedKitchen',$item[$this->getCol('kindOfObject')])]
        }
        if ($this->getCol('broadbandType',$data[$this->getCol('kindOfObject')]) != null){
          $realtyData['breitband_zugang_art'] = $data[$this->getCol('broadbandType',$data[$this->getCol('kindOfObject')])];
        }
        if ($this->getCol('broadbandSpeed',$data[$this->getCol('kindOfObject')]) != null){
          $realtyData['breitband_zugang_speed'] = floatval($data[$this->getCol('broadbandSpeed',$data[$this->getCol('kindOfObject')])]);
        }

        if ($cityUid != null){
          $realtyData['objekt_ort'] = $cityUid;
        }
        if ($districtUid != null){
          $realtyData['objekt_stadtteil'] = $districtUid;
        }


        $realtyData['kontaktperson'] = $this->addContact(
          null,
          utf8_encode($data[$this->getCol('contact_firstname',$data[$this->getCol('kindOfObject')])]),
          utf8_encode($data[$this->getCol('contact_lastname',$data[$this->getCol('kindOfObject')])]),
          utf8_encode($data[$this->getCol('contact_salutation',$data[$this->getCol('kindOfObject')])]),
          utf8_encode($data[$this->getCol('contact_company',$data[$this->getCol('kindOfObject')])]),
          utf8_encode($data[$this->getCol('contact_street',$data[$this->getCol('kindOfObject')])]),
          utf8_encode($data[$this->getCol('contact_housenumber',$data[$this->getCol('kindOfObject')])]),
          utf8_encode($data[$this->getCol('contact_zip',$data[$this->getCol('kindOfObject')])]),
          utf8_encode($data[$this->getCol('contact_city',$data[$this->getCol('kindOfObject')])]),
          utf8_encode($data[$this->getCol('contact_country',$data[$this->getCol('kindOfObject')])]),
          utf8_encode($data[$this->getCol('contact_telephone',$data[$this->getCol('kindOfObject')])]),
          utf8_encode($data[$this->getCol('contact_mobile',$data[$this->getCol('kindOfObject')])]),
          utf8_encode($data[$this->getCol('contact_email',$data[$this->getCol('kindOfObject')])]),
          utf8_encode($data[$this->getCol('contact_fax',$data[$this->getCol('kindOfObject')])]),
          utf8_encode($data[$this->getCol('contact_url',$data[$this->getCol('kindOfObject')])])
        );

        // Currency
        if ($this->getCol('currency',$data[$this->getCol('kindOfObject')]) != null){
          $rows = $this->database->exec_SELECTgetRows(
            'uid',
            'tx_sgestatecore_domain_model_waehrung',
            'iso_kennzeichen LIKE "'.$this->translateToken('currency', $data[$this->getCol('currency',$data[$this->getCol('kindOfObject')])]).'" AND deleted=0'
          );
          if (is_numeric($rows[0]['uid'])){
            $realtyData['waehrung'] = $rows[0]['uid'];
          }
        }else{
          $rows = $this->database->exec_SELECTgetRows(
            'uid',
            'tx_sgestatecore_domain_model_waehrung',
            'iso_kennzeichen LIKE "EUR" AND deleted=0'
          );
          if (is_numeric($rows[0]['uid'])){
            $realtyData['waehrung'] = $rows[0]['uid'];
          }
        }

        // Kind Of Object & Kind Of Objecttype
        if ($this->getCol('kindOfObject',$data[$this->getCol('kindOfObject')]) != null){
          $rows = $this->database->exec_SELECTgetRows(
            'uid',
            'tx_sgestatecore_domain_model_objektart',
            'kuerzel LIKE "'.$this->translateToken('kindOfObject', $data[$this->getCol('kindOfObject',$data[$this->getCol('kindOfObject')])]).'" AND deleted=0'
          );
          if (is_numeric($rows[0]['uid'])){
            $realtyData['objektart'] = $rows[0]['uid'];
          }
          $rows = $this->database->exec_SELECTgetRows(
            'uid',
            'tx_sgestatecore_domain_model_objektarttyp',
            'kuerzel LIKE "'.$this->translateToken('kindOfObjectType', $data[$this->getCol('kindOfObjectType',$data[$this->getCol('kindOfObject')])]).'" AND deleted=0'
          );
          if (is_numeric($rows[0]['uid'])){
            $realtyData['objektarttyp'] = $rows[0]['uid'];
          }

        }


        // M N Relations
        $mmData = array();
        //@todo: Marketings Methods

        // Heating Type
        if ($this->getCol('heatingType',$data[$this->getCol('kindOfObject')]) != null){
          $mmData['tx_sgestatecore_immobilie_heizungsart_mm'] = array($this->processHeizungsart($data[$this->getCol('heatingType',$data[$this->getCol('kindOfObject')])]));
        }

        // Beacoaning Type
        if ($this->getCol('beacoaningType',$data[$this->getCol('kindOfObject')]) != null){
          $mmData['tx_sgestatecore_immobilie_befeuerungsart_mm'] = array($this->processBefeuerungsart($data[$this->getCol('beacoaningType',$data[$this->getCol('kindOfObject')])]));
        }

        //@todo: Kind Of Use

        $this->database->exec_INSERTquery(
          'tx_sgestatecore_domain_model_immobilie',
          $realtyData
        );
        $uid = $this->database->sql_insert_id();

        // Save M To N Relation
        $this->processMMData($uid, $mmData);

        // Process Medias
        foreach ($this->getCol('media',$data[$this->getCol('kindOfObject')]) as $mediaCols) {
          if ($data[$mediaCols['name']-1] != ''){
            $insertArray = array();
            $insertArray['pid'] = $this->getStoragePid();
            $insertArray['immobilie'] = $uid;
            $insertArray['titel'] = utf8_encode($data[$mediaCols['description']-1]);
            $insertArray['format'] = strtoupper($data[$mediaCols['extension']-1]);
            $insertArray['typ'] = $this->processAnhangtyp($data[$mediaCols['type']-1]);
            $insertArray['datei'] = strtolower($data[$mediaCols['name']-1]);
            @rename($this->tempPfad.strtolower($data[$mediaCols['name']-1]),$this->mediaPfad.strtolower($data[$mediaCols['name']-1]));
            $this->database->exec_INSERTquery(
              'tx_sgestatecore_domain_model_anhang',
              $insertArray
            );
          }
        }

        // END: Immobilie importieren

      }
    }
  }

  private function processMMData($estateUid, $mmData){
    foreach($mmData as $tableName => $data){
      foreach ($data as $value){
        $this->database->exec_INSERTquery(
          $tableName,
          array(
            'uid_local' => $estateUid,
            'uid_foreign' => $value
          )
        );
      }
    }
  }

  private function processHeizungsart($value){
    $result = $this->database->exec_SELECTgetRows(
      'uid',
      'tx_sgestatecore_domain_model_heizungsart',
      'deleted = 0 AND sys_language_uid = 0 AND kuerzel LIKE "'.$this->translateToken('heatingType',$value).'"'
    );
    if (count($result) == 1){
      return $result[0]['uid'];
    }else{
      return null;
    }
  }

  private function processAnhangtyp($value){
    $token = $this->translateToken('mediaType',$value);
    if ($token == ''){
      $token = 'DOKUMENTE';
    }
    $result = $this->database->exec_SELECTgetRows(
      'uid',
      'tx_sgestatecore_domain_model_anhangtyp',
      'deleted = 0 AND sys_language_uid = 0 AND kuerzel LIKE "'.$token.'"'
    );
    if (count($result) == 1){
      return $result[0]['uid'];
    }else{
      return null;
    }
  }

  private function processBefeuerungsart($value){
    $result = $this->database->exec_SELECTgetRows(
      'uid',
      'tx_sgestatecore_domain_model_befeuerungsart',
      'deleted = 0 AND sys_language_uid = 0 AND kuerzel LIKE "'.$this->translateToken('beacoaningType',$value).'"'
    );
    if (count($result) == 1){
      return $result[0]['uid'];
    }else{
      return null;
    }
  }

  /**
   * @param null $identifier
   * @param string $firstname
   * @param string $lastname
   * @param string $salutation
   * @param string $company
   * @param string $street
   * @param string $housenumber
   * @param string $zip
   * @param string $city
   * @param string $country
   * @param string $telephone
   * @param string $mobile
   * @param string $email
   * @param string $fax
   * @param string $url
   * @return int
   */
  private function addContact($identifier = null,$firstname = '', $lastname = '', $salutation = '', $company = '', $street = '', $housenumber = '', $zip = '', $city = '', $country = '', $telephone = '', $mobile = '', $email = '', $fax = '', $url = ''){
    $data = array(
      'pid' => $this->storagePid
    );
    if ($firstname != ''){$data['vorname'] = $firstname;}
    if ($lastname != ''){$data['name'] = $lastname;}
    if ($salutation != ''){$data['anrede'] = $salutation;}
    if ($company != ''){$data['firma'] = $company;}
    if ($street != ''){$data['strasse'] = $street;}
    if ($housenumber != ''){$data['hausnummer'] = $housenumber;}
    if ($zip != ''){$data['plz'] = $zip;}
    if ($city != ''){$data['ort'] = $city;}
    //@todo: if ($country != ''){}
    if ($telephone != ''){$data['telefon_durchwahl'] = $telephone;}
    if ($mobile != ''){$data['telefon_handy'] = $mobile;}
    if ($email != ''){$data['email_direkt'] = $email;}
    if ($fax != ''){$data['telefon_fax'] = $fax;}
    if ($url != ''){$data['url'];}
    if ($identifier != null){
      $data['personennummer'] = $identifier;
    }

    if ($identifier != null){
      $rows = $this->database->exec_SELECTgetRows(
        'uid',
        'tx_sgestatecore_domain_model_kontaktperson',
        'personennummer LIKE "'.$identifier.'" AND deleted=0'
      );
      if (count($rows) > 0){
        $this->database->exec_UPDATEquery(
          'tx_sgestatecore_domain_model_kontaktperson',
          'personennummer LIKE "'.$identifier.'" AND deleted=0',
          $data
        );
        $uid = intval($rows[0]['uid']);
      }else{
        $this->database->exec_INSERTquery(
          'tx_sgestatecore_domain_model_kontaktperson',
          $data
        );
        $uid = $this->database->sql_insert_id();
      }
    }else{
      $this->database->exec_INSERTquery(
        'tx_sgestatecore_domain_model_kontaktperson',
        $data
      );
      $uid = $this->database->sql_insert_id();
    }
    return $uid;
  }

  private function addCity($cityName){
    if ($cityName != ''){
      $rows = $this->database->exec_SELECTgetRows(
        'uid',
        'tx_sgestatecore_domain_model_ort',
        'bezeichner LIKE "'.$cityName.'" AND deleted=0'
      );
      $data = array();
      $data['pid']        = $this->storagePid;
      $data['bezeichner'] = $cityName;

      if (count($rows) > 0){
        $uid = intval($rows[0]['uid']);
      }else{
        $this->database->exec_INSERTquery(
          'tx_sgestatecore_domain_model_ort',
          $data
        );
        $uid = $GLOBALS['TYPO3_DB']->sql_insert_id();
      }
      return $uid;
    }else{
      return null;
    }

  }

  private function addDistrict($districtName, $cityUid){
    if (($districtName != '')&&(is_numeric($cityUid))){
      $rows = $this->database->exec_SELECTgetRows(
        'uid',
        'tx_sgestatecore_domain_model_stadtteil',
        'bezeichner LIKE "'.$districtName.'" AND ort = '.$cityUid.' AND deleted=0'
      );
      $data = array();
      $data['pid']        = $this->storagePid;
      $data['ort']        = $cityUid;
      $data['bezeichner'] = $districtName;


      if (count($rows) > 0){
        $uid = intval($rows[0]['uid']);
      }else{
        $this->database->exec_INSERTquery(
          'tx_sgestatecore_domain_model_stadtteil',
          $data
        );
        $uid = $GLOBALS['TYPO3_DB']->sql_insert_id();
      }
      return $uid;
    }else{
      return null;
    }
  }

  private function getBoolWert($value){
    if (strval($value) != ''){
      if ((strtolower(strval($value)) == 'true')||(strtolower(strval($value)) == 'ja')||(strtolower(strval($value)) == 'j')){
        return 1;
      }elseif ((strtolower(strval($value)) == 'false')||(strtolower(strval($value)) == 'n')){
        return -1;
      }else{
        return 0;
      }
    }else{
      return 0;
    }
  }

  /**
   * Adds an Entry to the internal Log Array
   *
   * @param $titel
   * @param $text
   */
  private function addWarnung($titel, $text){
    $this->warnungen[] = array(
      'titel' => $titel,
      'text' => $text
    );
  }

  /**
   * Unzips filenameZip to pathExtract
   *
   * @param string $filenameZip
   * @param string $pathExtract
   * @return bool
   */
  private function unzip($filenameZip, $pathExtract){
    $zip = new \ZipArchive;
    if ($zip->open($filenameZip) === TRUE){
      $zip->extractTo($pathExtract);
      $zip->close();
      return true;
    }else {
      return false;
    }
  }

  /**
   * Check if all necessary functions are there
   * @return bool
   */
  private function systemcheck(){
    return class_exists('\ZipArchive');
  }

  /**
   * This method returns the destination mail address as additional information
   *
   * @return string Information to display
   */
  public function getAdditionalInformation() {
    $return = 'Immobilienspeicher:'.$this->getStoragePid();
    if ($this->isDebugMode()){
      $return .= ', DEBUGMODE aktiviert';
    }
    return $return;
  }

  /**
   * @param int $storagePid
   */
  public function setStoragePid($storagePid){$this->storagePid = $storagePid;}

  /**
   * @return int
   */
  public function getStoragePid(){return $this->storagePid;}

  /**
   * @return boolean
   */
  public function isDebugMode(){return $this->debugMode;}

  /**
   * @param boolean $debugMode
   * @return $this
   */
  public function setDebugMode($debugMode){$this->debugMode = $debugMode;return $this;}


  private function getCol($property, $kindOfObject = 0){
    if (!is_file(PATH_site.$this->getConfigPfad().'colDefintion.php')){
      throw new \RuntimeException('Konfiguration fehlt', 4711);
    }else{
      require PATH_site.$this->getConfigPfad().'colDefintion.php';
    }

    if (!is_numeric($kindOfObject)){
      $kindOfObject = 0;
    }

    if (isset($translate[$kindOfObject][$property])){
      if (is_array($translate[$kindOfObject][$property])){
        return $translate[$kindOfObject][$property];
      }else{
        return $translate[$kindOfObject][$property]-1;
      }
    }else{
      return null;
    }


  }

  /**
   * @param $object
   * @param $token
   * @return null
   */
  private function translateToken($object, $token){
    if (!is_file(PATH_site.$this->getConfigPfad().'tokenDefinition.php')){
      throw new \RuntimeException('Konfiguration fehlt', 4711);
    }else{
      require PATH_site.$this->getConfigPfad().'tokenDefinition.php';
    }
    if (isset($translation[$object][$token])){
      return $translation[$object][$token];
    }else{
      return null;
    }
  }

  /**
   * @return string
   */
  public function getConfigPfad()
  {
    return $this->configPfad;
  }

  /**
   * @param string $configPfad
   * @return $this
   */
  public function setConfigPfad($configPfad)
  {
    $this->configPfad = $configPfad;
    return $this;
  }

  /**
   * @return int
   */
  public function getDaysToKeepArchiveFiles()
  {
    return $this->daysToKeepArchiveFiles;
  }

  /**
   * @param int $daysToKeepArchiveFiles
   * @return $this
   */
  public function setDaysToKeepArchiveFiles($daysToKeepArchiveFiles)
  {
    $this->daysToKeepArchiveFiles = $daysToKeepArchiveFiles;
    return $this;
  }

}
