<?php
namespace SG\SgEstateImmosolve\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Persistence\QueryResultInterface;

/***************************************************************
 *
 *  Copyright notice
 *
 *  (c) 2019 Jessica Schlierenkamp <schlierenkamp@smply.gd>
 *
 *  All rights reserved
 *
 *  This script is part of the TYPO3 project. The TYPO3 project is
 *  free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  The GNU General Public License can be found at
 *  http://www.gnu.org/copyleft/gpl.html.
 *
 *  This script is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 ***************************************************************/
class Region extends AbstractEntity
{

    /**
     * @var string
     */
    protected $name = '';

    /**
     * @var string
     */
    protected $immosolveId = '';

    /**
     * @var \SG\SgEstateImmosolve\Domain\Model\Region
     **/
    protected $parent;

    /**
     * @var array
     **/
    protected $children;

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * @return string
     */
    public function getImmosolveId()
    {
        return $this->immosolveId;
    }

    /**
     * Preprocess explode of immosolve id string
     * @return array
     */
    public function getImmosolveIdArray()
    {
        return self::getImmosolveIdsArrayFromString( $this->getImmosolveId() );
    }

    /**
     * @param string $immosolveId
     */
    public function setImmosolveId($immosolveId)
    {
        $this->immosolveId = $immosolveId;
    }

    /**
     * @return \SG\SgEstateImmosolve\Domain\Model\Region
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * @param \SG\SgEstateImmosolve\Domain\Model\Region $parent
     */
    public function setParent($parent)
    {
        $this->parent = $parent;
    }

    /**
     * @return array
     */
    public function getChildren()
    {
        return $this->children;
    }

    /**
     * @param array $children
     */
    public function setChildren($children)
    {
        $this->children = $children;
    }

    /**
     * Returns a complete set of immosolve ids of all ids of selected
     * region items
     *
     * @param array|QueryResultInterface $regions
     *
     * @return array
     */
    public static function getImmosolveIdArrayFromSelection($regions)
    {
        $r = [];
        /** @var Region $region */
        foreach ($regions as $region) {
            if ($region instanceof Region) {
                $thisImmosolveIds = $region->getImmosolveIdArray();
                if (count($thisImmosolveIds) > 0) {
                    $r = array_merge($r, $thisImmosolveIds);
                }
            }
        }
        return $r;
    }

    /**
     * Returns a complete set of immosolve ids of all ids of a given id string array
     *
     * @param array $idStrings
     *
     * @return array
     */
    public static function getImmosolveIdsArrayFromStrings($idStrings = [])
    {
        $r = [];
        foreach ($idStrings as $idString) {
            $thisIds = self::getImmosolveIdsArrayFromString($idString);
            if (count($thisIds) > 0) {
                $r = array_merge($r, $thisIds);
            }
        }
        return $r;
    }

    /**
     * Preprocess explode of immosolve id string
     *
     * @param string $ids
     *
     * @return array
     */
    public static function getImmosolveIdsArrayFromString($ids = '')
    {
        $result = [];
        if ($ids !== '' && $ids !== '0') {
            if (strpos($ids, ',') !== false) {
                $tempResult = explode(',', $ids);
                foreach ($tempResult as $id) {
                    $id = trim($id);
                    if ($id !== '') {
                        $result [] = $id;
                    }
                }
            } else {
                $result[] = $ids;
            }
        }
        return $result;
    }
}
