<?php

namespace SG\SgEstateImmosolve\Util;

use SG\SgEstateImmosolve\Domain\Model\Region;
use SG\SgEstateImmosolve\Domain\Repository\RegionRepository;
use TYPO3\CMS\Extbase\Persistence\Generic\QuerySettingsInterface;
use TYPO3\CMS\Extbase\Persistence\Generic\Typo3QuerySettings;

class AddFields implements \TYPO3\CMS\Core\SingletonInterface
{

    /**
     * @var \TYPO3\CMS\Extbase\Object\ObjectManager
     */
    protected $objectManager;


    public function __construct()
    {
        $pluginConfiguration = array(
            'extensionName' => 'sgestateimmosolve',
            'pluginName' => 'Pi1',
            'vendorName' => 'SG',
        );

        $bootstrap = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\CMS\Extbase\Core\Bootstrap');
        $bootstrap->initialize($pluginConfiguration);

        $this->objectManager = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\CMS\Extbase\Object\ObjectManager');

    }

    /**
     *
     * Returns all activated KindOfObjects for use in Flexform
     *
     * @param $config
     *
     * @return mixed
     */
    public function addRegions($config)
    {
        $optionList = [];
        /** @var RegionRepository $regionRepository */
        $regionRepository = $this->objectManager->get(RegionRepository::class);
        /** @var QuerySettingsInterface $querySettings */
        $querySettings = $this->objectManager->get(Typo3QuerySettings::class);
        $querySettings->setRespectStoragePage(FALSE);
        $regionRepository->setDefaultQuerySettings($querySettings);

        /** @var Region $region */
        foreach ($regionRepository->findAll() as $region) {
            $label = $region->getName() . ' (' . $region->getImmosolveId() . ')';
            if ($region->getParent() instanceof Region) {
                $label = $region->getParent()->getName() . ' - ' . $label;
            }
            $optionList[] = [
                $label,
                $region->getUid(),
            ];
        }

        $config[ 'items' ] = array_merge($config[ 'items' ], $optionList);
        return $config;
    }


}