<?php
namespace SG\SgEstateImmosolve\Domain\Repository;

use SG\SgEstateImmosolve\Domain\Model\Region;
use TYPO3\CMS\Extbase\Persistence\QueryResultInterface;
use TYPO3\CMS\Extbase\Persistence\Repository;
use TYPO3\CMS\Extbase\Utility\DebuggerUtility;

/***************************************************************
 *
 *  Copyright notice
 *
 *  (c) 2019 Jessica Schlierenkamp <schlierenkamp@smply.gd>
 *
 *  All rights reserved
 *
 *  This script is part of the TYPO3 project. The TYPO3 project is
 *  free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  The GNU General Public License can be found at
 *  http://www.gnu.org/copyleft/gpl.html.
 *
 *  This script is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 ***************************************************************/
class RegionRepository extends Repository
{
    /**
     * @param array $uids
     *
     * @return array|QueryResultInterface
     */
    public function findByUids( $uids = [] ) {
        $query = $this->createQuery();
        foreach ($uids as $key => $value) {
            $constraints[] =  $query->equals('uid', $value);
        }
        return $query->matching(
            $query->logicalOr( $constraints )
        )->execute();
    }

    /**
     * @param array $uids
     *
     * @return array|QueryResultInterface
     */
    public function findAllWithoutUids( $uids = [] ) {
        $query = $this->createQuery();
        foreach ($uids as $key => $value) {
            $constraints[] = $query->logicalNot( $query->equals('uid', $value) );
        }
        return $query->matching(
            $query->logicalAnd( $constraints )
        )->execute();
    }

    /**
     * Builds the region parent/children based tree. Children elements
     * whose parent was not in the selected set will be appended at the end
     * of the tree.
     *
     * @param QueryResultInterface $regions
     *
     * @return array
     */
    public static function buildRegionTree( $regions ) {
        // Push all parent regions to tree array and move
        // all other regions to the regionIndex where the index is
        // the region uid so we can later grab elements from there
        // when building the children of a given element
        $regionIndex = [];
        $tree = [];
        /** @var Region $region */
        foreach( $regions as $region ) {
            if( $region->getParent() instanceof Region ) {
                $regionIndex[] = $region;
            }
            else {
                $tree[ $region->getUid() ] = $region;
            }
        }
        // Now resolve the tree structure recursively. We use $tree
        // as the starting point and walk through each structure
        // and append the correct child elements from $regionIndex
        $tree = self::buildRegionTreeSubtree($tree, $regionIndex);
        // Append unmatched regions which have a parent at the end
        // of the tree set
        if( count( $regionIndex ) > 0 ) {
            foreach( $regionIndex as $item ) {
                $tree[] = $item;
            }
        }
        return $tree;
    }

    /**
     * Recursively resolve parent / children for regions
     *
     * @param $tree
     * @param $regionIndex
     *
     * @return mixed
     */
    private static function buildRegionTreeSubtree( $tree, &$regionIndex ) {
        /** @var Region $treeItem */
        foreach( $tree as $key => $treeItem ) {
            $addChildren = [];
            /** @var Region $indexItem */
            foreach( $regionIndex as $indexKey => $indexItem ) {
                if( $indexItem->getParent()->getUid() === $treeItem->getUid() ) {
                    $addChildren[] = $indexItem;
                    unset($regionIndex[$indexKey ]);
                }
            }
            $treeItem->setChildren( self::buildRegionTreeSubtree($addChildren, $regionIndex ) );
        }
        return $tree;
    }
}
