<?php
namespace SG\SgEstateImmosolve\Service;

use SG\SgEstateImmosolve\Domain\Model\QueueItem;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Object\ObjectManager;
use TYPO3\CMS\Extbase\Persistence\Generic\PersistenceManager;

/***************************************************************
 *
 *  Copyright notice
 *
 *
 *  (c) 2016 Daniel Hoffmann <hoffmann@smply.gd>
 *
 *  All rights reserved
 *
 *  This script is part of the TYPO3 project. The TYPO3 project is
 *  free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  The GNU General Public License can be found at
 *  http://www.gnu.org/copyleft/gpl.html.
 *
 *  This script is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 ***************************************************************/
class QueueService
{
    /**
     * @var \SG\SgEstateImmosolve\Domain\Repository\QueueItemRepository
     * @TYPO3\CMS\Extbase\Annotation\Inject
     */
    private $queueItemRepository;

    /**
     * @var \TYPO3\CMS\Extbase\Persistence\Generic\PersistenceManager
     */
    protected $persistenceManager;

    /**
     * @var \TYPO3\CMS\Extbase\Object\ObjectManager
     */
    protected $objectManager;

    public function __construct()
    {
        $this->objectManager = GeneralUtility::makeInstance(ObjectManager::class);
        $this->persistenceManager = $this->objectManager->get(PersistenceManager::class);
    }

    /**
     * @param array $parameter
     * @param string $requestType
     * @param int $pid
     *
     * @throws \TYPO3\CMS\Extbase\Persistence\Exception\IllegalObjectTypeException
     */
    public function addItemToQueue($parameter = [], $requestType = 'realty', $pid = 0)
    {
        /** @var QueueItem $queueItem */
        $queueItem = $this->objectManager->get(QueueItem::class);
        $queueItem->setRequestType($requestType);
        $queueItem->setPayload(json_encode($parameter));
        $queueItem->setPid($pid);
        $this->queueItemRepository->add($queueItem);
        $this->persistenceManager->persistAll();
    }
}
