<?php
namespace SG\SgEstateImmosolve\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

/***************************************************************
 *
 *  Copyright notice
 *
 *  (c) 2019 Jessica Schlierenkamp <schlierenkamp@smply.gd>
 *
 *  All rights reserved
 *
 *  This script is part of the TYPO3 project. The TYPO3 project is
 *  free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  The GNU General Public License can be found at
 *  http://www.gnu.org/copyleft/gpl.html.
 *
 *  This script is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 ***************************************************************/
class Region extends AbstractEntity
{

    /**
     * @var string
     */
    protected $name = '';

    /**
     * @var int
     */
    protected $immosolveId = '';

    /**
     * @var \SG\SgEstateImmosolve\Domain\Model\Region
     **/
    protected $parent;

    /**
     * @var array
     **/
    protected $children;

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * @return int
     */
    public function getImmosolveId()
    {
        return $this->immosolveId;
    }

    /**
     * @param int $immosolveId
     */
    public function setImmosolveId($immosolveId)
    {
        $this->immosolveId = $immosolveId;
    }

    /**
     * @return \SG\SgEstateImmosolve\Domain\Model\Region
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * @param \SG\SgEstateImmosolve\Domain\Model\Region $parent
     */
    public function setParent($parent)
    {
        $this->parent = $parent;
    }

    /**
     * @return array
     */
    public function getChildren()
    {
        return $this->children;
    }

    /**
     * @param array $children
     */
    public function setChildren($children)
    {
        $this->children = $children;
    }
}
