<?php
namespace Daho\SgEstateImmosolve\Controller;

use TYPO3\CMS\Core\Utility\GeneralUtility;

class CommunicationController extends  \TYPO3\CMS\Extbase\Mvc\Controller\ActionController{

  /**
   * @var \Daho\SgEstateCore\Domain\Repository\ImmobilieRepository
   * @inject
   */
  protected $immobilieRepository;

  public function realtyRequestAction(){
    if ($this->request->hasArgument('realty')){
      $realty = $this->immobilieRepository->findOneByUrlIdentifier($this->request->getArgument('realty'));
      $this->view->assign('realty', $realty);
    }elseif ($this->request->hasArgument('formValues')){
      $formValues = $this->request->getArgument('formValues');

      $realty = $this->immobilieRepository->findByUid($formValues['realty']);

      $errors = array();
      $valid = true;
      if ($this->settings['settings']['realtyRequest']['validation']['salutation']['required']){
        $this->checkRequired($formValues, 'salutation', $valid, $errors);
      }
      if ($this->settings['settings']['realtyRequest']['validation']['firstname']['required']){
        $this->checkRequired($formValues, 'firstname', $valid, $errors);
      }
      if ($this->settings['settings']['realtyRequest']['validation']['lastname']['required']){
        $this->checkRequired($formValues, 'lastname', $valid, $errors);
      }
      if ($this->settings['settings']['realtyRequest']['validation']['street']['required']){
        $this->checkRequired($formValues, 'street', $valid, $errors);
      }
      if ($this->settings['settings']['realtyRequest']['validation']['zip']['required']){
        $this->checkRequired($formValues, 'zip', $valid, $errors);
      }
      if ($this->settings['settings']['realtyRequest']['validation']['city']['required']){
        $this->checkRequired($formValues, 'city', $valid, $errors);
      }
      if ($this->settings['settings']['realtyRequest']['validation']['phone']['required']){
        $this->checkRequired($formValues, 'phone', $valid, $errors);
      }
      if ($this->settings['settings']['realtyRequest']['validation']['mobile']['required']){
        $this->checkRequired($formValues, 'mobile', $valid, $errors);
      }
      if ($this->settings['settings']['realtyRequest']['validation']['fax']['required']){
        $this->checkRequired($formValues, 'fax', $valid, $errors);
      }
      $this->checkRequired($formValues, 'email', $valid, $errors);
      if (!GeneralUtility::validEmail($formValues['email'])){
        $valid = false;
        $errors['email'] = true;
      }
      if ($this->settings['settings']['realtyRequest']['validation']['wbs']['required']){
        $this->checkRequired($formValues, 'wbs', $valid, $errors);
      }
      if ($this->settings['settings']['realtyRequest']['validation']['birthdate']['required']){
        $this->checkRequired($formValues, 'birthdate', $valid, $errors);
      }
      if ($this->settings['settings']['realtyRequest']['validation']['occupation']['required']){
        $this->checkRequired($formValues, 'occupation', $valid, $errors);
      }
      if ($this->settings['settings']['realtyRequest']['validation']['phoneBusiness']['required']){
        $this->checkRequired($formValues, 'phoneBusiness', $valid, $errors);
      }
      if ($this->settings['settings']['realtyRequest']['validation']['employer']['required']){
        $this->checkRequired($formValues, 'employer', $valid, $errors);
      }
      if ($this->settings['settings']['realtyRequest']['validation']['familyStatus']['required']){
        $this->checkRequired($formValues, 'familyStatus', $valid, $errors);
      }
      if ($this->settings['settings']['realtyRequest']['validation']['secondPersonFirstname']['required']){
        $this->checkRequired($formValues, 'secondPersonFirstname', $valid, $errors);
      }
      if ($this->settings['settings']['realtyRequest']['validation']['secondPersonLastname']['required']){
        $this->checkRequired($formValues, 'secondPersonLastname', $valid, $errors);
      }
      if ($this->settings['settings']['realtyRequest']['validation']['secondPersonBirthday']['required']){
        $this->checkRequired($formValues, 'secondPersonBirthday', $valid, $errors);
      }
      if ($this->settings['settings']['realtyRequest']['validation']['personCount']['required']){
        $this->checkRequired($formValues, 'personCount', $valid, $errors);
      }
      if ($this->settings['settings']['realtyRequest']['validation']['childCount']['required']){
        $this->checkRequired($formValues, 'childCount', $valid, $errors);
      }
      if ($this->settings['settings']['realtyRequest']['validation']['adultCount']['required']){
        $this->checkRequired($formValues, 'adultCount', $valid, $errors);
      }
      if ($this->settings['settings']['realtyRequest']['validation']['information']['required']){
        $this->checkRequired($formValues, 'information', $valid, $errors);
      }

      if ($valid){
        $sendStatus = $this->sendTemplateEmail(array($this->settings['settings']['immosolve']['email']),array(),$formValues['email'],'Objektanfrage expr_'.$this->settings['settings']['immosolve']['gruppenid'],'RealtyRequest',array('realty'=>$realty,'formValues'=>$formValues));
        if ($sendStatus){
          $sendStatus = 'success';
        }else{
          $sendStatus = 'sendfailed';
        }
        $this->view->assign('sendStatus', $sendStatus);
      }else{
        $this->view->assign('formValues', $formValues);
        $this->view->assign('errors', $errors);
      }

      $this->view->assign('realty', $realty);
    }else{
      //@todo: Redirect
    }
  }

  private function checkRequired($formValues, $name, &$valid, &$errors){
    if ($formValues[$name] == ''){
      $valid = false;
      $errors[$name] = true;
    }
  }

  public function searchRequestAction(){}


  private function sendTemplateEmail(array $recipients = array(), array $bcc = array(), $sender, $subject, $templateName, array $variables = array(), $format = 'text/plain') {
    /**
     * @var $emailView \TYPO3\CMS\Fluid\View\StandaloneView
     * @var $message \TYPO3\CMS\Core\Mail\MailMessage
     */
    $objectManager = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\CMS\Extbase\Object\ObjectManager');

    $templateRootPath = \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::extPath('sg_estate_immosolve') . 'Resources/Private/Templates/';
    $templatePathAndFilename = $templateRootPath . 'Email/' . $templateName . '.html';

    $emailView = $objectManager->get('TYPO3\CMS\Fluid\View\StandaloneView');
    $emailView->setTemplatePathAndFilename($templatePathAndFilename);
    $emailView->setFormat('html');
    $emailView->assignMultiple($variables);

    $emailBody = $emailView->render();

    $message = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\CMS\Core\Mail\MailMessage');

    if (\TYPO3\CMS\Core\Utility\GeneralUtility::validEmail($sender)){
      $message->setFrom($sender);
    }else{
      return false;
    }

    // Add Recipients
    $recipients = array_filter($recipients);
    if (count($recipients) > 0){
      foreach ($recipients as $email){
        if (\TYPO3\CMS\Core\Utility\GeneralUtility::validEmail($email)){
          $message->addTo($email);
        }
      }
    }else{
      return false;
    }

    if (count($bcc) > 0){
      foreach ($bcc as $email){
        if (\TYPO3\CMS\Core\Utility\GeneralUtility::validEmail($email)){
          $message->addBcc($email);
        }
      }
    }

    if ($subject != ''){
      $message->setSubject($subject);
    }else{
      return false;
    }

    $message->setBody($emailBody, $format);

    $message->send();
    return $message->isSent();
  }

}