<?php
namespace Daho\SgEstateImmosolve\Controller;

use Daho\SgEstateImmosolve\Domain\Model\Region;
use Daho\SgEstateImmosolve\Service\ImmosolveContactApiService;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Utility\DebuggerUtility;
use TYPO3\CMS\Extbase\Utility\LocalizationUtility;

class CommunicationController extends \TYPO3\CMS\Extbase\Mvc\Controller\ActionController
{
    /**
     * @var \Daho\SgEstateImmosolve\Domain\Repository\RegionRepository
     * @inject
     */
    protected $regionRepository;

    /**
     * @var \Daho\SgEstateCore\Domain\Repository\ImmobilieRepository
     * @inject
     */
    protected $immobilieRepository;

    /**
     * @var \Daho\SgEstateImmosolve\Service\ImmosolveContactApiService
     * @inject
     */
    protected $immosolveContactApiService;

    public function realtyRequestAction()
    {
        if ($this->request->hasArgument('realty')) {
            $realty = $this->immobilieRepository->findOneByUrlIdentifier($this->request->getArgument('realty'));
            $this->view->assign('realty', $realty);
        } elseif ($this->request->hasArgument('formValues')) {
            $formValues = $this->request->getArgument('formValues');
            $realty = $this->immobilieRepository->findByUid($formValues['realty']);
            $errors = [];
            $valid = true;

            // we need to map before validation in case api required fields have different form field names
            $this->immosolveContactApiService->map($formValues, 'realty');
            $this->validateRealtyRequest($formValues, $valid, $errors);

            if ($valid) {
                if ($this->settings['immosolve']['service'] === 'api') {
                    $sendStatus = $this->immosolveContactApiService->queueInquiry($formValues,
                        'object') ? 'success' : 'sendfailed';
                } else {
                    $sendStatus = $this->sendTemplateEmail([$this->settings['settings']['immosolve']['email']],
                        $formValues['email'],
                        'Objektanfrage expr_' . $this->settings['settings']['immosolve']['gruppenid'],
                        'RealtyRequest',
                        ['realty' => $realty, 'formValues' => $formValues]) ? 'success' : 'sendfailed';
                }

                $this->view->assign('sendStatus', $sendStatus);
            } else {
                // we need to unmap so form values can be assigned to the correct fields & errors are shown correctly
                $this->immosolveContactApiService->unmap($formValues, 'realty');
                $this->immosolveContactApiService->unmap($errors, 'realty');
                $this->view->assignMultiple(['formValues' => $formValues, 'error' => $errors]);
            }

            $this->view->assign('realty', $realty);
        } else {
            //@todo: Redirect
        }
    }

    public function searchRequestAction()
    {
        $submittedDataIsValid = true;
        $formErrors = [];
        $submittedFormData = [];
        $sendStatus = false;

        $submittedStep = $this->getSubmittedStep();
        $requestedStep = $this->getRequestedStep();

        if ($this->request->hasArgument('completeFormData')) {
            $completeFormData = json_decode($this->request->getArgument('completeFormData'), true);
        } else {
            $completeFormData = [];
        }

        if ($this->request->hasArgument('formValues')) {
            $submittedFormData = $this->request->getArgument('formValues');
            $completeFormData['step-' . $submittedStep] = $submittedFormData['step-' . $submittedStep];

            if (!empty($submittedFormData['step-' . $submittedStep])) {

                $currentFormValues = $submittedFormData['step-' . $submittedStep];
                $submittedDataIsValid = $this->validatePetitionRequest($currentFormValues, $formErrors);

            } else {
                $submittedDataIsValid = false;
            }

        } elseif ($requestedStep > 1) {
            $submittedDataIsValid = false;
        }

        if ($submittedDataIsValid) {
            $currentStep = $requestedStep;

            if ($currentStep > $this->settings['settings']['searchRequest']['formSteps']) {

                $apiData = [];
                foreach ($completeFormData as $data) {
                    $apiData = array_merge($apiData, $data);
                }

                $this->immosolveContactApiService->map($apiData, 'petition');

                if ($this->settings['immosolve']['service'] === 'api') {
                    $sendStatus = $this->immosolveContactApiService->queueInquiry($apiData,
                        'petition') ? 'success' : 'sendfailed';
                } else {
                    $sendStatus = $this->sendTemplateEmail([$this->settings['settings']['immosolve']['searchRequest']['email']],
                        $submittedFormData['step-1']['email'],
                        'Anfrage von portal ' . $this->settings['settings']['immosolve']['searchRequest']['gruppenid'],
                        'SearchRequest', ['formValues' => $submittedFormData]) ? 'success' : 'sendfailed';
                }
            }
        } else {
            $currentStep = $submittedStep;
            if( $requestedStep < $submittedStep ) {
                $currentStep = $requestedStep;
            }
        }

        $this->view->assignMultiple([
            'birthdayYears' => $this->getBirthdayYears(),
            'currentStep' => $currentStep,
            'errors' => $formErrors,
            'completeFormData' => json_encode($completeFormData),
            'formValues' => $completeFormData['step-' . $currentStep],
            'sendStatus' => $sendStatus ? 'success' : '',
            'regions' => $this->getRegions(),
            'nationalities' => $this->getNationalitiesForSelect()
        ]);
    }

    /**
     * @return array|\TYPO3\CMS\Extbase\Persistence\QueryResultInterface
     */
    private function getRegions()
    {
        $regions = $this->regionRepository->findByParent(0);

        foreach ($regions as $region) {
            $this->buildRegionTree($region);
        }

        return $regions;
    }

    private function buildRegionTree(Region $region)
    {

        $children = $this->regionRepository->findByParent($region);

        if ($children->count() > 0) {
            $region->setChildren($children);

            foreach ($children as $child) {
                $this->buildRegionTree($child);
            }
        }

    }

    private function getChildRegionsRecursive($region, &$regions, $index)
    {
        $children = $this->regionRepository->findByParent($region);

        if ($children->count() === 0) {

            return [
                'region' => $region,
                'children' => []
            ];

            /*$regions[$index]['children'][] = [
                'region' => $region,
                'children' => []
            ];

            return $regions;*/
        }

        foreach ($children as $child) {
            $this->getChildRegionsRecursive($child, $regions, $index);
        }

        /*$regions[$index] = [
            'region' => $region,
        ];

        foreach ($children as $child) {
            $this->getChildRegionsRecursive($child, $regions, $index);
        }*/

        $index++;
    }

    /**
     * @param $formValues
     * @param $valid
     * @param $errors
     *
     * @return void
     */
    private
    function validateRealtyRequest(
        $formValues,
        &$valid,
        &$errors
    ) {
        $possibly_required_fields = array_merge($this->settings['settings']['realtyRequest']['validation'],
            ImmosolveContactApiService::API_REQUIRED_FIELDS['realty']);
        foreach ($possibly_required_fields as $field_name => $field) {
            if ($field['required'] && (!isset($formValues[$field_name]) || $formValues[$field_name] === '')) {
                $valid = false;
                $errors[$field_name] = true;
            }
        }

        if (!GeneralUtility::validEmail($formValues['email'])) {
            $valid = false;
            $errors['email'] = true;
        }
    }

    /**
     * @param array $recipients
     * @param array $bcc
     * @param $sender
     * @param $subject
     * @param $templateName
     * @param array $variables
     * @param string $format
     *
     * @return bool
     */
    private
    function sendTemplateEmail(
        array $recipients,
        $sender,
        $subject,
        $templateName,
        array $variables = [],
        $format = 'text/plain',
        array $bcc = []
    ) {
        /**
         * @var $emailView \TYPO3\CMS\Fluid\View\StandaloneView
         * @var $message \TYPO3\CMS\Core\Mail\MailMessage
         */
        $objectManager = GeneralUtility::makeInstance('TYPO3\CMS\Extbase\Object\ObjectManager');

        $templateRootPath = \TYPO3\CMS\Core\Utility\ExtensionManagementUtility::extPath('sg_estate_immosolve') . 'Resources/Private/Templates/';
        $templatePathAndFilename = $templateRootPath . 'Email/' . $templateName . '.html';

        $emailView = $objectManager->get('TYPO3\CMS\Fluid\View\StandaloneView');
        $emailView->setTemplatePathAndFilename($templatePathAndFilename);
        $emailView->setFormat('html');
        $emailView->assignMultiple($variables);

        $emailBody = $emailView->render();

        $message = GeneralUtility::makeInstance('TYPO3\CMS\Core\Mail\MailMessage');

        if (GeneralUtility::validEmail($sender)) {
            $message->setFrom($sender);
        } else {
            return false;
        }

        // Add Recipients
        $recipients = array_filter($recipients);
        if (count($recipients) > 0) {
            foreach ($recipients as $email) {
                if (GeneralUtility::validEmail($email)) {
                    $message->addTo($email);
                }
            }
        } else {
            return false;
        }

        if (count($bcc) > 0) {
            foreach ($bcc as $email) {
                if (GeneralUtility::validEmail($email)) {
                    $message->addBcc($email);
                }
            }
        }

        if ($subject !== '') {
            $message->setSubject($subject);
        } else {
            return false;
        }

        $message->setBody($emailBody, $format);

        $message->send();

        return $message->isSent();
    }

    /**
     * @return int
     */
    private
    function getRequestedStep()
    {
        if ($this->request->hasArgument('submit')) {
            $direction = $this->request->getArgument('submit');
            $submitted_step = $this->getSubmittedStep();

            switch ($direction) {
                case LocalizationUtility::translate('template.contact.next', 'sg_estate_immosolve'):
                case LocalizationUtility::translate('template.contact.submit', 'sg_estate_immosolve'):
                    $requested_step = $submitted_step + 1;
                    break;
                case LocalizationUtility::translate('template.contact.previous', 'sg_estate_immosolve'):
                    $requested_step = $submitted_step - 1;
                    break;
                default:
                    $requested_step = 1;
            }
        } else {
            $requested_step = 1;
        }

        return $requested_step;
    }

    /**
     *
     * @return int|string
     * @throws \TYPO3\CMS\Extbase\Mvc\Exception\NoSuchArgumentException
     */
    private
    function getSubmittedStep()
    {
        return $this->request->hasArgument('currentStep') ? $this->request->getArgument('currentStep') : 1;
    }

    private
    function getBirthdayYears()
    {
        $birthday_years = [];
        $current_year = (int)date('Y');

        for ($i = $current_year - 18; $i >= $current_year - 90; $i--) {
            $birthday_years[$i] = $i;
        }

        return $birthday_years;
    }

    /**
     * @param $form_values
     * @param array $required_fields
     * @param array $errors
     * @param $data_is_valid
     * @param bool $against_api_fields
     *
     * @return bool
     */
    private
    function validatePetitionRequest(
        $form_values,
        array &$errors
    ) {
        $data_is_valid = true;
        $possibly_required_fields = array_merge(
            ImmosolveContactApiService::API_REQUIRED_FIELDS['petition'],
            $this->settings['settings']['searchRequest']['validation']
        );
        foreach ($form_values as $field => $value) {

            $api_fieldname = $this->immosolveContactApiService->getApiFieldName($field, 'petition');
            // needs validation
            if( $possibly_required_fields[$field]['required'] || $possibly_required_fields[$api_fieldname]['required'] ) {
                if( isset($possibly_required_fields[$field]['check'] ) ) {
                    if( $possibly_required_fields[$field]['check'] === 'birthday' ) {
                        $thisFieldValues = $form_values[$field];
                        if( $thisFieldValues['day'] !== '' && $thisFieldValues['month'] !== '' && $thisFieldValues['year'] !== '') {
                            $checkDateResult = checkdate((int)$thisFieldValues[ 'month' ], (int)$thisFieldValues[ 'day' ], (int)$thisFieldValues[ 'year' ]);
                            if( $checkDateResult === false ) {
                                $data_is_valid = false;
                                $errors[$field] = true;
                            }
                        }
                        else {
                            $data_is_valid = false;
                            $errors[$field] = true;
                        }
                    }
                    else if( $possibly_required_fields[$field]['check'] === 'email' && !GeneralUtility::validEmail($form_values[$field]) ) {
                        $data_is_valid = false;
                        $errors[$field] = true;
                    }
                }
                else if( empty($value) ) {
                    $data_is_valid = false;
                    $errors[$field] = true;
                }
            }
        }

        return $data_is_valid;
    }

    private function getNationalitiesForSelect(){
        return array(
            "DE"=>"Deutschland",
            "TR"=>"Türkei",
            "RU"=>"Russland",
            "PL"=>"Polen",
            "MA"=>"Marokko",
            "HR"=>"Kroatien",
            "IT"=>"Italien",
            "IR"=>"Iran",
            "RS"=>"Serbien",
            "AF"=>"Afghanistan",
            "AD"=>"Andorra",
            "AE"=>"Vereinigte Arabische Emirate",
            "AG"=>"Antigua und Barbuda",
            "AI"=>"Anguilla",
            "AL"=>"Albanien",
            "AM"=>"Armenien",
            "AN"=>"Niederländische Antillen",
            "AO"=>"Angola",
            "AQ"=>"Antarktis",
            "AR"=>"Argentinien",
            "AS"=>"Amerikanisch Samoa",
            "AT"=>"Österreich",
            "AU"=>"Australien",
            "AW"=>"Aruba",
            "AZ"=>"Aserbaidschan",
            "BA"=>"Bosnien-Herzegowina",
            "BB"=>"Barbados",
            "BD"=>"Bangladesch",
            "BE"=>"Belgien",
            "BF"=>"Burkina Faso",
            "BG"=>"Bulgarien",
            "BH"=>"Bahrain",
            "BI"=>"Burundi",
            "BJ"=>"Benin",
            "BM"=>"Bermuda",
            "BN"=>"Brunei",
            "BO"=>"Bolivien",
            "BR"=>"Brasilien",
            "BS"=>"Bahamas",
            "BT"=>"Bhutan",
            "BV"=>"Bouvet-Insel",
            "BW"=>"Botswana",
            "BY"=>"Weißrussland",
            "BZ"=>"Belize",
            "CA"=>"Kanada",
            "CC"=>"Kokosinseln (Keeling)",
            "CF"=>"Zentralafrikanische Republik",
            "CG"=>"Congo",
            "CH"=>"Schweiz",
            "CI"=>"Elfenbeinküste",
            "CK"=>"Cookinseln",
            "CL"=>"Chile",
            "CM"=>"Kamerun",
            "CN"=>"China",
            "CO"=>"Kolumbien",
            "CR"=>"Costa Rica",
            "CU"=>"Kuba",
            "CV"=>"Kap Verde",
            "CX"=>"Weihnachtsinseln",
            "CY"=>"Zypern",
            "CZ"=>"Tschechien",
            "DJ"=>"Dschibuti",
            "DK"=>"Dänemark",
            "DM"=>"Dominica",
            "DO"=>"Dominikanische Republik",
            "DZ"=>"Algerien",
            "EC"=>"Ecuador",
            "EE"=>"Estland",
            "EG"=>"Ägypten",
            "EH"=>"Westsahara",
            "ER"=>"Eritrea",
            "ES"=>"Spanien",
            "ET"=>"Äthiopien",
            "FI"=>"Finnland",
            "FJ"=>"Fidschi",
            "FK"=>"Falklandinseln",
            "FM"=>"Mikronesien",
            "FO"=>"Färöer Inseln",
            "FR"=>"Frankreich",
            "GA"=>"Gabun",
            "GB"=>"Großbritannien",
            "GD"=>"Grenada",
            "GE"=>"Georgien",
            "GF"=>"Französisch Guyana",
            "GH"=>"Ghana",
            "GI"=>"Gibraltar",
            "GL"=>"Grönland",
            "GM"=>"Gambia",
            "GN"=>"Guinea",
            "GP"=>"Guadeloupe",
            "GQ"=>"Äquatorial-Guinea",
            "GR"=>"Griechenland",
            "GS"=>"Südgeorgien u. Sandw.-Ins.",
            "GT"=>"Guatemala",
            "GU"=>"Guam",
            "GW"=>"Guinea-Bissau",
            "GY"=>"Guyana",
            "HK"=>"Hongkong",
            "HM"=>"Heard- und Mcdonald-Ins.",
            "HN"=>"Honduras",
            "HT"=>"Haïti",
            "HU"=>"Ungarn",
            "ID"=>"Indonesien",
            "IE"=>"Irland",
            "IL"=>"Israel",
            "IN"=>"Indien",
            "IO"=>"Britische Territ. (Ind. Oz.)",
            "IQ"=>"Irak",
            "IS"=>"Island",
            "JM"=>"Jamaika",
            "JO"=>"Jordanien",
            "JP"=>"Japan",
            "KE"=>"Kenia",
            "KG"=>"Kirgisistan",
            "KH"=>"Kambodscha",
            "KI"=>"Kiribati",
            "KM"=>"Komoren",
            "KN"=>"St. Christopher und Nevis",
            "KP"=>"Nordkorea",
            "KR"=>"Südkorea",
            "KW"=>"Kuwait",
            "KY"=>"Cayman-Inseln",
            "KZ"=>"Kasachstan",
            "LA"=>"Laos",
            "LB"=>"Libanon",
            "LC"=>"Saint Lucia",
            "LI"=>"Liechtenstein",
            "LK"=>"Sri Lanka",
            "LR"=>"Liberia",
            "LS"=>"Lesotho",
            "LT"=>"Litauen",
            "LU"=>"Luxemburg",
            "LV"=>"Lettland",
            "LY"=>"Libyen",
            "MC"=>"Monaco",
            "MD"=>"Moldawien",
            "ME"=>"Montenegro",
            "MG"=>"Madagaskar",
            "MH"=>"Marshall-Inseln",
            "MK"=>"Mazedonien",
            "ML"=>"Mali",
            "MM"=>"Myanmar",
            "MN"=>"Mongolei",
            "MO"=>"Macao",
            "MP"=>"Nördliche Marianen Ins.",
            "MQ"=>"Martinique",
            "MR"=>"Mauretanien",
            "MS"=>"Montserrat",
            "MT"=>"Malta",
            "MU"=>"Mauritius",
            "MV"=>"Malediven",
            "MW"=>"Malawi",
            "MX"=>"Mexiko",
            "MY"=>"Malaysia",
            "MZ"=>"Mosambik",
            "NA"=>"Namibia",
            "NC"=>"Neu-Kaledonien",
            "NE"=>"Niger",
            "NF"=>"Norfolk-Insel",
            "NG"=>"Nigeria",
            "NI"=>"Nicaragua",
            "NL"=>"Niederlande",
            "NO"=>"Norwegen",
            "NP"=>"Nepal",
            "NR"=>"Nauru",
            "NU"=>"Niue",
            "NZ"=>"Neuseeland",
            "OM"=>"Oman",
            "PA"=>"Panama",
            "PE"=>"Peru",
            "PF"=>"Französisch Polynesien",
            "PG"=>"Papua-Neuguinea",
            "PH"=>"Philippinen",
            "PK"=>"Pakistan",
            "PM"=>"Saint Pierre und Miquelon",
            "PN"=>"Pitcairn",
            "PR"=>"Puerto Rico",
            "PT"=>"Portugal",
            "PW"=>"Palau",
            "PY"=>"Paraguay",
            "QA"=>"Katar",
            "RE"=>"Réunion",
            "RO"=>"Rumänien",
            "RW"=>"Ruanda",
            "SA"=>"Saudiarabien",
            "SB"=>"Salomonen",
            "SC"=>"Seychellen",
            "SD"=>"Sudan",
            "SE"=>"Schweden",
            "SG"=>"Singapur",
            "SH"=>"Sankt Helena",
            "SI"=>"Slowenien",
            "SJ"=>"Svalbard und Jan Mayen",
            "SK"=>"Slowakei",
            "SL"=>"Sierra Leone",
            "SM"=>"San Marino",
            "SN"=>"Senegal",
            "SO"=>"Somalia",
            "SR"=>"Surinam",
            "ST"=>"São Tomé und Príncipe",
            "STL"=>"Staatenlos",
            "SV"=>"El Salvador",
            "SY"=>"Syrien",
            "SZ"=>"Swasiland",
            "TC"=>"Turks- und Caicosins.",
            "TD"=>"Tschad",
            "TF"=>"Französische Südgebiete",
            "TG"=>"Togo",
            "TH"=>"Thailand",
            "TJ"=>"Tadschikistan",
            "TK"=>"Tokelau",
            "TM"=>"Turkmenistan",
            "TN"=>"Tunesien",
            "TO"=>"Tonga",
            "TP"=>"Ost Timor",
            "TT"=>"Trinidad und Tobago",
            "TV"=>"Tuvalu",
            "TW"=>"Taiwan",
            "TZ"=>"Tansania",
            "UA"=>"Ukraine",
            "UG"=>"Uganda",
            "UM"=>"Kleinere Amerik. Überseeins.",
            "US"=>"Vereinigte Staaten",
            "UY"=>"Uruguay",
            "UZ"=>"Usbekistan",
            "VA"=>"Vatikanstadt",
            "VC"=>"Sankt Vincent u. d. Gr.",
            "VE"=>"Venezuela",
            "VG"=>"Jungferninseln (Britisch)",
            "VI"=>"Jungferninseln (U.S.)",
            "VN"=>"Vietnam",
            "VU"=>"Vanuatu",
            "WF"=>"Wallis und Futuna",
            "WS"=>"Samoa",
            "XK"=>"Kosovo",
            "YE"=>"Jemen",
            "YT"=>"Mayotte",
            "YU"=>"Jugoslawien",
            "ZA"=>"Südafrika",
            "ZM"=>"Sambia",
            "ZR"=>"Zaire",
            "ZW"=>"Zimbabwe"
        );
    }
}