2 request types
 - realty request
 - search request

The TypoScript for each request is split into validation & mapping.

Validation:
- right now required is the only possible validation
- fields required by the API cannot be made optional with TypoScript

Mapping:
- field names or other settings we choose for our forms may differ from the api specifications so we need to map them
- starting point is the api field name, and we map the form field name. E.g.
  array( [API-FIELD-NAME] =>
    array( 'fieldName' => [FORM-FIELD-NAME] )
  )
- api required fields are set in sg_estate_immosolve's TypoScript settings. Additional optional fields can be set with
  a provider extension.
- some api fields allow only special values. Possibly these need to be mapped as well. E.g.:
  - the field salutation only allows a predefined set of values (mr, mrs, married-couple, company, none). Our form might
    transfer values like 'Frau', 'Herr' and so on. So we need to map 'Frau' to 'mrs', 'Herr' to 'mr' etc.

    salutation {
        fieldName = form-field-name-for-salutation
        options {
            mr = Herr
            mrs = Frau
            married-couple = Eheleute
            company = Firma
            none = keine Auswahl
        }
    }

- some api fields are the sum of several form fields, eg. the api field "birthday" might consist of the form fields
  "form-day", "form-month" and "form-year". We can specifiy a concatination.

  birthday {
      fieldName = form-field-name-for-birthday
      concat {
          1 = form-year
          2 = form-month
          3 = form-day
          separator = -
      }
  }

- there might be information that cannot be mapped to a certain api field but needs to be transferred nevertheless. We
  can specify information that is collected in the comment field. E.g.

  privacy {
      addToComment = 1
      commentLabel = Datenschutzerklärung wurde zugestimmt
  }
