<?php
namespace Daho\SgEstateCore\Tasks;

class GeocodeAdditionalFieldProvider implements \TYPO3\CMS\Scheduler\AdditionalFieldProviderInterface {

    /**
     * Gets additional fields to render in the form to add/edit a task
     *
     * @param array $taskInfo Values of the fields from the add/edit task form
     * @param \TYPO3\CMS\Scheduler\Task\AbstractTask $task The task object being edited. Null when adding a task!
     * @param \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule Reference to the scheduler backend module
     * @return array A two dimensional array, array('Identifier' => array('fieldId' => array('code' => '', 'label' => '', 'cshKey' => '', 'cshLabel' => ''))
     */
    public function getAdditionalFields(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule)
    {
        $additionalFields['task_sgestatecore_renewall'] = $this->getRenewAllAdditionalField($taskInfo, $task, $schedulerModule);
        $additionalFields['task_sgestatecore_apikey'] = $this->getApiKeyAdditionalField($taskInfo, $task, $schedulerModule);

        return $additionalFields;
    }

    public function validateAdditionalFields(array &$submittedData, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule)
    {
        return true;
    }

    public function saveAdditionalFields(array $submittedData, \TYPO3\CMS\Scheduler\Task\AbstractTask $task)
    {
        /**
         * @var $task \Daho\SgEstateCore\Tasks\Geocode
         */

        $task->setRenewAll($submittedData['task_sgestatecore_renewall']);
        $task->setApiKey($submittedData['task_sgestatecore_apikey']);
    }

    protected function getRenewAllAdditionalField(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
        /**
         * @var $task \Daho\SgEstateCore\Tasks\Geocode
         */

        if (empty($taskInfo['task_sgestatecore_renewall'])) {
            if ($schedulerModule->CMD === 'add') {
                $taskInfo['task_sgestatecore_renewall'] = 0;
            } elseif ($schedulerModule->CMD === 'edit') {
                $taskInfo['task_sgestatecore_renewall'] = $task->isRenewAll();
            }
        }

        $fieldName = 'tx_scheduler[task_sgestatecore_renewall]';
        $fieldId = 'task_sgestatecore_renewall';
        if ($taskInfo['task_sgestatecore_renewall'] == 1){
            $selected = 'checked="checked"';
        }else{
            $selected = '';
        }

        $fieldHtml = '<input type="checkbox" ' . 'name="' . $fieldName . '" ' . 'id="' . $fieldId . '" value="1" ' . $selected.' />';
        $fieldConfiguration = array(
            'code' => $fieldHtml,
            'label' => 'Alle Immobilien neu kodieren',
            'cshKey' => '_MOD_system_txschedulerM1',
            'cshLabel' => $fieldId
        );
        return $fieldConfiguration;
    }

    protected function getApiKeyAdditionalField(array &$taskInfo, $task, \TYPO3\CMS\Scheduler\Controller\SchedulerModuleController $schedulerModule){
        /**
         * @var $task \Daho\SgEstateCore\Tasks\Geocode
         */

        if (empty($taskInfo['task_sgestatecore_apikey'])) {
            if ($schedulerModule->CMD === 'add') {
                $taskInfo['task_sgestatecore_apikey'] = '';
            } elseif ($schedulerModule->CMD === 'edit') {
                $taskInfo['task_sgestatecore_apikey'] = $task->getApiKey();
            }
        }

        $fieldName = 'tx_scheduler[task_sgestatecore_apikey]';
        $fieldId = 'task_sgestatecore_apikey';


        $fieldHtml = '<input type="text" ' . 'name="' . $fieldName . '" ' . 'id="' . $fieldId . '" value="'.$taskInfo['task_sgestatecore_apikey'].'" />';
        $fieldConfiguration = array(
            'code' => $fieldHtml,
            'label' => 'Api Key',
            'cshKey' => '_MOD_system_txschedulerM1',
            'cshLabel' => $fieldId
        );
        return $fieldConfiguration;
    }

}