<?php
namespace Daho\SgEstateCore\Domain\Repository;

/**
 * The repository for Stadtteils
 */
class StadtteilRepository extends \TYPO3\CMS\Extbase\Persistence\Repository {

    public function initializeObject() {
        /** @var $querySettings \TYPO3\CMS\Extbase\Persistence\Generic\Typo3QuerySettings */
        $querySettings = $this->objectManager->get('TYPO3\\CMS\\Extbase\\Persistence\\Generic\\Typo3QuerySettings');
        $querySettings->setRespectStoragePage(FALSE);
        $this->setDefaultQuerySettings($querySettings);
    }

    protected $defaultOrderings = array(
        'bezeichner' => \TYPO3\CMS\Extbase\Persistence\QueryInterface::ORDER_ASCENDING,
    );

    public function getAllForFilter($format = null){
        /**
         * @var $item \Daho\SgEstateCore\Domain\Model\Stadtteil
         */

        $query = $this->createQuery();
        $result = $query->execute();
        foreach ($result as $item){
            if ($item instanceof \Daho\SgEstateCore\Domain\Model\Stadtteil){
                if ($item->getOrt() instanceof \Daho\SgEstateCore\Domain\Model\Ort){
                    if ($format == null){
                        $return[$item->getUid()] = $item->getBezeichner();
                    }else{
                        $temp = str_replace('%city%',$item->getOrt()->getBezeichner(),$format);
                        $temp = str_replace('%district%', $item->getBezeichner(), $temp);
                        $return[$item->getUid()] = $temp;
                    }

                }
            }
        }
        return $return;
    }
	
}