<?php
namespace SG\SgEstateCore\ViewHelpers;

use TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper;

class RealtiesCountViewHelper extends AbstractViewHelper
{
    public function initializeArguments(): void
    {
        parent::initializeArguments();
        $this->registerArgument('city', 'object', 'City @deprecated Use cities instead');
        $this->registerArgument('cities', 'mixed', 'Cities array or collection');
        $this->registerArgument('district', 'object', 'District @deprecated Use districts instead');
        $this->registerArgument('districts', 'mixed', 'Districts array or collection');
        $this->registerArgument('kindsOfObject', 'array', 'Array of Kind of Object Tokens');
    }

    public function render(){

        $sum = 0;
        $countLists = $this->getCountLists();
        $kinds = $this->arguments['kindsOfObject'];

        foreach( $countLists as $list ) {
            // check whether we actually have a list available
            if( $list !== false && isset($list['_GESAMT']) ) {
                // maybe count only certain kinds of objects
                if( is_array( $kinds ) && count($kinds) > 0 ) {
                    foreach( $kinds as $kind ) {
                        if( isset( $list[$kind] ) && $list[$kind] > 0 ) {
                            $sum += $list[$kind];
                        }
                    }
                } else {
                    $sum += $list['_GESAMT'];
                }
            }
        }

        return $sum;
    }

    /**
     * Get the decoded count json from the object if it exists
     *
     * @param $object
     *
     * @return mixed
     */
    private function extractCountList( $object ) {
        if( method_exists($object, 'getAnzahlImmobilienArray') ) {
            return $object->getAnzahlImmobilienArray();
        }
        return false;
    }

    /**
     * Get the decoded count jsons from a countable collection
     *
     * @param $objects
     *
     * @return array
     */
    private function extractCountLists( $objects ) {
        $lists = [];
        foreach( $objects as $object ) {
            $lists[] = $this->extractCountList($object);
        }
        return $lists;
    }

    /**
     * Decide which argument we should take and return the corresponding
     * count json sets as array
     *
     * @return array
     */
    private function getCountLists(): array
    {
        // if districts are set, use them. if not use the assigned cities
        if( $this->arguments['district'] !== null ) {
            return [ $this->extractCountList($this->arguments[ 'district' ]) ];
        }
        if( $this->arguments['districts'] !== null && count($this->arguments['districts']) > 0 ) {
            return $this->extractCountLists($this->arguments['districts']);
        }
        if( $this->arguments['city'] !== null ) {
            return [ $this->extractCountList($this->arguments['city']) ];
        }
        if( $this->arguments['cities'] !== null && count($this->arguments['cities']) > 0 ) {
            return $this->extractCountLists($this->arguments['cities']);
        }
        return [];
    }
}