<?php
namespace SG\SgEstateCore\ViewHelpers;

class ContactportraitViewHelper extends \TYPO3Fluid\Fluid\Core\ViewHelper\AbstractViewHelper{
    public function initializeArguments(): void
    {
        parent::initializeArguments(); // TODO: Change the autogenerated stub
        $this->registerArgument('token', 'string', 'Token to find PortraitImage');
    }

    public function render(){
        /**
         * @var $kontaktpersonbildRepository \SG\SgEstateCore\Domain\Repository\KontaktpersonBildRepository
         * @var $portrait \SG\SgEstateCore\Domain\Model\KontaktpersonBild
         */
        $kontaktpersonbildRepository = $this->objectManager->get('SG\SgEstateCore\Domain\Repository\KontaktpersonBildRepository');
        $portrait = $kontaktpersonbildRepository->findOneByToken($this->arguments['token']);

        if ($portrait instanceof \SG\SgEstateCore\Domain\Model\KontaktpersonBild){
            $storageConfiguration = $portrait->getFoto()->getOriginalResource()->getStorage()->getConfiguration();
            return $storageConfiguration['basePath'].substr($portrait->getFoto()->getOriginalResource()->getIdentifier(),1);
        }else{
            return null;
        }
    }
}
