<?php
namespace SG\SgEstateCore\Util;

use Exception;
use TYPO3\CMS\Core\Session\Backend\Exception\SessionNotCreatedException;
use TYPO3\CMS\Core\Session\UserSession;
use TYPO3\CMS\Core\Session\UserSessionManager;

class SessionHandler {

    private string $sessionKey = 'sg_estate';

    private ?UserSession $activeSession = null;

    protected UserSessionManager $userSessionManager;

    public function __construct()
    {
        $this->userSessionManager = UserSessionManager::create('FE');
    }

    /**
     * @throws SessionNotCreatedException
     */
    public function getSession(): UserSession
    {
        if ($this->activeSession !== null){
            return $this->activeSession;
        }
        try {
            $this->activeSession = $this->userSessionManager->createSessionFromStorage((string)$_COOKIE[$this->sessionKey]);
        } catch (Exception) {
            $this->activeSession = $this->userSessionManager->createFromRequestOrAnonymous($GLOBALS['TYPO3_REQUEST'], $this->sessionKey);
            $this->activeSession = $this->userSessionManager->fixateAnonymousSession($this->activeSession, true);
            setcookie(
                'sg_estate',
                $this->activeSession->getIdentifier(),
                time() + 86400,
                '/',
                '',
                true,
                true
            );
        }
        return $this->activeSession;
    }

    /**
     * Returns the object stored in the user´s PHP session
     * @throws SessionNotCreatedException
     */
    public function restoreFromSession(string $key): mixed {
        $session = $this->getSession();

        if ($session->hasData() && $session->get($key)) {
            return unserialize($session->get($key), ['allowed_classes' => true]);
        }
        return null;
    }

    /**
     * Writes an object into the PHP session
     * @throws SessionNotCreatedException
     */
    public function writeToSession(mixed $object, string $key): SessionHandler {
        $session = $this->getSession();
        $session->set($key, serialize($object));
        $this->userSessionManager->updateSession($session);
        return $this;
    }

    /**
     * Cleans up the session: removes the stored object from the PHP session
     * @throws SessionNotCreatedException
     * @noinspection PhpUnused
     */
    public function cleanUpSession(string $key): SessionHandler
    {
        $session = $this->getSession();
        $session->set($key, null);
        $this->userSessionManager->updateSession($session);
        return $this;
    }
}