<?php

declare(strict_types=1);

namespace SG\SgEstateCore\Upgrades;

use TYPO3\CMS\Core\Core\Environment;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Install\Attribute\UpgradeWizard;
use TYPO3\CMS\Install\Updates\UpgradeWizardInterface;

#[UpgradeWizard('sgestatecore_basicsetupwizard')]
final class BasicSetup implements UpgradeWizardInterface
{
    /**
     * Return the speaking name of this wizard
     */
    public function getTitle(): string
    {
        return 'Basic Setup for sg.estate.core';
    }

    /**
     * Return the description for this wizard
     */
    public function getDescription(): string
    {
        return 'Makes basic settings etc. for running the extension';
    }

    /**
     * Execute the update
     *
     * Called when a wizard reports that an update is necessary
     *
     * The boolean indicates whether the update was successful
     */
    public function executeUpdate(): bool
    {
        GeneralUtility::mkdir_deep(Environment::getPublicPath().'/uploads/tx_sgestatecore/media');
        if (is_dir(Environment::getPublicPath().'/uploads/tx_sgestatecore/media')){
            return true;
        }
        return false;
    }

    /**
     * Is an update necessary?
     *
     * Is used to determine whether a wizard needs to be run.
     * Check if data for migration exists.
     *
     * @return bool Whether an update is required (TRUE) or not (FALSE)
     */
    public function updateNecessary(): bool
    {
        if (!is_dir(Environment::getPublicPath().'/uploads/tx_sgestatecore/media')){
            return true;
        }
        return false;
    }

    /**
     * Returns an array of class names of prerequisite classes
     *
     * This way a wizard can define dependencies like "database up-to-date" or
     * "reference index updated"
     *
     * @return string[]
     */
    public function getPrerequisites(): array
    {
        return [];
    }
}
