<?php
namespace SG\SgEstateCore\Domain\Repository;

use SG\SgEstateCore\Domain\Model\Immobilie;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

/**
 * The repository for Stadtteils
 */
class StadtteilRepository extends AbstractEstateRepository {

    /**
     * @var ImmobilieRepository
     */
    private $immobilieRepository;

    public function __construct(\SG\SgEstateCore\Domain\Repository\ImmobilieRepository $immobilieRepository)
    {
        parent::__construct();
        $this->immobilieRepository = $immobilieRepository;
    }

    protected $defaultOrderings = array(
        'bezeichner' => \TYPO3\CMS\Extbase\Persistence\QueryInterface::ORDER_ASCENDING,
    );

    public function getAllForFilter($format = null, array $arrayOfImportIds = null){
        /**
         * @var $item \SG\SgEstateCore\Domain\Model\Stadtteil
         */

        if (is_array($arrayOfImportIds) && count($arrayOfImportIds) >= 1){
            $affectedRealties = $this->immobilieRepository->findAllForImportIds($arrayOfImportIds);
            $result = new ObjectStorage();
            foreach ($affectedRealties as $realtyItem){
                /**
                 * @var $realtyItem Immobilie
                 */
                $result->attach($realtyItem->getObjektStadtteil());
            }
        }else{
            $query = $this->createQuery();
            $result = $query->execute();
        }

        foreach ($result as $item){
            if ($item instanceof \SG\SgEstateCore\Domain\Model\Stadtteil){
                if ($item->getOrt() instanceof \SG\SgEstateCore\Domain\Model\Ort){
                    if ($format == null){
                        $return[$item->getUid()] = $item->getBezeichner();
                    }else{
                        $temp = str_replace('%city%',$item->getOrt()->getBezeichner(),$format);
                        $temp = str_replace('%district%', $item->getBezeichner(), $temp);
                        $return[$item->getUid()] = $temp;
                    }

                }
            }
        }
        return $return;
    }
	
}