<?php
namespace SG\SgEstateCore\Domain\Repository;

use SG\SgEstateCore\Domain\Model\Immobilie;
use SG\SgEstateCore\Domain\Model\Ort;
use SG\SgEstateCore\Domain\Model\Region;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;
use TYPO3\CMS\Extbase\Persistence\QueryInterface;

class RegionRepository extends AbstractEstateRepository {

    /**
     * @var ImmobilieRepository
     */
    private $immobilieRepository;

    public function __construct(\SG\SgEstateCore\Domain\Repository\ImmobilieRepository $immobilieRepository)
    {
        parent::__construct();
        $this->immobilieRepository = $immobilieRepository;
    }

    protected $defaultOrderings = array(
        'bezeichner' => QueryInterface::ORDER_ASCENDING,
    );

    public function getAllForFilter(array $arrayOfImportIds = null){
        /**
         * @var $item Region
         */
        $return = null;

        if (is_array($arrayOfImportIds) && count($arrayOfImportIds) >= 1){

            $affectedRealties = $this->immobilieRepository->findAllForImportIds($arrayOfImportIds);
            $result = new ObjectStorage();
            foreach ($affectedRealties as $realtyItem){
                /**
                 * @var $realtyItem Immobilie
                 */
                if ($realtyItem->getObjektOrt() instanceof Ort){
                    $tempRegions = $this->findRegionsForCity($realtyItem->getObjektOrt());
                    foreach ($tempRegions as $region){
                        $result->attach($region);
                    }
                }
            }
        }else{
            $query = $this->createQuery();
            $result = $query->execute();
        }

        foreach ($result as $item){
            if ($item instanceof Region){
                $return[$item->getUid()] = $item->getBezeichner();
            }
        }
        return $return;
    }

    public function findRegionsForCity(Ort $ort){
        $query = $this->createQuery();

        $constraint = $query->contains('orte', $ort);

        $query->matching($constraint);
        $result = $query->execute();


        return $result;
    }
}