<?php

namespace SG\SgEstateCore\Domain\Model;

use JsonException;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

class Stadtteil extends AbstractEntity {

    protected string $bezeichner = '';
    protected string $anzahlImmobilien = '';
    protected bool $fuerSucheVerwenden = FALSE;
    protected Ort $ort;
    /** @var ObjectStorage<Stadtteil>|null */
    protected ?ObjectStorage $nachbarStadtteile = null;

    protected function initStorageObjects(): void
    {
        $this->nachbarStadtteile = new ObjectStorage();
    }

    public function getBezeichner(): string
    {
        return $this->bezeichner;
    }

    public function setBezeichner(string $bezeichner): void {
        $this->bezeichner = $bezeichner;
    }

    public function getFuerSucheVerwenden(): bool
    {
        return $this->fuerSucheVerwenden;
    }

    public function setFuerSucheVerwenden(bool $fuerSucheVerwenden): void {
        $this->fuerSucheVerwenden = $fuerSucheVerwenden;
    }

    public function isFuerSucheVerwenden(): bool
    {
        return $this->fuerSucheVerwenden;
    }

    public function getOrt(): Ort
    {
        return $this->ort;
    }

    public function setNachbarStadtteile(ObjectStorage $nachbarStadtteile): void
    {
        $this->nachbarStadtteile = $nachbarStadtteile;
    }

    public function getNachbarStadtteile(): ObjectStorage
    {
        return $this->nachbarStadtteile;
    }

    public function getAnzahlImmobilien(): string
    {
        return $this->anzahlImmobilien;
    }

    /**
     * @throws JsonException
     */
    public function getAnzahlImmobilienArray(): mixed
    {
        return json_decode($this->anzahlImmobilien, true, 512, JSON_THROW_ON_ERROR);
    }

    public function setAnzahlImmobilien(string $anzahlImmobilien): void
    {
        $this->anzahlImmobilien = $anzahlImmobilien;
    }
}