<?php

namespace SG\SgEstateCore\Domain\Model;

use JsonException;
use TYPO3\CMS\Extbase\Annotation\ORM\Cascade;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

class Ort extends AbstractEntity {

    protected string $bezeichner = '';
    protected string $anzahlImmobilien = '';
    protected bool $fuerSucheVerwenden = false;

    /** @var ObjectStorage<Stadtteil>|null */
    #[Cascade(['value' => 'remove'])]
    protected ?ObjectStorage $stadtteile = null;

    public function __construct() {
        //Do not remove the next line: It would break the functionality
        $this->initStorageObjects();
    }

    protected function initStorageObjects(): void
    {
        $this->stadtteile = new ObjectStorage();
    }

    public function getBezeichner(): string
    {
        return $this->bezeichner;
    }

    public function setBezeichner(string $bezeichner): void {
        $this->bezeichner = $bezeichner;
    }

    public function getAnzahlImmobilien(): string
    {
        return $this->anzahlImmobilien;
    }

    /**
     * @throws JsonException
     */
    public function getAnzahlImmobilienArray(): mixed
    {
        return json_decode($this->anzahlImmobilien, true, 512, JSON_THROW_ON_ERROR);
    }

    public function setAnzahlImmobilien(string $anzahlImmobilien): void {
        $this->anzahlImmobilien = $anzahlImmobilien;
    }

    public function getFuerSucheVerwenden(): bool
    {
        return $this->fuerSucheVerwenden;
    }

    public function setFuerSucheVerwenden(bool $fuerSucheVerwenden): void {
        $this->fuerSucheVerwenden = $fuerSucheVerwenden;
    }

    public function isFuerSucheVerwenden(): bool
    {
        return $this->fuerSucheVerwenden;
    }

    public function addStadtteile(Stadtteil $stadtteile): void {
        $this->stadtteile->attach($stadtteile);
    }

    public function removeStadtteile(Stadtteil $stadtteileToRemove): void {
        $this->stadtteile->detach($stadtteileToRemove);
    }

    public function getStadtteile(): ?ObjectStorage
    {
        return $this->stadtteile;
    }

    public function setStadtteile(ObjectStorage $stadtteile): void {
        $this->stadtteile = $stadtteile;
    }
}