<?php
namespace SG\SgEstateCore\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

class Objektart extends AbstractEntity {

	protected string $bezeichner = '';
	protected string $kuerzel = '';
    /** @var ObjectStorage<Objektarttyp>|null */
    protected ?ObjectStorage $objektarttypen = null;

    public function __construct() {
        $this->objektarttypen = new ObjectStorage();
    }

	public function getBezeichner(): string
    {
		return $this->bezeichner;
	}

	public function setBezeichner(string $bezeichner): void {
		$this->bezeichner = $bezeichner;
	}

	public function getKuerzel(): string
    {
		return $this->kuerzel;
	}

	public function setKuerzel(string $kuerzel): void {
		$this->kuerzel = $kuerzel;
	}

    public function setObjektarttypen(ObjectStorage $objektarttypen): void {
        $this->objektarttypen = $objektarttypen;
    }

    public function getObjektarttypen(): ObjectStorage
    {
        return $this->objektarttypen;
    }

    public function addObjektarttyp(Objektarttyp $objektarttyp): void {
        $this->objektarttypen->attach($objektarttyp);
    }

    public function removeObjektarttyp(Objektarttyp $objektarttyp): void {
        $this->objektarttypen->detach($objektarttyp);
    }
}