<?php

namespace SG\SgEstateCore\Domain\Model;

use TYPO3\CMS\Extbase\Domain\Model\FileReference;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

class Kontaktperson extends AbstractEntity {

	protected string $name = '';
	protected string $vorname = '';
	protected string $titel = '';
	protected string $anrede = '';
	protected string $position = '';
	protected string $anredeBrief = '';
	protected string $firma = '';
	protected string $zusatzfeld = '';
	protected string $strasse = '';
	protected string $hausnummer = '';
	protected string $plz = '';
	protected string $postfach = '';
	protected string $postfachPlz = '';
	protected string $emailZentrale = '';
	protected string $emailDirekt = '';
	protected string $emailPrivat = '';
	protected string $emailSonstige = '';
	protected string $emailFeedback = '';
	protected string $telefonZentrale = '';
	protected string $telefonDurchwahl = '';
	protected string $telefonFax = '';
	protected string $telefonHandy = '';
	protected string $telefonPrivat = '';
	protected string $telefonSonstige = '';
	protected string $url = '';
	protected bool $adressfreigabe = FALSE;
	protected string $personennummer = '';
	protected string $immobilientreuhaenderid = '';
	protected ?FileReference $foto = NULL;
	protected string $freitextfeld = '';
	protected string $ort = '';
	protected string $postfachOrt = '';
	protected ?Land $land = null;

	public function getName(): string
    {
		return $this->name;
	}

	public function setName(string $name): void {
		$this->name = $name;
	}

	public function getVorname(): string
    {
		return $this->vorname;
	}

	public function setVorname(string $vorname): void {
		$this->vorname = $vorname;
	}

	public function getTitel(): string
    {
		return $this->titel;
	}

	public function setTitel(string $titel): void {
		$this->titel = $titel;
	}

	public function getAnrede(): string
    {
		return $this->anrede;
	}

	public function setAnrede(string $anrede): void {
		$this->anrede = $anrede;
	}

	public function getPosition(): string
    {
		return $this->position;
	}

	public function setPosition(string $position): void {
		$this->position = $position;
	}

	public function getAnredeBrief(): string
    {
		return $this->anredeBrief;
	}

	public function setAnredeBrief(string $anredeBrief): void {
		$this->anredeBrief = $anredeBrief;
	}

	public function getFirma(): string
    {
		return $this->firma;
	}

	public function setFirma(string $firma): void {
		$this->firma = $firma;
	}

	public function getZusatzfeld(): string
    {
		return $this->zusatzfeld;
	}

	public function setZusatzfeld(string $zusatzfeld): void {
		$this->zusatzfeld = $zusatzfeld;
	}

	public function getStrasse(): string
    {
		return $this->strasse;
	}

	public function setStrasse(string $strasse): void {
		$this->strasse = $strasse;
	}

	public function getHausnummer(): string
    {
		return $this->hausnummer;
	}

	public function setHausnummer(string $hausnummer): void {
		$this->hausnummer = $hausnummer;
	}

	public function getPlz(): string
    {
		return $this->plz;
	}

	public function setPlz(string $plz): void {
		$this->plz = $plz;
	}

	public function getPostfach(): string
    {
		return $this->postfach;
	}

	public function setPostfach(string $postfach): void {
		$this->postfach = $postfach;
	}

	public function getPostfachPlz(): string
    {
		return $this->postfachPlz;
	}

	public function setPostfachPlz(string $postfachPlz): void {
		$this->postfachPlz = $postfachPlz;
	}

	public function getEmailZentrale(): string
    {
		return $this->emailZentrale;
	}

	public function setEmailZentrale(string $emailZentrale): void {
		$this->emailZentrale = $emailZentrale;
	}

	public function getEmailDirekt(): string
    {
		return $this->emailDirekt;
	}

	public function setEmailDirekt(string $emailDirekt): void {
		$this->emailDirekt = $emailDirekt;
	}

	public function getEmailPrivat(): string
    {
		return $this->emailPrivat;
	}

	public function setEmailPrivat(string $emailPrivat): void {
		$this->emailPrivat = $emailPrivat;
	}

	public function getEmailSonstige(): string
    {
		return $this->emailSonstige;
	}

	public function setEmailSonstige(string $emailSonstige): void {
		$this->emailSonstige = $emailSonstige;
	}

	public function getEmailFeedback(): string
    {
		return $this->emailFeedback;
	}

	public function setEmailFeedback(string $emailFeedback): void {
		$this->emailFeedback = $emailFeedback;
	}

	public function getTelefonZentrale(): string
    {
		return $this->telefonZentrale;
	}

	public function setTelefonZentrale(string $telefonZentrale): void {
		$this->telefonZentrale = $telefonZentrale;
	}

	public function getTelefonDurchwahl(): string
    {
		return $this->telefonDurchwahl;
	}

	public function setTelefonDurchwahl(string $telefonDurchwahl): void {
		$this->telefonDurchwahl = $telefonDurchwahl;
	}

	public function getTelefonFax(): string
    {
		return $this->telefonFax;
	}

	public function setTelefonFax(string $telefonFax): void {
		$this->telefonFax = $telefonFax;
	}

	public function getTelefonHandy(): string
    {
		return $this->telefonHandy;
	}

	public function setTelefonHandy(string $telefonHandy): void {
		$this->telefonHandy = $telefonHandy;
	}

	public function getTelefonPrivat(): string
    {
		return $this->telefonPrivat;
	}

	public function setTelefonPrivat(string $telefonPrivat): void {
		$this->telefonPrivat = $telefonPrivat;
	}

	public function getTelefonSonstige(): string
    {
		return $this->telefonSonstige;
	}

	public function setTelefonSonstige(string $telefonSonstige): void {
		$this->telefonSonstige = $telefonSonstige;
	}

	public function getUrl(): string
    {
		return $this->url;
	}

	public function setUrl(string $url): void {
		$this->url = $url;
	}

	public function getAdressfreigabe(): bool
    {
		return $this->adressfreigabe;
	}

	public function setAdressfreigabe(bool $adressfreigabe): void {
		$this->adressfreigabe = $adressfreigabe;
	}

	public function isAdressfreigabe(): bool
    {
		return $this->adressfreigabe;
	}

	public function getPersonennummer(): string
    {
		return $this->personennummer;
	}

	public function setPersonennummer(string $personennummer): void {
		$this->personennummer = $personennummer;
	}

	public function getImmobilientreuhaenderid(): string
    {
		return $this->immobilientreuhaenderid;
	}

	public function setImmobilientreuhaenderid(string $immobilientreuhaenderid): void {
		$this->immobilientreuhaenderid = $immobilientreuhaenderid;
	}

	public function getFoto(): ?FileReference
    {
		return $this->foto;
	}

	public function setFoto(FileReference $foto): void {
		$this->foto = $foto;
	}

	public function getFreitextfeld(): string
    {
		return $this->freitextfeld;
	}

	public function setFreitextfeld(string $freitextfeld): void {
		$this->freitextfeld = $freitextfeld;
	}

	public function getOrt(): string
    {
		return $this->ort;
	}

	public function setOrt($ort): void {
		$this->ort = $ort;
	}

	public function getPostfachOrt(): string
    {
		return $this->postfachOrt;
	}

	public function setPostfachOrt($postfachOrt): void {
		$this->postfachOrt = $postfachOrt;
	}

	public function getLand(): ?Land
    {
		return $this->land;
	}

	public function setLand(Land $land): void {
		$this->land = $land;
	}

    public function getEmailName(): string
    {
        $temp = explode('@', $this->getEmailZentrale());
        return $temp[0];
    }

    public function getEmailDomain(): string
    {
        $temp = explode('@', $this->getEmailZentrale());
        return $temp[1];
    }
}