<?php

namespace SG\SgEstateCore\Domain\Model;

use TYPO3\CMS\Extbase\Domain\Model\FileReference;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

/** @noinspection PhpUnused */
class ContentBlock extends AbstractEntity
{

    protected string $internalIdentfier = '';
    protected string $headline = '';
    protected string $body = '';
    protected ?FileReference $imageMain = null;
    protected ?FileReference $imageOptional = null;
    protected string $linkCaption = '';
    protected string $link = '';
    protected string $blockType = '';
    protected ?ObjectStorage $districts = null;
    protected ?ObjectStorage $cities = null;
    protected ?ObjectStorage $regions = null;

    public function getInternalIdentfier(): string
    {
        return $this->internalIdentfier;
    }

    public function setInternalIdentfier(string $internalIdentfier): void
    {
        $this->internalIdentfier = $internalIdentfier;
    }

    public function getHeadline(): string
    {
        return $this->headline;
    }

    public function setHeadline(string $headline): void
    {
        $this->headline = $headline;
    }

    public function getBody(): string
    {
        return $this->body;
    }

    public function setBody(string $body): void
    {
        $this->body = $body;
    }

    public function getImageMain(): ?FileReference
    {
        return $this->imageMain;
    }

    public function setImageMain(FileReference $imageMain): void
    {
        $this->imageMain = $imageMain;
    }

    public function getImageOptional(): ?FileReference
    {
        return $this->imageOptional;
    }

    public function setImageOptional(FileReference $imageOptional): void
    {
        $this->imageOptional = $imageOptional;
    }

    public function getLinkCaption(): string
    {
        return $this->linkCaption;
    }

    public function setLinkCaption(string $linkCaption): void
    {
        $this->linkCaption = $linkCaption;
    }

    public function getLink(): string
    {
        return $this->link;
    }

    public function setLink(string $link): void
    {
        $this->link = $link;
    }

    public function getBlockType(): string
    {
        return $this->blockType;
    }

    public function setBlockType(string $blockType): void
    {
        $this->blockType = $blockType;
    }

    public function getDistricts(): ?ObjectStorage
    {
        return $this->districts;
    }

    public function setDistricts(ObjectStorage $districts): void
    {
        $this->districts = $districts;
    }

    public function getCities(): ?ObjectStorage
    {
        return $this->cities;
    }

    public function setCities(ObjectStorage $cities): void
    {
        $this->cities = $cities;
    }

    public function getRegions(): ?ObjectStorage
    {
        return $this->regions;
    }

    public function setRegions(ObjectStorage $regions): void
    {
        $this->regions = $regions;
    }
}